/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.NativeMeshUtil;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GImpactCollisionShape
extends CollisionShape {
    protected int numVertices;
    protected int numTriangles;
    protected int vertexStride;
    protected int triangleIndexStride;
    protected ByteBuffer triangleIndexBase;
    protected ByteBuffer vertexBase;
    protected long meshId = 0L;

    public GImpactCollisionShape() {
    }

    public GImpactCollisionShape(Mesh mesh) {
        this.createCollisionMesh(mesh);
    }

    private void createCollisionMesh(Mesh mesh) {
        this.triangleIndexBase = BufferUtils.createByteBuffer((int)(mesh.getTriangleCount() * 3 * 4));
        this.vertexBase = BufferUtils.createByteBuffer((int)(mesh.getVertexCount() * 3 * 4));
        this.numVertices = mesh.getVertexCount();
        this.vertexStride = 12;
        this.numTriangles = mesh.getTriangleCount();
        this.triangleIndexStride = 12;
        IndexBuffer indices = mesh.getIndicesAsList();
        FloatBuffer vertices = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        vertices.rewind();
        int verticesLength = mesh.getVertexCount() * 3;
        for (int i = 0; i < verticesLength; ++i) {
            float tempFloat = vertices.get();
            this.vertexBase.putFloat(tempFloat);
        }
        int indicesLength = mesh.getTriangleCount() * 3;
        for (int i = 0; i < indicesLength; ++i) {
            this.triangleIndexBase.putInt(indices.get(i));
        }
        vertices.rewind();
        vertices.clear();
        this.createShape();
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write(this.numVertices, "numVertices", 0);
        capsule.write(this.numTriangles, "numTriangles", 0);
        capsule.write(this.vertexStride, "vertexStride", 0);
        capsule.write(this.triangleIndexStride, "triangleIndexStride", 0);
        capsule.write(this.triangleIndexBase.array(), "triangleIndexBase", new byte[0]);
        capsule.write(this.vertexBase.array(), "vertexBase", new byte[0]);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.numVertices = capsule.readInt("numVertices", 0);
        this.numTriangles = capsule.readInt("numTriangles", 0);
        this.vertexStride = capsule.readInt("vertexStride", 0);
        this.triangleIndexStride = capsule.readInt("triangleIndexStride", 0);
        this.triangleIndexBase = ByteBuffer.wrap(capsule.readByteArray("triangleIndexBase", new byte[0]));
        this.vertexBase = ByteBuffer.wrap(capsule.readByteArray("vertexBase", new byte[0]));
        this.createShape();
    }

    protected void createShape() {
        this.meshId = NativeMeshUtil.createTriangleIndexVertexArray(this.triangleIndexBase, this.vertexBase, this.numTriangles, this.numVertices, this.vertexStride, this.triangleIndexStride);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Mesh {0}", Long.toHexString(this.meshId));
        this.objectId = this.createShape(this.meshId);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Shape {0}", Long.toHexString(this.objectId));
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private native long createShape(long var1);

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Finalizing Mesh {0}", Long.toHexString(this.meshId));
        this.finalizeNative(this.meshId);
    }

    private native void finalizeNative(long var1);
}

