/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.NativeMeshUtil;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MeshCollisionShape
extends CollisionShape {
    private static final String VERTEX_BASE = "vertexBase";
    private static final String TRIANGLE_INDEX_BASE = "triangleIndexBase";
    private static final String TRIANGLE_INDEX_STRIDE = "triangleIndexStride";
    private static final String VERTEX_STRIDE = "vertexStride";
    private static final String NUM_TRIANGLES = "numTriangles";
    private static final String NUM_VERTICES = "numVertices";
    private static final String NATIVE_BVH = "nativeBvh";
    protected int numVertices;
    protected int numTriangles;
    protected int vertexStride;
    protected int triangleIndexStride;
    protected ByteBuffer triangleIndexBase;
    protected ByteBuffer vertexBase;
    protected long meshId = 0L;
    protected long nativeBVHBuffer = 0L;
    private boolean memoryOptimized;

    public MeshCollisionShape() {
    }

    public MeshCollisionShape(Mesh mesh) {
        this(mesh, true);
    }

    public MeshCollisionShape(Mesh mesh, boolean memoryOptimized) {
        this.memoryOptimized = memoryOptimized;
        this.createCollisionMesh(mesh);
    }

    public MeshCollisionShape(ByteBuffer indices, ByteBuffer vertices, boolean memoryOptimized) {
        this.triangleIndexBase = indices;
        this.vertexBase = vertices;
        this.numVertices = vertices.limit() / 4 / 3;
        this.numTriangles = this.triangleIndexBase.limit() / 4 / 3;
        this.vertexStride = 12;
        this.triangleIndexStride = 12;
        this.memoryOptimized = memoryOptimized;
        this.createShape(true);
    }

    private void createCollisionMesh(Mesh mesh) {
        this.triangleIndexBase = BufferUtils.createByteBuffer((int)(mesh.getTriangleCount() * 3 * 4));
        this.vertexBase = BufferUtils.createByteBuffer((int)(mesh.getVertexCount() * 3 * 4));
        this.numVertices = mesh.getVertexCount();
        this.vertexStride = 12;
        this.numTriangles = mesh.getTriangleCount();
        this.triangleIndexStride = 12;
        IndexBuffer indices = mesh.getIndicesAsList();
        FloatBuffer vertices = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        vertices.rewind();
        int verticesLength = mesh.getVertexCount() * 3;
        for (int i = 0; i < verticesLength; ++i) {
            float tempFloat = vertices.get();
            this.vertexBase.putFloat(tempFloat);
        }
        int indicesLength = mesh.getTriangleCount() * 3;
        for (int i = 0; i < indicesLength; ++i) {
            this.triangleIndexBase.putInt(indices.get(i));
        }
        vertices.rewind();
        vertices.clear();
        this.createShape(true);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write(this.numVertices, NUM_VERTICES, 0);
        capsule.write(this.numTriangles, NUM_TRIANGLES, 0);
        capsule.write(this.vertexStride, VERTEX_STRIDE, 0);
        capsule.write(this.triangleIndexStride, TRIANGLE_INDEX_STRIDE, 0);
        this.triangleIndexBase.position(0);
        byte[] triangleIndexBasearray = new byte[this.triangleIndexBase.limit()];
        this.triangleIndexBase.get(triangleIndexBasearray);
        capsule.write(triangleIndexBasearray, TRIANGLE_INDEX_BASE, null);
        this.vertexBase.position(0);
        byte[] vertexBaseArray = new byte[this.vertexBase.limit()];
        this.vertexBase.get(vertexBaseArray);
        capsule.write(vertexBaseArray, VERTEX_BASE, null);
        if (this.memoryOptimized) {
            byte[] data = this.saveBVH(this.objectId);
            capsule.write(data, NATIVE_BVH, null);
        }
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.numVertices = capsule.readInt(NUM_VERTICES, 0);
        this.numTriangles = capsule.readInt(NUM_TRIANGLES, 0);
        this.vertexStride = capsule.readInt(VERTEX_STRIDE, 0);
        this.triangleIndexStride = capsule.readInt(TRIANGLE_INDEX_STRIDE, 0);
        this.triangleIndexBase = BufferUtils.createByteBuffer((byte[])capsule.readByteArray(TRIANGLE_INDEX_BASE, null));
        this.vertexBase = BufferUtils.createByteBuffer((byte[])capsule.readByteArray(VERTEX_BASE, null));
        byte[] nativeBvh = capsule.readByteArray(NATIVE_BVH, null);
        if (nativeBvh == null) {
            this.memoryOptimized = false;
            this.createShape(true);
        } else {
            this.memoryOptimized = true;
            this.createShape(false);
            this.nativeBVHBuffer = this.setBVH(nativeBvh, this.objectId);
        }
    }

    private void createShape(boolean buildBvt) {
        this.meshId = NativeMeshUtil.createTriangleIndexVertexArray(this.triangleIndexBase, this.vertexBase, this.numTriangles, this.numVertices, this.vertexStride, this.triangleIndexStride);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Mesh {0}", Long.toHexString(this.meshId));
        this.objectId = this.createShape(this.memoryOptimized, buildBvt, this.meshId);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Shape {0}", Long.toHexString(this.objectId));
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private native long setBVH(byte[] var1, long var2);

    private native byte[] saveBVH(long var1);

    private native long createShape(boolean var1, boolean var2, long var3);

    @Override
    public void finalize() throws Throwable {
        super.finalize();
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Finalizing Mesh {0}", Long.toHexString(this.meshId));
        if (this.meshId > 0L) {
            this.finalizeNative(this.meshId, this.nativeBVHBuffer);
        }
    }

    private native void finalizeNative(long var1, long var3);
}

