/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Plane;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlaneCollisionShape
extends CollisionShape {
    private Plane plane;

    public PlaneCollisionShape() {
    }

    public PlaneCollisionShape(Plane plane) {
        this.plane = plane;
        this.createShape();
    }

    public final Plane getPlane() {
        return this.plane;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write((Savable)this.plane, "collisionPlane", (Savable)new Plane());
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.plane = (Plane)capsule.readSavable("collisionPlane", (Savable)new Plane());
        this.createShape();
    }

    protected void createShape() {
        this.objectId = this.createShape(this.plane.getNormal(), this.plane.getConstant());
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Shape {0}", Long.toHexString(this.objectId));
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private native long createShape(Vector3f var1, float var2);
}

