/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;

public class CharacterControl
extends PhysicsCharacter
implements PhysicsControl,
JmeCloneable {
    protected Spatial spatial;
    protected boolean enabled = true;
    protected boolean added = false;
    protected PhysicsSpace space = null;
    protected Vector3f viewDirection = new Vector3f(Vector3f.UNIT_Z);
    protected boolean useViewDirection = true;
    protected boolean applyLocal = false;

    public CharacterControl() {
    }

    public CharacterControl(CollisionShape shape, float stepHeight) {
        super(shape, stepHeight);
    }

    public boolean isApplyPhysicsLocal() {
        return this.applyLocal;
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        this.applyLocal = applyPhysicsLocal;
    }

    private Vector3f getSpatialTranslation() {
        if (this.applyLocal) {
            return this.spatial.getLocalTranslation();
        }
        return this.spatial.getWorldTranslation();
    }

    public Control cloneForSpatial(Spatial spatial) {
        CharacterControl control = new CharacterControl(this.collisionShape, this.stepHeight);
        control.setCcdMotionThreshold(this.getCcdMotionThreshold());
        control.setCcdSweptSphereRadius(this.getCcdSweptSphereRadius());
        control.setCollideWithGroups(this.getCollideWithGroups());
        control.setCollisionGroup(this.getCollisionGroup());
        control.setFallSpeed(this.getFallSpeed());
        control.setGravity(this.getGravity());
        control.setJumpSpeed(this.getJumpSpeed());
        control.setMaxSlope(this.getMaxSlope());
        control.setPhysicsLocation(this.getPhysicsLocation());
        control.setUpAxis(this.getUpAxis());
        control.setApplyPhysicsLocal(this.isApplyPhysicsLocal());
        return control;
    }

    public Object jmeClone() {
        CharacterControl control = new CharacterControl(this.collisionShape, this.stepHeight);
        control.setCcdMotionThreshold(this.getCcdMotionThreshold());
        control.setCcdSweptSphereRadius(this.getCcdSweptSphereRadius());
        control.setCollideWithGroups(this.getCollideWithGroups());
        control.setCollisionGroup(this.getCollisionGroup());
        control.setFallSpeed(this.getFallSpeed());
        control.setGravity(this.getGravity());
        control.setJumpSpeed(this.getJumpSpeed());
        control.setMaxSlope(this.getMaxSlope());
        control.setPhysicsLocation(this.getPhysicsLocation());
        control.setUpAxis(this.getUpAxis());
        control.setApplyPhysicsLocal(this.isApplyPhysicsLocal());
        control.spatial = this.spatial;
        return control;
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.spatial = (Spatial)cloner.clone((Object)this.spatial);
    }

    public void setSpatial(Spatial spatial) {
        this.spatial = spatial;
        this.setUserObject(spatial);
        if (spatial == null) {
            return;
        }
        this.setPhysicsLocation(this.getSpatialTranslation());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.space != null) {
            if (enabled && !this.added) {
                if (this.spatial != null) {
                    this.warp(this.getSpatialTranslation());
                }
                this.space.addCollisionObject(this);
                this.added = true;
            } else if (!enabled && this.added) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setViewDirection(Vector3f vec) {
        this.viewDirection.set(vec);
    }

    public Vector3f getViewDirection() {
        return this.viewDirection;
    }

    public boolean isUseViewDirection() {
        return this.useViewDirection;
    }

    public void setUseViewDirection(boolean viewDirectionEnabled) {
        this.useViewDirection = viewDirectionEnabled;
    }

    public void update(float tpf) {
        if (this.enabled && this.spatial != null) {
            Quaternion localRotationQuat = this.spatial.getLocalRotation();
            Vector3f localLocation = this.spatial.getLocalTranslation();
            if (!this.applyLocal && this.spatial.getParent() != null) {
                this.getPhysicsLocation(localLocation);
                localLocation.subtractLocal(this.spatial.getParent().getWorldTranslation());
                localLocation.divideLocal(this.spatial.getParent().getWorldScale());
                this.tmp_inverseWorldRotation.set(this.spatial.getParent().getWorldRotation()).inverseLocal().multLocal(localLocation);
                this.spatial.setLocalTranslation(localLocation);
                if (this.useViewDirection) {
                    localRotationQuat.lookAt(this.viewDirection, Vector3f.UNIT_Y);
                    this.spatial.setLocalRotation(localRotationQuat);
                }
            } else {
                this.spatial.setLocalTranslation(this.getPhysicsLocation());
                localRotationQuat.lookAt(this.viewDirection, Vector3f.UNIT_Y);
                this.spatial.setLocalRotation(localRotationQuat);
            }
        }
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace space) {
        if (space == null) {
            if (this.space != null) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        } else {
            if (this.space == space) {
                return;
            }
            space.addCollisionObject(this);
            this.added = true;
        }
        this.space = space;
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.enabled, "enabled", true);
        oc.write(this.applyLocal, "applyLocalPhysics", false);
        oc.write(this.useViewDirection, "viewDirectionEnabled", true);
        oc.write((Savable)this.viewDirection, "viewDirection", (Savable)new Vector3f(Vector3f.UNIT_Z));
        oc.write((Savable)this.spatial, "spatial", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.enabled = ic.readBoolean("enabled", true);
        this.useViewDirection = ic.readBoolean("viewDirectionEnabled", true);
        this.viewDirection = (Vector3f)ic.readSavable("viewDirection", (Savable)new Vector3f(Vector3f.UNIT_Z));
        this.applyLocal = ic.readBoolean("applyLocalPhysics", false);
        this.spatial = (Spatial)ic.readSavable("spatial", null);
        this.setUserObject(this.spatial);
    }
}

