/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.objects.PhysicsGhostObject;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;

public class GhostControl
extends PhysicsGhostObject
implements PhysicsControl,
JmeCloneable {
    protected Spatial spatial;
    protected boolean enabled = true;
    protected boolean added = false;
    protected PhysicsSpace space = null;
    protected boolean applyLocal = false;

    public GhostControl() {
    }

    public GhostControl(CollisionShape shape) {
        super(shape);
    }

    public boolean isApplyPhysicsLocal() {
        return this.applyLocal;
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        this.applyLocal = applyPhysicsLocal;
    }

    private Vector3f getSpatialTranslation() {
        if (this.applyLocal) {
            return this.spatial.getLocalTranslation();
        }
        return this.spatial.getWorldTranslation();
    }

    private Quaternion getSpatialRotation() {
        if (this.applyLocal) {
            return this.spatial.getLocalRotation();
        }
        return this.spatial.getWorldRotation();
    }

    public Control cloneForSpatial(Spatial spatial) {
        GhostControl control = new GhostControl(this.collisionShape);
        control.setCcdMotionThreshold(this.getCcdMotionThreshold());
        control.setCcdSweptSphereRadius(this.getCcdSweptSphereRadius());
        control.setCollideWithGroups(this.getCollideWithGroups());
        control.setCollisionGroup(this.getCollisionGroup());
        control.setPhysicsLocation(this.getPhysicsLocation());
        control.setPhysicsRotation(this.getPhysicsRotationMatrix());
        control.setApplyPhysicsLocal(this.isApplyPhysicsLocal());
        return control;
    }

    public Object jmeClone() {
        GhostControl control = new GhostControl(this.collisionShape);
        control.setCcdMotionThreshold(this.getCcdMotionThreshold());
        control.setCcdSweptSphereRadius(this.getCcdSweptSphereRadius());
        control.setCollideWithGroups(this.getCollideWithGroups());
        control.setCollisionGroup(this.getCollisionGroup());
        control.setPhysicsLocation(this.getPhysicsLocation());
        control.setPhysicsRotation(this.getPhysicsRotationMatrix());
        control.setApplyPhysicsLocal(this.isApplyPhysicsLocal());
        control.spatial = this.spatial;
        return control;
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.spatial = (Spatial)cloner.clone((Object)this.spatial);
    }

    public void setSpatial(Spatial spatial) {
        this.spatial = spatial;
        this.setUserObject(spatial);
        if (spatial == null) {
            return;
        }
        this.setPhysicsLocation(this.getSpatialTranslation());
        this.setPhysicsRotation(this.getSpatialRotation());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.space != null) {
            if (enabled && !this.added) {
                if (this.spatial != null) {
                    this.setPhysicsLocation(this.getSpatialTranslation());
                    this.setPhysicsRotation(this.getSpatialRotation());
                }
                this.space.addCollisionObject(this);
                this.added = true;
            } else if (!enabled && this.added) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void update(float tpf) {
        if (!this.enabled) {
            return;
        }
        this.setPhysicsLocation(this.getSpatialTranslation());
        this.setPhysicsRotation(this.getSpatialRotation());
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace space) {
        if (space == null) {
            if (this.space != null) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        } else {
            if (this.space == space) {
                return;
            }
            space.addCollisionObject(this);
            this.added = true;
        }
        this.space = space;
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.enabled, "enabled", true);
        oc.write(this.applyLocal, "applyLocalPhysics", false);
        oc.write((Savable)this.spatial, "spatial", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.enabled = ic.readBoolean("enabled", true);
        this.spatial = (Spatial)ic.readSavable("spatial", null);
        this.applyLocal = ic.readBoolean("applyLocalPhysics", false);
        this.setUserObject(this.spatial);
    }
}

