/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HingeJoint
extends PhysicsJoint {
    protected Vector3f axisA;
    protected Vector3f axisB;
    protected boolean angularOnly = false;
    protected float biasFactor = 0.3f;
    protected float relaxationFactor = 1.0f;
    protected float limitSoftness = 0.9f;

    public HingeJoint() {
    }

    public HingeJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB, Vector3f axisA, Vector3f axisB) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.axisA = axisA;
        this.axisB = axisB;
        this.createJoint();
    }

    public void enableMotor(boolean enable, float targetVelocity, float maxMotorImpulse) {
        this.enableMotor(this.objectId, enable, targetVelocity, maxMotorImpulse);
    }

    private native void enableMotor(long var1, boolean var3, float var4, float var5);

    public boolean getEnableMotor() {
        return this.getEnableAngularMotor(this.objectId);
    }

    private native boolean getEnableAngularMotor(long var1);

    public float getMotorTargetVelocity() {
        return this.getMotorTargetVelocity(this.objectId);
    }

    private native float getMotorTargetVelocity(long var1);

    public float getMaxMotorImpulse() {
        return this.getMaxMotorImpulse(this.objectId);
    }

    private native float getMaxMotorImpulse(long var1);

    public void setLimit(float low, float high) {
        this.setLimit(this.objectId, low, high);
    }

    private native void setLimit(long var1, float var3, float var4);

    public void setLimit(float low, float high, float _softness, float _biasFactor, float _relaxationFactor) {
        this.biasFactor = _biasFactor;
        this.relaxationFactor = _relaxationFactor;
        this.limitSoftness = _softness;
        this.setLimit(this.objectId, low, high, _softness, _biasFactor, _relaxationFactor);
    }

    private native void setLimit(long var1, float var3, float var4, float var5, float var6, float var7);

    public float getUpperLimit() {
        return this.getUpperLimit(this.objectId);
    }

    private native float getUpperLimit(long var1);

    public float getLowerLimit() {
        return this.getLowerLimit(this.objectId);
    }

    private native float getLowerLimit(long var1);

    public void setAngularOnly(boolean angularOnly) {
        this.angularOnly = angularOnly;
        this.setAngularOnly(this.objectId, angularOnly);
    }

    private native void setAngularOnly(long var1, boolean var3);

    public float getHingeAngle() {
        return this.getHingeAngle(this.objectId);
    }

    private native float getHingeAngle(long var1);

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write((Savable)this.axisA, "axisA", (Savable)new Vector3f());
        capsule.write((Savable)this.axisB, "axisB", (Savable)new Vector3f());
        capsule.write(this.angularOnly, "angularOnly", false);
        capsule.write(this.getLowerLimit(), "lowerLimit", 1.0E30f);
        capsule.write(this.getUpperLimit(), "upperLimit", -1.0E30f);
        capsule.write(this.biasFactor, "biasFactor", 0.3f);
        capsule.write(this.relaxationFactor, "relaxationFactor", 1.0f);
        capsule.write(this.limitSoftness, "limitSoftness", 0.9f);
        capsule.write(this.getEnableMotor(), "enableAngularMotor", false);
        capsule.write(this.getMotorTargetVelocity(), "targetVelocity", 0.0f);
        capsule.write(this.getMaxMotorImpulse(), "maxMotorImpulse", 0.0f);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.axisA = (Vector3f)capsule.readSavable("axisA", (Savable)new Vector3f());
        this.axisB = (Vector3f)capsule.readSavable("axisB", (Savable)new Vector3f());
        this.angularOnly = capsule.readBoolean("angularOnly", false);
        float lowerLimit = capsule.readFloat("lowerLimit", 1.0E30f);
        float upperLimit = capsule.readFloat("upperLimit", -1.0E30f);
        this.biasFactor = capsule.readFloat("biasFactor", 0.3f);
        this.relaxationFactor = capsule.readFloat("relaxationFactor", 1.0f);
        this.limitSoftness = capsule.readFloat("limitSoftness", 0.9f);
        boolean enableAngularMotor = capsule.readBoolean("enableAngularMotor", false);
        float targetVelocity = capsule.readFloat("targetVelocity", 0.0f);
        float maxMotorImpulse = capsule.readFloat("maxMotorImpulse", 0.0f);
        this.createJoint();
        this.enableMotor(enableAngularMotor, targetVelocity, maxMotorImpulse);
        this.setLimit(lowerLimit, upperLimit, this.limitSoftness, this.biasFactor, this.relaxationFactor);
    }

    protected void createJoint() {
        this.objectId = this.createJoint(this.nodeA.getObjectId(), this.nodeB.getObjectId(), this.pivotA, this.axisA, this.pivotB, this.axisB);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Joint {0}", Long.toHexString(this.objectId));
    }

    private native long createJoint(long var1, long var3, Vector3f var5, Vector3f var6, Vector3f var7, Vector3f var8);
}

