/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SliderJoint
extends PhysicsJoint {
    protected Matrix3f rotA;
    protected Matrix3f rotB;
    protected boolean useLinearReferenceFrameA;

    public SliderJoint() {
    }

    public SliderJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB, Matrix3f rotA, Matrix3f rotB, boolean useLinearReferenceFrameA) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.rotA = rotA;
        this.rotB = rotB;
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        this.createJoint();
    }

    public SliderJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB, boolean useLinearReferenceFrameA) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        this.createJoint();
    }

    public float getLowerLinLimit() {
        return this.getLowerLinLimit(this.objectId);
    }

    private native float getLowerLinLimit(long var1);

    public void setLowerLinLimit(float lowerLinLimit) {
        this.setLowerLinLimit(this.objectId, lowerLinLimit);
    }

    private native void setLowerLinLimit(long var1, float var3);

    public float getUpperLinLimit() {
        return this.getUpperLinLimit(this.objectId);
    }

    private native float getUpperLinLimit(long var1);

    public void setUpperLinLimit(float upperLinLimit) {
        this.setUpperLinLimit(this.objectId, upperLinLimit);
    }

    private native void setUpperLinLimit(long var1, float var3);

    public float getLowerAngLimit() {
        return this.getLowerAngLimit(this.objectId);
    }

    private native float getLowerAngLimit(long var1);

    public void setLowerAngLimit(float lowerAngLimit) {
        this.setLowerAngLimit(this.objectId, lowerAngLimit);
    }

    private native void setLowerAngLimit(long var1, float var3);

    public float getUpperAngLimit() {
        return this.getUpperAngLimit(this.objectId);
    }

    private native float getUpperAngLimit(long var1);

    public void setUpperAngLimit(float upperAngLimit) {
        this.setUpperAngLimit(this.objectId, upperAngLimit);
    }

    private native void setUpperAngLimit(long var1, float var3);

    public float getSoftnessDirLin() {
        return this.getSoftnessDirLin(this.objectId);
    }

    private native float getSoftnessDirLin(long var1);

    public void setSoftnessDirLin(float softnessDirLin) {
        this.setSoftnessDirLin(this.objectId, softnessDirLin);
    }

    private native void setSoftnessDirLin(long var1, float var3);

    public float getRestitutionDirLin() {
        return this.getRestitutionDirLin(this.objectId);
    }

    private native float getRestitutionDirLin(long var1);

    public void setRestitutionDirLin(float restitutionDirLin) {
        this.setRestitutionDirLin(this.objectId, restitutionDirLin);
    }

    private native void setRestitutionDirLin(long var1, float var3);

    public float getDampingDirLin() {
        return this.getDampingDirLin(this.objectId);
    }

    private native float getDampingDirLin(long var1);

    public void setDampingDirLin(float dampingDirLin) {
        this.setDampingDirLin(this.objectId, dampingDirLin);
    }

    private native void setDampingDirLin(long var1, float var3);

    public float getSoftnessDirAng() {
        return this.getSoftnessDirAng(this.objectId);
    }

    private native float getSoftnessDirAng(long var1);

    public void setSoftnessDirAng(float softnessDirAng) {
        this.setSoftnessDirAng(this.objectId, softnessDirAng);
    }

    private native void setSoftnessDirAng(long var1, float var3);

    public float getRestitutionDirAng() {
        return this.getRestitutionDirAng(this.objectId);
    }

    private native float getRestitutionDirAng(long var1);

    public void setRestitutionDirAng(float restitutionDirAng) {
        this.setRestitutionDirAng(this.objectId, restitutionDirAng);
    }

    private native void setRestitutionDirAng(long var1, float var3);

    public float getDampingDirAng() {
        return this.getDampingDirAng(this.objectId);
    }

    private native float getDampingDirAng(long var1);

    public void setDampingDirAng(float dampingDirAng) {
        this.setDampingDirAng(this.objectId, dampingDirAng);
    }

    private native void setDampingDirAng(long var1, float var3);

    public float getSoftnessLimLin() {
        return this.getSoftnessLimLin(this.objectId);
    }

    private native float getSoftnessLimLin(long var1);

    public void setSoftnessLimLin(float softnessLimLin) {
        this.setSoftnessLimLin(this.objectId, softnessLimLin);
    }

    private native void setSoftnessLimLin(long var1, float var3);

    public float getRestitutionLimLin() {
        return this.getRestitutionLimLin(this.objectId);
    }

    private native float getRestitutionLimLin(long var1);

    public void setRestitutionLimLin(float restitutionLimLin) {
        this.setRestitutionLimLin(this.objectId, restitutionLimLin);
    }

    private native void setRestitutionLimLin(long var1, float var3);

    public float getDampingLimLin() {
        return this.getDampingLimLin(this.objectId);
    }

    private native float getDampingLimLin(long var1);

    public void setDampingLimLin(float dampingLimLin) {
        this.setDampingLimLin(this.objectId, dampingLimLin);
    }

    private native void setDampingLimLin(long var1, float var3);

    public float getSoftnessLimAng() {
        return this.getSoftnessLimAng(this.objectId);
    }

    private native float getSoftnessLimAng(long var1);

    public void setSoftnessLimAng(float softnessLimAng) {
        this.setSoftnessLimAng(this.objectId, softnessLimAng);
    }

    private native void setSoftnessLimAng(long var1, float var3);

    public float getRestitutionLimAng() {
        return this.getRestitutionLimAng(this.objectId);
    }

    private native float getRestitutionLimAng(long var1);

    public void setRestitutionLimAng(float restitutionLimAng) {
        this.setRestitutionLimAng(this.objectId, restitutionLimAng);
    }

    private native void setRestitutionLimAng(long var1, float var3);

    public float getDampingLimAng() {
        return this.getDampingLimAng(this.objectId);
    }

    private native float getDampingLimAng(long var1);

    public void setDampingLimAng(float dampingLimAng) {
        this.setDampingLimAng(this.objectId, dampingLimAng);
    }

    private native void setDampingLimAng(long var1, float var3);

    public float getSoftnessOrthoLin() {
        return this.getSoftnessOrthoLin(this.objectId);
    }

    private native float getSoftnessOrthoLin(long var1);

    public void setSoftnessOrthoLin(float softnessOrthoLin) {
        this.setSoftnessOrthoLin(this.objectId, softnessOrthoLin);
    }

    private native void setSoftnessOrthoLin(long var1, float var3);

    public float getRestitutionOrthoLin() {
        return this.getRestitutionOrthoLin(this.objectId);
    }

    private native float getRestitutionOrthoLin(long var1);

    public void setRestitutionOrthoLin(float restitutionOrthoLin) {
        this.setDampingOrthoLin(this.objectId, restitutionOrthoLin);
    }

    private native void setRestitutionOrthoLin(long var1, float var3);

    public float getDampingOrthoLin() {
        return this.getDampingOrthoLin(this.objectId);
    }

    private native float getDampingOrthoLin(long var1);

    public void setDampingOrthoLin(float dampingOrthoLin) {
        this.setDampingOrthoLin(this.objectId, dampingOrthoLin);
    }

    private native void setDampingOrthoLin(long var1, float var3);

    public float getSoftnessOrthoAng() {
        return this.getSoftnessOrthoAng(this.objectId);
    }

    private native float getSoftnessOrthoAng(long var1);

    public void setSoftnessOrthoAng(float softnessOrthoAng) {
        this.setSoftnessOrthoAng(this.objectId, softnessOrthoAng);
    }

    private native void setSoftnessOrthoAng(long var1, float var3);

    public float getRestitutionOrthoAng() {
        return this.getRestitutionOrthoAng(this.objectId);
    }

    private native float getRestitutionOrthoAng(long var1);

    public void setRestitutionOrthoAng(float restitutionOrthoAng) {
        this.setRestitutionOrthoAng(this.objectId, restitutionOrthoAng);
    }

    private native void setRestitutionOrthoAng(long var1, float var3);

    public float getDampingOrthoAng() {
        return this.getDampingOrthoAng(this.objectId);
    }

    private native float getDampingOrthoAng(long var1);

    public void setDampingOrthoAng(float dampingOrthoAng) {
        this.setDampingOrthoAng(this.objectId, dampingOrthoAng);
    }

    private native void setDampingOrthoAng(long var1, float var3);

    public boolean isPoweredLinMotor() {
        return this.isPoweredLinMotor(this.objectId);
    }

    private native boolean isPoweredLinMotor(long var1);

    public void setPoweredLinMotor(boolean poweredLinMotor) {
        this.setPoweredLinMotor(this.objectId, poweredLinMotor);
    }

    private native void setPoweredLinMotor(long var1, boolean var3);

    public float getTargetLinMotorVelocity() {
        return this.getTargetLinMotorVelocity(this.objectId);
    }

    private native float getTargetLinMotorVelocity(long var1);

    public void setTargetLinMotorVelocity(float targetLinMotorVelocity) {
        this.setTargetLinMotorVelocity(this.objectId, targetLinMotorVelocity);
    }

    private native void setTargetLinMotorVelocity(long var1, float var3);

    public float getMaxLinMotorForce() {
        return this.getMaxLinMotorForce(this.objectId);
    }

    private native float getMaxLinMotorForce(long var1);

    public void setMaxLinMotorForce(float maxLinMotorForce) {
        this.setMaxLinMotorForce(this.objectId, maxLinMotorForce);
    }

    private native void setMaxLinMotorForce(long var1, float var3);

    public boolean isPoweredAngMotor() {
        return this.isPoweredAngMotor(this.objectId);
    }

    private native boolean isPoweredAngMotor(long var1);

    public void setPoweredAngMotor(boolean poweredAngMotor) {
        this.setPoweredAngMotor(this.objectId, poweredAngMotor);
    }

    private native void setPoweredAngMotor(long var1, boolean var3);

    public float getTargetAngMotorVelocity() {
        return this.getTargetAngMotorVelocity(this.objectId);
    }

    private native float getTargetAngMotorVelocity(long var1);

    public void setTargetAngMotorVelocity(float targetAngMotorVelocity) {
        this.setTargetAngMotorVelocity(this.objectId, targetAngMotorVelocity);
    }

    private native void setTargetAngMotorVelocity(long var1, float var3);

    public float getMaxAngMotorForce() {
        return this.getMaxAngMotorForce(this.objectId);
    }

    private native float getMaxAngMotorForce(long var1);

    public void setMaxAngMotorForce(float maxAngMotorForce) {
        this.setMaxAngMotorForce(this.objectId, maxAngMotorForce);
    }

    private native void setMaxAngMotorForce(long var1, float var3);

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write(this.getDampingDirAng(), "dampingDirAng", 0.0f);
        capsule.write(this.getDampingDirLin(), "dampingDirLin", 0.0f);
        capsule.write(this.getDampingLimAng(), "dampingLimAng", 0.0f);
        capsule.write(this.getDampingLimLin(), "dampingLimLin", 0.0f);
        capsule.write(this.getDampingOrthoAng(), "dampingOrthoAng", 0.0f);
        capsule.write(this.getDampingOrthoLin(), "dampingOrthoLin", 0.0f);
        capsule.write(this.getLowerAngLimit(), "lowerAngLimit", 0.0f);
        capsule.write(this.getLowerLinLimit(), "lowerLinLimit", 0.0f);
        capsule.write(this.getMaxAngMotorForce(), "maxAngMotorForce", 0.0f);
        capsule.write(this.getMaxLinMotorForce(), "maxLinMotorForce", 0.0f);
        capsule.write(this.isPoweredAngMotor(), "poweredAngMotor", false);
        capsule.write(this.isPoweredLinMotor(), "poweredLinMotor", false);
        capsule.write(this.getRestitutionDirAng(), "restitutionDirAng", 0.0f);
        capsule.write(this.getRestitutionDirLin(), "restitutionDirLin", 0.0f);
        capsule.write(this.getRestitutionLimAng(), "restitutionLimAng", 0.0f);
        capsule.write(this.getRestitutionLimLin(), "restitutionLimLin", 0.0f);
        capsule.write(this.getRestitutionOrthoAng(), "restitutionOrthoAng", 0.0f);
        capsule.write(this.getRestitutionOrthoLin(), "restitutionOrthoLin", 0.0f);
        capsule.write(this.getSoftnessDirAng(), "softnessDirAng", 0.0f);
        capsule.write(this.getSoftnessDirLin(), "softnessDirLin", 0.0f);
        capsule.write(this.getSoftnessLimAng(), "softnessLimAng", 0.0f);
        capsule.write(this.getSoftnessLimLin(), "softnessLimLin", 0.0f);
        capsule.write(this.getSoftnessOrthoAng(), "softnessOrthoAng", 0.0f);
        capsule.write(this.getSoftnessOrthoLin(), "softnessOrthoLin", 0.0f);
        capsule.write(this.getTargetAngMotorVelocity(), "targetAngMotorVelicoty", 0.0f);
        capsule.write(this.getTargetLinMotorVelocity(), "targetLinMotorVelicoty", 0.0f);
        capsule.write(this.getUpperAngLimit(), "upperAngLimit", 0.0f);
        capsule.write(this.getUpperLinLimit(), "upperLinLimit", 0.0f);
        capsule.write(this.useLinearReferenceFrameA, "useLinearReferenceFrameA", false);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        float dampingDirAng = capsule.readFloat("dampingDirAng", 0.0f);
        float dampingDirLin = capsule.readFloat("dampingDirLin", 0.0f);
        float dampingLimAng = capsule.readFloat("dampingLimAng", 0.0f);
        float dampingLimLin = capsule.readFloat("dampingLimLin", 0.0f);
        float dampingOrthoAng = capsule.readFloat("dampingOrthoAng", 0.0f);
        float dampingOrthoLin = capsule.readFloat("dampingOrthoLin", 0.0f);
        float lowerAngLimit = capsule.readFloat("lowerAngLimit", 0.0f);
        float lowerLinLimit = capsule.readFloat("lowerLinLimit", 0.0f);
        float maxAngMotorForce = capsule.readFloat("maxAngMotorForce", 0.0f);
        float maxLinMotorForce = capsule.readFloat("maxLinMotorForce", 0.0f);
        boolean poweredAngMotor = capsule.readBoolean("poweredAngMotor", false);
        boolean poweredLinMotor = capsule.readBoolean("poweredLinMotor", false);
        float restitutionDirAng = capsule.readFloat("restitutionDirAng", 0.0f);
        float restitutionDirLin = capsule.readFloat("restitutionDirLin", 0.0f);
        float restitutionLimAng = capsule.readFloat("restitutionLimAng", 0.0f);
        float restitutionLimLin = capsule.readFloat("restitutionLimLin", 0.0f);
        float restitutionOrthoAng = capsule.readFloat("restitutionOrthoAng", 0.0f);
        float restitutionOrthoLin = capsule.readFloat("restitutionOrthoLin", 0.0f);
        float softnessDirAng = capsule.readFloat("softnessDirAng", 0.0f);
        float softnessDirLin = capsule.readFloat("softnessDirLin", 0.0f);
        float softnessLimAng = capsule.readFloat("softnessLimAng", 0.0f);
        float softnessLimLin = capsule.readFloat("softnessLimLin", 0.0f);
        float softnessOrthoAng = capsule.readFloat("softnessOrthoAng", 0.0f);
        float softnessOrthoLin = capsule.readFloat("softnessOrthoLin", 0.0f);
        float targetAngMotorVelicoty = capsule.readFloat("targetAngMotorVelicoty", 0.0f);
        float targetLinMotorVelicoty = capsule.readFloat("targetLinMotorVelicoty", 0.0f);
        float upperAngLimit = capsule.readFloat("upperAngLimit", 0.0f);
        float upperLinLimit = capsule.readFloat("upperLinLimit", 0.0f);
        this.useLinearReferenceFrameA = capsule.readBoolean("useLinearReferenceFrameA", false);
        this.createJoint();
        this.setDampingDirAng(dampingDirAng);
        this.setDampingDirLin(dampingDirLin);
        this.setDampingLimAng(dampingLimAng);
        this.setDampingLimLin(dampingLimLin);
        this.setDampingOrthoAng(dampingOrthoAng);
        this.setDampingOrthoLin(dampingOrthoLin);
        this.setLowerAngLimit(lowerAngLimit);
        this.setLowerLinLimit(lowerLinLimit);
        this.setMaxAngMotorForce(maxAngMotorForce);
        this.setMaxLinMotorForce(maxLinMotorForce);
        this.setPoweredAngMotor(poweredAngMotor);
        this.setPoweredLinMotor(poweredLinMotor);
        this.setRestitutionDirAng(restitutionDirAng);
        this.setRestitutionDirLin(restitutionDirLin);
        this.setRestitutionLimAng(restitutionLimAng);
        this.setRestitutionLimLin(restitutionLimLin);
        this.setRestitutionOrthoAng(restitutionOrthoAng);
        this.setRestitutionOrthoLin(restitutionOrthoLin);
        this.setSoftnessDirAng(softnessDirAng);
        this.setSoftnessDirLin(softnessDirLin);
        this.setSoftnessLimAng(softnessLimAng);
        this.setSoftnessLimLin(softnessLimLin);
        this.setSoftnessOrthoAng(softnessOrthoAng);
        this.setSoftnessOrthoLin(softnessOrthoLin);
        this.setTargetAngMotorVelocity(targetAngMotorVelicoty);
        this.setTargetLinMotorVelocity(targetLinMotorVelicoty);
        this.setUpperAngLimit(upperAngLimit);
        this.setUpperLinLimit(upperLinLimit);
    }

    protected void createJoint() {
        this.objectId = this.createJoint(this.nodeA.getObjectId(), this.nodeB.getObjectId(), this.pivotA, this.rotA, this.pivotB, this.rotB, this.useLinearReferenceFrameA);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Joint {0}", Long.toHexString(this.objectId));
    }

    private native long createJoint(long var1, long var3, Vector3f var5, Matrix3f var6, Vector3f var7, Matrix3f var8, boolean var9);
}

