/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhysicsCharacter
extends PhysicsCollisionObject {
    protected long characterId = 0L;
    protected float stepHeight;
    protected Vector3f walkDirection = new Vector3f();
    protected float fallSpeed = 55.0f;
    protected float jumpSpeed = 10.0f;
    protected int upAxis = 1;
    protected boolean locationDirty = false;
    protected final Quaternion tmp_inverseWorldRotation = new Quaternion();

    public PhysicsCharacter() {
    }

    public PhysicsCharacter(CollisionShape shape, float stepHeight) {
        this.collisionShape = shape;
        this.stepHeight = stepHeight;
        this.buildObject();
    }

    protected void buildObject() {
        if (this.objectId == 0L) {
            this.objectId = this.createGhostObject();
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Creating GhostObject {0}", Long.toHexString(this.objectId));
            this.initUserPointer();
        }
        this.setCharacterFlags(this.objectId);
        this.attachCollisionShape(this.objectId, this.collisionShape.getObjectId());
        if (this.characterId != 0L) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Clearing Character {0}", Long.toHexString(this.objectId));
            this.finalizeNativeCharacter(this.characterId);
        }
        this.characterId = this.createCharacterObject(this.objectId, this.collisionShape.getObjectId(), this.stepHeight);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Creating Character {0}", Long.toHexString(this.characterId));
    }

    private native long createGhostObject();

    private native void setCharacterFlags(long var1);

    private native long createCharacterObject(long var1, long var3, float var5);

    public void warp(Vector3f location) {
        this.warp(this.characterId, location);
    }

    private native void warp(long var1, Vector3f var3);

    public void setWalkDirection(Vector3f vec) {
        this.walkDirection.set(vec);
        this.setWalkDirection(this.characterId, vec);
    }

    private native void setWalkDirection(long var1, Vector3f var3);

    public Vector3f getWalkDirection() {
        return this.walkDirection;
    }

    public void setUpAxis(int axis) {
        this.upAxis = axis;
        this.setUpAxis(this.characterId, axis);
    }

    private native void setUpAxis(long var1, int var3);

    public int getUpAxis() {
        return this.upAxis;
    }

    public void setFallSpeed(float fallSpeed) {
        this.fallSpeed = fallSpeed;
        this.setFallSpeed(this.characterId, fallSpeed);
    }

    private native void setFallSpeed(long var1, float var3);

    public float getFallSpeed() {
        return this.fallSpeed;
    }

    public void setJumpSpeed(float jumpSpeed) {
        this.jumpSpeed = jumpSpeed;
        this.setJumpSpeed(this.characterId, jumpSpeed);
    }

    private native void setJumpSpeed(long var1, float var3);

    public float getJumpSpeed() {
        return this.jumpSpeed;
    }

    public void setGravity(float value) {
        this.setGravity(this.characterId, value);
    }

    private native void setGravity(long var1, float var3);

    public float getGravity() {
        return this.getGravity(this.characterId);
    }

    private native float getGravity(long var1);

    public void setMaxSlope(float slopeRadians) {
        this.setMaxSlope(this.characterId, slopeRadians);
    }

    private native void setMaxSlope(long var1, float var3);

    public float getMaxSlope() {
        return this.getMaxSlope(this.characterId);
    }

    private native float getMaxSlope(long var1);

    public boolean onGround() {
        return this.onGround(this.characterId);
    }

    private native boolean onGround(long var1);

    public void jump() {
        this.jump(this.characterId);
    }

    private native void jump(long var1);

    @Override
    public void setCollisionShape(CollisionShape collisionShape) {
        super.setCollisionShape(collisionShape);
        if (this.objectId == 0L) {
            this.buildObject();
        } else {
            this.attachCollisionShape(this.objectId, collisionShape.getObjectId());
        }
    }

    public void setPhysicsLocation(Vector3f location) {
        this.warp(location);
    }

    public Vector3f getPhysicsLocation(Vector3f trans) {
        if (trans == null) {
            trans = new Vector3f();
        }
        this.getPhysicsLocation(this.objectId, trans);
        return trans;
    }

    private native void getPhysicsLocation(long var1, Vector3f var3);

    public Vector3f getPhysicsLocation() {
        return this.getPhysicsLocation(null);
    }

    public void setCcdSweptSphereRadius(float radius) {
        this.setCcdSweptSphereRadius(this.objectId, radius);
    }

    private native void setCcdSweptSphereRadius(long var1, float var3);

    public void setCcdMotionThreshold(float threshold) {
        this.setCcdMotionThreshold(this.objectId, threshold);
    }

    private native void setCcdMotionThreshold(long var1, float var3);

    public float getCcdSweptSphereRadius() {
        return this.getCcdSweptSphereRadius(this.objectId);
    }

    private native float getCcdSweptSphereRadius(long var1);

    public float getCcdMotionThreshold() {
        return this.getCcdMotionThreshold(this.objectId);
    }

    private native float getCcdMotionThreshold(long var1);

    public float getCcdSquareMotionThreshold() {
        return this.getCcdSquareMotionThreshold(this.objectId);
    }

    private native float getCcdSquareMotionThreshold(long var1);

    public long getControllerId() {
        return this.characterId;
    }

    public void destroy() {
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule((Savable)this);
        capsule.write(this.stepHeight, "stepHeight", 1.0f);
        capsule.write(this.getGravity(), "gravity", 29.400002f);
        capsule.write(this.getMaxSlope(), "maxSlope", 1.0f);
        capsule.write(this.fallSpeed, "fallSpeed", 55.0f);
        capsule.write(this.jumpSpeed, "jumpSpeed", 10.0f);
        capsule.write(this.upAxis, "upAxis", 1);
        capsule.write(this.getCcdMotionThreshold(), "ccdMotionThreshold", 0.0f);
        capsule.write(this.getCcdSweptSphereRadius(), "ccdSweptSphereRadius", 0.0f);
        capsule.write((Savable)this.getPhysicsLocation(new Vector3f()), "physicsLocation", (Savable)new Vector3f());
    }

    @Override
    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule capsule = e.getCapsule((Savable)this);
        this.stepHeight = capsule.readFloat("stepHeight", 1.0f);
        this.buildObject();
        this.setGravity(capsule.readFloat("gravity", 29.400002f));
        this.setMaxSlope(capsule.readFloat("maxSlope", 1.0f));
        this.setFallSpeed(capsule.readFloat("fallSpeed", 55.0f));
        this.setJumpSpeed(capsule.readFloat("jumpSpeed", 10.0f));
        this.setUpAxis(capsule.readInt("upAxis", 1));
        this.setCcdMotionThreshold(capsule.readFloat("ccdMotionThreshold", 0.0f));
        this.setCcdSweptSphereRadius(capsule.readFloat("ccdSweptSphereRadius", 0.0f));
        this.setPhysicsLocation((Vector3f)capsule.readSavable("physicsLocation", (Savable)new Vector3f()));
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.finalizeNativeCharacter(this.characterId);
    }

    private native void finalizeNativeCharacter(long var1);
}

