/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.VehicleWheel;
import com.jme3.bullet.objects.infos.VehicleTuning;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhysicsVehicle
extends PhysicsRigidBody {
    protected long vehicleId = 0L;
    protected long rayCasterId = 0L;
    protected VehicleTuning tuning = new VehicleTuning();
    protected ArrayList<VehicleWheel> wheels = new ArrayList();
    protected PhysicsSpace physicsSpace;

    public PhysicsVehicle() {
    }

    public PhysicsVehicle(CollisionShape shape) {
        super(shape);
    }

    public PhysicsVehicle(CollisionShape shape, float mass) {
        super(shape, mass);
    }

    public void updateWheels() {
        if (this.vehicleId != 0L) {
            for (int i = 0; i < this.wheels.size(); ++i) {
                this.updateWheelTransform(this.vehicleId, i, true);
                this.wheels.get(i).updatePhysicsState();
            }
        }
    }

    private native void updateWheelTransform(long var1, int var3, boolean var4);

    public void applyWheelTransforms() {
        if (this.wheels != null) {
            for (int i = 0; i < this.wheels.size(); ++i) {
                this.wheels.get(i).applyWheelTransform();
            }
        }
    }

    @Override
    protected void postRebuild() {
        super.postRebuild();
        this.motionState.setVehicle(this);
        this.createVehicle(this.physicsSpace);
    }

    public void createVehicle(PhysicsSpace space) {
        this.physicsSpace = space;
        if (space == null) {
            return;
        }
        if (space.getSpaceId() == 0L) {
            throw new IllegalStateException("Physics space is not initialized!");
        }
        if (this.rayCasterId != 0L) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Clearing RayCaster {0}", Long.toHexString(this.rayCasterId));
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Clearing Vehicle {0}", Long.toHexString(this.vehicleId));
            this.finalizeNative(this.rayCasterId, this.vehicleId);
        }
        this.rayCasterId = this.createVehicleRaycaster(this.objectId, space.getSpaceId());
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created RayCaster {0}", Long.toHexString(this.rayCasterId));
        this.vehicleId = this.createRaycastVehicle(this.objectId, this.rayCasterId);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Vehicle {0}", Long.toHexString(this.vehicleId));
        this.setCoordinateSystem(this.vehicleId, 0, 1, 2);
        for (VehicleWheel wheel : this.wheels) {
            wheel.setVehicleId(this.vehicleId, this.addWheel(this.vehicleId, wheel.getLocation(), wheel.getDirection(), wheel.getAxle(), wheel.getRestLength(), wheel.getRadius(), this.tuning, wheel.isFrontWheel()));
        }
    }

    private native long createVehicleRaycaster(long var1, long var3);

    private native long createRaycastVehicle(long var1, long var3);

    private native void setCoordinateSystem(long var1, int var3, int var4, int var5);

    private native int addWheel(long var1, Vector3f var3, Vector3f var4, Vector3f var5, float var6, float var7, VehicleTuning var8, boolean var9);

    public VehicleWheel addWheel(Vector3f connectionPoint, Vector3f direction, Vector3f axle, float suspensionRestLength, float wheelRadius, boolean isFrontWheel) {
        return this.addWheel(null, connectionPoint, direction, axle, suspensionRestLength, wheelRadius, isFrontWheel);
    }

    public VehicleWheel addWheel(Spatial spat, Vector3f connectionPoint, Vector3f direction, Vector3f axle, float suspensionRestLength, float wheelRadius, boolean isFrontWheel) {
        VehicleWheel wheel = null;
        wheel = spat == null ? new VehicleWheel(connectionPoint, direction, axle, suspensionRestLength, wheelRadius, isFrontWheel) : new VehicleWheel(spat, connectionPoint, direction, axle, suspensionRestLength, wheelRadius, isFrontWheel);
        wheel.setFrictionSlip(this.tuning.frictionSlip);
        wheel.setMaxSuspensionTravelCm(this.tuning.maxSuspensionTravelCm);
        wheel.setSuspensionStiffness(this.tuning.suspensionStiffness);
        wheel.setWheelsDampingCompression(this.tuning.suspensionCompression);
        wheel.setWheelsDampingRelaxation(this.tuning.suspensionDamping);
        wheel.setMaxSuspensionForce(this.tuning.maxSuspensionForce);
        this.wheels.add(wheel);
        if (this.vehicleId != 0L) {
            wheel.setVehicleId(this.vehicleId, this.addWheel(this.vehicleId, wheel.getLocation(), wheel.getDirection(), wheel.getAxle(), wheel.getRestLength(), wheel.getRadius(), this.tuning, wheel.isFrontWheel()));
        }
        return wheel;
    }

    public void removeWheel(int wheel) {
        this.wheels.remove(wheel);
        this.rebuildRigidBody();
    }

    public VehicleWheel getWheel(int wheel) {
        return this.wheels.get(wheel);
    }

    public int getNumWheels() {
        return this.wheels.size();
    }

    public float getFrictionSlip() {
        return this.tuning.frictionSlip;
    }

    public void setFrictionSlip(float frictionSlip) {
        this.tuning.frictionSlip = frictionSlip;
    }

    public void setFrictionSlip(int wheel, float frictionSlip) {
        this.wheels.get(wheel).setFrictionSlip(frictionSlip);
    }

    public void setRollInfluence(int wheel, float rollInfluence) {
        this.wheels.get(wheel).setRollInfluence(rollInfluence);
    }

    public float getMaxSuspensionTravelCm() {
        return this.tuning.maxSuspensionTravelCm;
    }

    public void setMaxSuspensionTravelCm(float maxSuspensionTravelCm) {
        this.tuning.maxSuspensionTravelCm = maxSuspensionTravelCm;
    }

    public void setMaxSuspensionTravelCm(int wheel, float maxSuspensionTravelCm) {
        this.wheels.get(wheel).setMaxSuspensionTravelCm(maxSuspensionTravelCm);
    }

    public float getMaxSuspensionForce() {
        return this.tuning.maxSuspensionForce;
    }

    public void setMaxSuspensionForce(float maxSuspensionForce) {
        this.tuning.maxSuspensionForce = maxSuspensionForce;
    }

    public void setMaxSuspensionForce(int wheel, float maxSuspensionForce) {
        this.wheels.get(wheel).setMaxSuspensionForce(maxSuspensionForce);
    }

    public float getSuspensionCompression() {
        return this.tuning.suspensionCompression;
    }

    public void setSuspensionCompression(float suspensionCompression) {
        this.tuning.suspensionCompression = suspensionCompression;
    }

    public void setSuspensionCompression(int wheel, float suspensionCompression) {
        this.wheels.get(wheel).setWheelsDampingCompression(suspensionCompression);
    }

    public float getSuspensionDamping() {
        return this.tuning.suspensionDamping;
    }

    public void setSuspensionDamping(float suspensionDamping) {
        this.tuning.suspensionDamping = suspensionDamping;
    }

    public void setSuspensionDamping(int wheel, float suspensionDamping) {
        this.wheels.get(wheel).setWheelsDampingRelaxation(suspensionDamping);
    }

    public float getSuspensionStiffness() {
        return this.tuning.suspensionStiffness;
    }

    public void setSuspensionStiffness(float suspensionStiffness) {
        this.tuning.suspensionStiffness = suspensionStiffness;
    }

    public void setSuspensionStiffness(int wheel, float suspensionStiffness) {
        this.wheels.get(wheel).setSuspensionStiffness(suspensionStiffness);
    }

    public void resetSuspension() {
        this.resetSuspension(this.vehicleId);
    }

    private native void resetSuspension(long var1);

    public void accelerate(float force) {
        for (int i = 0; i < this.wheels.size(); ++i) {
            this.accelerate(i, force);
        }
    }

    public void accelerate(int wheel, float force) {
        this.applyEngineForce(this.vehicleId, wheel, force);
    }

    private native void applyEngineForce(long var1, int var3, float var4);

    public void steer(float value) {
        for (int i = 0; i < this.wheels.size(); ++i) {
            if (!this.getWheel(i).isFrontWheel()) continue;
            this.steer(i, value);
        }
    }

    public void steer(int wheel, float value) {
        this.steer(this.vehicleId, wheel, value);
    }

    private native void steer(long var1, int var3, float var4);

    public void brake(float force) {
        for (int i = 0; i < this.wheels.size(); ++i) {
            this.brake(i, force);
        }
    }

    public void brake(int wheel, float force) {
        this.brake(this.vehicleId, wheel, force);
    }

    private native void brake(long var1, int var3, float var4);

    public float getCurrentVehicleSpeedKmHour() {
        return this.getCurrentVehicleSpeedKmHour(this.vehicleId);
    }

    private native float getCurrentVehicleSpeedKmHour(long var1);

    public Vector3f getForwardVector(Vector3f vector) {
        if (vector == null) {
            vector = new Vector3f();
        }
        this.getForwardVector(this.vehicleId, vector);
        return vector;
    }

    private native void getForwardVector(long var1, Vector3f var3);

    public long getVehicleId() {
        return this.vehicleId;
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.tuning = new VehicleTuning();
        this.tuning.frictionSlip = capsule.readFloat("frictionSlip", 10.5f);
        this.tuning.maxSuspensionTravelCm = capsule.readFloat("maxSuspensionTravelCm", 500.0f);
        this.tuning.maxSuspensionForce = capsule.readFloat("maxSuspensionForce", 6000.0f);
        this.tuning.suspensionCompression = capsule.readFloat("suspensionCompression", 0.83f);
        this.tuning.suspensionDamping = capsule.readFloat("suspensionDamping", 0.88f);
        this.tuning.suspensionStiffness = capsule.readFloat("suspensionStiffness", 5.88f);
        this.wheels = capsule.readSavableArrayList("wheelsList", new ArrayList());
        this.motionState.setVehicle(this);
        super.read(im);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write(this.tuning.frictionSlip, "frictionSlip", 10.5f);
        capsule.write(this.tuning.maxSuspensionTravelCm, "maxSuspensionTravelCm", 500.0f);
        capsule.write(this.tuning.maxSuspensionForce, "maxSuspensionForce", 6000.0f);
        capsule.write(this.tuning.suspensionCompression, "suspensionCompression", 0.83f);
        capsule.write(this.tuning.suspensionDamping, "suspensionDamping", 0.88f);
        capsule.write(this.tuning.suspensionStiffness, "suspensionStiffness", 5.88f);
        capsule.writeSavableArrayList(this.wheels, "wheelsList", new ArrayList());
        super.write(ex);
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Finalizing RayCaster {0}", Long.toHexString(this.rayCasterId));
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Finalizing Vehicle {0}", Long.toHexString(this.vehicleId));
        this.finalizeNative(this.rayCasterId, this.vehicleId);
    }

    private native void finalizeNative(long var1, long var3);
}

