/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.io.IOException;

public class VehicleWheel
implements Savable {
    protected long wheelId = 0L;
    protected int wheelIndex = 0;
    protected boolean frontWheel;
    protected Vector3f location = new Vector3f();
    protected Vector3f direction = new Vector3f();
    protected Vector3f axle = new Vector3f();
    protected float suspensionStiffness = 20.0f;
    protected float wheelsDampingRelaxation = 2.3f;
    protected float wheelsDampingCompression = 4.4f;
    protected float frictionSlip = 10.5f;
    protected float rollInfluence = 1.0f;
    protected float maxSuspensionTravelCm = 500.0f;
    protected float maxSuspensionForce = 6000.0f;
    protected float radius = 0.5f;
    protected float restLength = 1.0f;
    protected Vector3f wheelWorldLocation = new Vector3f();
    protected Quaternion wheelWorldRotation = new Quaternion();
    protected Spatial wheelSpatial;
    protected Matrix3f tmp_Matrix = new Matrix3f();
    protected final Quaternion tmp_inverseWorldRotation = new Quaternion();
    private boolean applyLocal = false;

    public VehicleWheel() {
    }

    public VehicleWheel(Spatial spat, Vector3f location, Vector3f direction, Vector3f axle, float restLength, float radius, boolean frontWheel) {
        this(location, direction, axle, restLength, radius, frontWheel);
        this.wheelSpatial = spat;
    }

    public VehicleWheel(Vector3f location, Vector3f direction, Vector3f axle, float restLength, float radius, boolean frontWheel) {
        this.location.set(location);
        this.direction.set(direction);
        this.axle.set(axle);
        this.frontWheel = frontWheel;
        this.restLength = restLength;
        this.radius = radius;
    }

    public void updatePhysicsState() {
        this.getWheelLocation(this.wheelId, this.wheelIndex, this.wheelWorldLocation);
        this.getWheelRotation(this.wheelId, this.wheelIndex, this.tmp_Matrix);
        this.wheelWorldRotation.fromRotationMatrix(this.tmp_Matrix);
    }

    private native void getWheelLocation(long var1, int var3, Vector3f var4);

    private native void getWheelRotation(long var1, int var3, Matrix3f var4);

    public void applyWheelTransform() {
        if (this.wheelSpatial == null) {
            return;
        }
        Quaternion localRotationQuat = this.wheelSpatial.getLocalRotation();
        Vector3f localLocation = this.wheelSpatial.getLocalTranslation();
        if (!this.applyLocal && this.wheelSpatial.getParent() != null) {
            localLocation.set(this.wheelWorldLocation).subtractLocal(this.wheelSpatial.getParent().getWorldTranslation());
            localLocation.divideLocal(this.wheelSpatial.getParent().getWorldScale());
            this.tmp_inverseWorldRotation.set(this.wheelSpatial.getParent().getWorldRotation()).inverseLocal().multLocal(localLocation);
            localRotationQuat.set(this.wheelWorldRotation);
            this.tmp_inverseWorldRotation.set(this.wheelSpatial.getParent().getWorldRotation()).inverseLocal().mult(localRotationQuat, localRotationQuat);
            this.wheelSpatial.setLocalTranslation(localLocation);
            this.wheelSpatial.setLocalRotation(localRotationQuat);
        } else {
            this.wheelSpatial.setLocalTranslation(this.wheelWorldLocation);
            this.wheelSpatial.setLocalRotation(this.wheelWorldRotation);
        }
    }

    public long getWheelId() {
        return this.wheelId;
    }

    public void setVehicleId(long vehicleId, int wheelIndex) {
        this.wheelId = vehicleId;
        this.wheelIndex = wheelIndex;
        this.applyInfo();
    }

    public boolean isFrontWheel() {
        return this.frontWheel;
    }

    public void setFrontWheel(boolean frontWheel) {
        this.frontWheel = frontWheel;
        this.applyInfo();
    }

    public Vector3f getLocation() {
        return this.location;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public Vector3f getAxle() {
        return this.axle;
    }

    public float getSuspensionStiffness() {
        return this.suspensionStiffness;
    }

    public void setSuspensionStiffness(float suspensionStiffness) {
        this.suspensionStiffness = suspensionStiffness;
        this.applyInfo();
    }

    public float getWheelsDampingRelaxation() {
        return this.wheelsDampingRelaxation;
    }

    public void setWheelsDampingRelaxation(float wheelsDampingRelaxation) {
        this.wheelsDampingRelaxation = wheelsDampingRelaxation;
        this.applyInfo();
    }

    public float getWheelsDampingCompression() {
        return this.wheelsDampingCompression;
    }

    public void setWheelsDampingCompression(float wheelsDampingCompression) {
        this.wheelsDampingCompression = wheelsDampingCompression;
        this.applyInfo();
    }

    public float getFrictionSlip() {
        return this.frictionSlip;
    }

    public void setFrictionSlip(float frictionSlip) {
        this.frictionSlip = frictionSlip;
        this.applyInfo();
    }

    public float getRollInfluence() {
        return this.rollInfluence;
    }

    public void setRollInfluence(float rollInfluence) {
        this.rollInfluence = rollInfluence;
        this.applyInfo();
    }

    public float getMaxSuspensionTravelCm() {
        return this.maxSuspensionTravelCm;
    }

    public void setMaxSuspensionTravelCm(float maxSuspensionTravelCm) {
        this.maxSuspensionTravelCm = maxSuspensionTravelCm;
        this.applyInfo();
    }

    public float getMaxSuspensionForce() {
        return this.maxSuspensionForce;
    }

    public void setMaxSuspensionForce(float maxSuspensionForce) {
        this.maxSuspensionForce = maxSuspensionForce;
        this.applyInfo();
    }

    private void applyInfo() {
        if (this.wheelId == 0L) {
            return;
        }
        this.applyInfo(this.wheelId, this.wheelIndex, this.suspensionStiffness, this.wheelsDampingRelaxation, this.wheelsDampingCompression, this.frictionSlip, this.rollInfluence, this.maxSuspensionTravelCm, this.maxSuspensionForce, this.radius, this.frontWheel, this.restLength);
    }

    private native void applyInfo(long var1, int var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, boolean var12, float var13);

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.applyInfo();
    }

    public float getRestLength() {
        return this.restLength;
    }

    public void setRestLength(float restLength) {
        this.restLength = restLength;
        this.applyInfo();
    }

    public PhysicsCollisionObject getGroundObject() {
        return null;
    }

    public Vector3f getCollisionLocation(Vector3f vec) {
        this.getCollisionLocation(this.wheelId, this.wheelIndex, vec);
        return vec;
    }

    private native void getCollisionLocation(long var1, int var3, Vector3f var4);

    public Vector3f getCollisionLocation() {
        Vector3f vec = new Vector3f();
        this.getCollisionLocation(this.wheelId, this.wheelIndex, vec);
        return vec;
    }

    public Vector3f getCollisionNormal(Vector3f vec) {
        this.getCollisionNormal(this.wheelId, this.wheelIndex, vec);
        return vec;
    }

    private native void getCollisionNormal(long var1, int var3, Vector3f var4);

    public Vector3f getCollisionNormal() {
        Vector3f vec = new Vector3f();
        this.getCollisionNormal(this.wheelId, this.wheelIndex, vec);
        return vec;
    }

    public float getSkidInfo() {
        return this.getSkidInfo(this.wheelId, this.wheelIndex);
    }

    public native float getSkidInfo(long var1, int var3);

    public float getDeltaRotation() {
        return this.getDeltaRotation(this.wheelId, this.wheelIndex);
    }

    public native float getDeltaRotation(long var1, int var3);

    public void read(JmeImporter im) throws IOException {
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.wheelSpatial = (Spatial)capsule.readSavable("wheelSpatial", null);
        this.frontWheel = capsule.readBoolean("frontWheel", false);
        this.location = (Vector3f)capsule.readSavable("wheelLocation", (Savable)new Vector3f());
        this.direction = (Vector3f)capsule.readSavable("wheelDirection", (Savable)new Vector3f());
        this.axle = (Vector3f)capsule.readSavable("wheelAxle", (Savable)new Vector3f());
        this.suspensionStiffness = capsule.readFloat("suspensionStiffness", 20.0f);
        this.wheelsDampingRelaxation = capsule.readFloat("wheelsDampingRelaxation", 2.3f);
        this.wheelsDampingCompression = capsule.readFloat("wheelsDampingCompression", 4.4f);
        this.frictionSlip = capsule.readFloat("frictionSlip", 10.5f);
        this.rollInfluence = capsule.readFloat("rollInfluence", 1.0f);
        this.maxSuspensionTravelCm = capsule.readFloat("maxSuspensionTravelCm", 500.0f);
        this.maxSuspensionForce = capsule.readFloat("maxSuspensionForce", 6000.0f);
        this.radius = capsule.readFloat("wheelRadius", 0.5f);
        this.restLength = capsule.readFloat("restLength", 1.0f);
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write((Savable)this.wheelSpatial, "wheelSpatial", null);
        capsule.write(this.frontWheel, "frontWheel", false);
        capsule.write((Savable)this.location, "wheelLocation", (Savable)new Vector3f());
        capsule.write((Savable)this.direction, "wheelDirection", (Savable)new Vector3f());
        capsule.write((Savable)this.axle, "wheelAxle", (Savable)new Vector3f());
        capsule.write(this.suspensionStiffness, "suspensionStiffness", 20.0f);
        capsule.write(this.wheelsDampingRelaxation, "wheelsDampingRelaxation", 2.3f);
        capsule.write(this.wheelsDampingCompression, "wheelsDampingCompression", 4.4f);
        capsule.write(this.frictionSlip, "frictionSlip", 10.5f);
        capsule.write(this.rollInfluence, "rollInfluence", 1.0f);
        capsule.write(this.maxSuspensionTravelCm, "maxSuspensionTravelCm", 500.0f);
        capsule.write(this.maxSuspensionForce, "maxSuspensionForce", 6000.0f);
        capsule.write(this.radius, "wheelRadius", 0.5f);
        capsule.write(this.restLength, "restLength", 1.0f);
    }

    public Spatial getWheelSpatial() {
        return this.wheelSpatial;
    }

    public void setWheelSpatial(Spatial wheelSpatial) {
        this.wheelSpatial = wheelSpatial;
    }

    public boolean isApplyLocal() {
        return this.applyLocal;
    }

    public void setApplyLocal(boolean applyLocal) {
        this.applyLocal = applyLocal;
    }

    public void getWheelWorldRotation(Quaternion store) {
        store.set(this.wheelWorldRotation);
    }

    public void getWheelWorldLocation(Vector3f store) {
        store.set(this.wheelWorldLocation);
    }
}

