/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.bullet.util.DebugMeshCallback;
import com.jme3.math.Matrix3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.TempVars;
import java.util.List;

public class DebugShapeFactory {
    public static Spatial getDebugShape(CollisionShape collisionShape) {
        Geometry debugShape;
        if (collisionShape == null) {
            return null;
        }
        if (collisionShape instanceof CompoundCollisionShape) {
            CompoundCollisionShape shape = (CompoundCollisionShape)collisionShape;
            List<ChildCollisionShape> children = shape.getChildren();
            Node node = new Node("DebugShapeNode");
            for (ChildCollisionShape childCollisionShape : children) {
                CollisionShape ccollisionShape = childCollisionShape.shape;
                Geometry geometry = DebugShapeFactory.createDebugShape(ccollisionShape);
                geometry.setLocalTranslation(childCollisionShape.location);
                TempVars vars = TempVars.get();
                Matrix3f tempRot = vars.tempMat3;
                tempRot.set(geometry.getLocalRotation());
                childCollisionShape.rotation.mult(tempRot, tempRot);
                geometry.setLocalRotation(tempRot);
                vars.release();
                node.attachChild((Spatial)geometry);
            }
            debugShape = node;
        } else {
            debugShape = DebugShapeFactory.createDebugShape(collisionShape);
        }
        if (debugShape == null) {
            return null;
        }
        debugShape.updateGeometricState();
        return debugShape;
    }

    private static Geometry createDebugShape(CollisionShape shape) {
        Geometry geom = new Geometry();
        geom.setMesh(DebugShapeFactory.getDebugMesh(shape));
        geom.updateModelBound();
        return geom;
    }

    public static Mesh getDebugMesh(CollisionShape shape) {
        Mesh mesh = new Mesh();
        mesh = new Mesh();
        DebugMeshCallback callback = new DebugMeshCallback();
        DebugShapeFactory.getVertices(shape.getObjectId(), callback);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, callback.getVertices());
        mesh.getFloatBuffer(VertexBuffer.Type.Position).clear();
        return mesh;
    }

    private static native void getVertices(long var0, DebugMeshCallback var2);
}

