/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class NativeMeshUtil {
    public static long getTriangleIndexVertexArray(Mesh mesh) {
        ByteBuffer triangleIndexBase = BufferUtils.createByteBuffer((int)(mesh.getTriangleCount() * 3 * 4));
        ByteBuffer vertexBase = BufferUtils.createByteBuffer((int)(mesh.getVertexCount() * 3 * 4));
        int numVertices = mesh.getVertexCount();
        int vertexStride = 12;
        int numTriangles = mesh.getTriangleCount();
        int triangleIndexStride = 12;
        IndexBuffer indices = mesh.getIndicesAsList();
        FloatBuffer vertices = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        vertices.rewind();
        int verticesLength = mesh.getVertexCount() * 3;
        for (int i = 0; i < verticesLength; ++i) {
            float tempFloat = vertices.get();
            vertexBase.putFloat(tempFloat);
        }
        int indicesLength = mesh.getTriangleCount() * 3;
        for (int i = 0; i < indicesLength; ++i) {
            triangleIndexBase.putInt(indices.get(i));
        }
        vertices.rewind();
        vertices.clear();
        return NativeMeshUtil.createTriangleIndexVertexArray(triangleIndexBase, vertexBase, numTriangles, numVertices, vertexStride, triangleIndexStride);
    }

    public static native long createTriangleIndexVertexArray(ByteBuffer var0, ByteBuffer var1, int var2, int var3, int var4, int var5);
}

