/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.bullet.animation.VectorSet;
import com.jme3.export.InputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.Control;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;

public class RagUtils {
    private static final Logger logger = Logger.getLogger(RagUtils.class.getName());

    private RagUtils() {
    }

    static Map<String, VectorSet> coordsMap(Mesh[] meshes, String[] managerMap) {
        float[] wArray = new float[4];
        int[] iArray = new int[4];
        Vector3f bindPosition = new Vector3f();
        HashMap<String, VectorSet> coordsMap = new HashMap<String, VectorSet>(32);
        for (Mesh mesh : meshes) {
            int numVertices = mesh.getVertexCount();
            for (int vertexI = 0; vertexI < numVertices; ++vertexI) {
                String managerName = RagUtils.findManager(mesh, vertexI, iArray, wArray, managerMap);
                VectorSet set = (VectorSet)coordsMap.get(managerName);
                if (set == null) {
                    set = new VectorSet(1);
                    coordsMap.put(managerName, set);
                }
                RagUtils.vertexVector3f(mesh, VertexBuffer.Type.BindPosePosition, vertexI, bindPosition);
                set.add(bindPosition);
            }
        }
        return coordsMap;
    }

    static Geometry findAnimatedGeometry(Spatial subtree) {
        Geometry result;
        block3: {
            block2: {
                boolean hasWeights;
                result = null;
                if (!(subtree instanceof Geometry)) break block2;
                Geometry geometry = (Geometry)subtree;
                Mesh mesh = geometry.getMesh();
                VertexBuffer indices = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
                boolean hasIndices = indices != null;
                VertexBuffer weights = mesh.getBuffer(VertexBuffer.Type.BoneWeight);
                boolean bl = hasWeights = weights != null;
                if (!hasIndices || !hasWeights) break block3;
                result = geometry;
                break block3;
            }
            if (subtree instanceof Node) {
                Spatial child;
                Node node = (Node)subtree;
                List children = node.getChildren();
                Iterator iterator = children.iterator();
                while (iterator.hasNext() && (result = RagUtils.findAnimatedGeometry(child = (Spatial)iterator.next())) == null) {
                }
            }
        }
        return result;
    }

    static int findIndex(Spatial spatial, Control sgc) {
        int numControls = spatial.getNumControls();
        int result = -1;
        for (int controlIndex = 0; controlIndex < numControls; ++controlIndex) {
            Control control = spatial.getControl(controlIndex);
            if (control != sgc) continue;
            result = controlIndex;
            break;
        }
        return result;
    }

    static Joint findMainBone(Armature skeleton, Mesh[] targetMeshes) {
        Joint result;
        Joint[] rootBones = skeleton.getRoots();
        if (rootBones.length == 1) {
            result = rootBones[0];
        } else {
            result = null;
            float[] totalWeights = RagUtils.totalWeights(targetMeshes, skeleton);
            float greatestTotalWeight = Float.NEGATIVE_INFINITY;
            for (Joint rootBone : rootBones) {
                int boneIndex = skeleton.getJointIndex(rootBone);
                float weight = totalWeights[boneIndex];
                if (!(weight > greatestTotalWeight)) continue;
                result = rootBone;
                greatestTotalWeight = weight;
            }
        }
        return result;
    }

    static List<Mesh> listAnimatedMeshes(Spatial subtree, List<Mesh> storeResult) {
        if (storeResult == null) {
            storeResult = new ArrayList<Mesh>(10);
        }
        if (subtree instanceof Geometry) {
            boolean hasWeights;
            Geometry geometry = (Geometry)subtree;
            Mesh mesh = geometry.getMesh();
            VertexBuffer indices = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
            boolean hasIndices = indices != null;
            VertexBuffer weights = mesh.getBuffer(VertexBuffer.Type.BoneWeight);
            boolean bl = hasWeights = weights != null;
            if (hasIndices && hasWeights && !storeResult.contains(mesh)) {
                storeResult.add(mesh);
            }
        } else if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                RagUtils.listAnimatedMeshes(child, storeResult);
            }
        }
        return storeResult;
    }

    static void meshToLocal(Joint parentBone, Transform transform) {
        Vector3f location = transform.getTranslation();
        Quaternion orientation = transform.getRotation();
        Vector3f scale = transform.getScale();
        Transform pmx = parentBone.getModelTransform();
        Vector3f pmTranslate = pmx.getTranslation();
        Quaternion pmRotInv = pmx.getRotation().inverse();
        Vector3f pmScale = pmx.getScale();
        location.subtractLocal(pmTranslate);
        location.divideLocal(pmScale);
        pmRotInv.mult(location, location);
        scale.divideLocal(pmScale);
        pmRotInv.mult(orientation, orientation);
    }

    static Transform[] readTransformArray(InputCapsule capsule, String fieldName) throws IOException {
        Transform[] result;
        Savable[] tmp = capsule.readSavableArray(fieldName, null);
        if (tmp == null) {
            result = null;
        } else {
            result = new Transform[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = (Transform)tmp[i];
            }
        }
        return result;
    }

    static Transform relativeTransform(Spatial startSpatial, Node ancestorNode, Transform storeResult) {
        assert (startSpatial.hasAncestor(ancestorNode));
        Transform result = storeResult == null ? new Transform() : storeResult;
        result.loadIdentity();
        for (Spatial loopSpatial = startSpatial; loopSpatial != ancestorNode; loopSpatial = loopSpatial.getParent()) {
            Transform localTransform = loopSpatial.getLocalTransform();
            result.combineWithParent(localTransform);
        }
        return result;
    }

    static void validate(Armature skeleton) {
        int numBones = skeleton.getJointCount();
        if (numBones < 0) {
            throw new IllegalArgumentException("Bone count is negative!");
        }
        TreeSet<String> nameSet = new TreeSet<String>();
        for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
            Joint bone = skeleton.getJoint(boneIndex);
            if (bone == null) {
                String msg = String.format("Bone %d in skeleton is null!", boneIndex);
                throw new IllegalArgumentException(msg);
            }
            String boneName = bone.getName();
            if (boneName == null) {
                String msg = String.format("Bone %d in skeleton has null name!", boneIndex);
                throw new IllegalArgumentException(msg);
            }
            if (boneName.equals("")) {
                String msg = String.format("Bone %d in skeleton has a reserved name!", boneIndex);
                throw new IllegalArgumentException(msg);
            }
            if (nameSet.contains(boneName)) {
                String msg = "Duplicate bone name in skeleton: " + boneName;
                throw new IllegalArgumentException(msg);
            }
            nameSet.add(boneName);
        }
    }

    static void validate(Spatial model) {
        List<Geometry> geometries = RagUtils.listGeometries(model, null);
        if (geometries.isEmpty()) {
            throw new IllegalArgumentException("No meshes in the model.");
        }
        for (Geometry geometry : geometries) {
            if (!geometry.isIgnoreTransform()) continue;
            throw new IllegalArgumentException("A model geometry ignores transforms.");
        }
    }

    private static void addPreOrderJoints(Joint bone, List<Joint> addResult) {
        assert (bone != null);
        addResult.add(bone);
        List children = bone.getChildren();
        for (Joint child : children) {
            RagUtils.addPreOrderJoints(child, addResult);
        }
    }

    private static void addWeights(Mesh mesh, float[] totalWeights) {
        assert (totalWeights != null);
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        if (maxWeightsPerVert <= 0) {
            maxWeightsPerVert = 1;
        }
        assert (maxWeightsPerVert > 0) : maxWeightsPerVert;
        assert (maxWeightsPerVert <= 4) : maxWeightsPerVert;
        VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        Buffer boneIndexBuffer = biBuf.getDataReadOnly();
        boneIndexBuffer.rewind();
        int numBoneIndices = boneIndexBuffer.remaining();
        assert (numBoneIndices % 4 == 0) : numBoneIndices;
        int numVertices = boneIndexBuffer.remaining() / 4;
        VertexBuffer wBuf = mesh.getBuffer(VertexBuffer.Type.BoneWeight);
        FloatBuffer weightBuffer = (FloatBuffer)wBuf.getDataReadOnly();
        weightBuffer.rewind();
        int numWeights = weightBuffer.remaining();
        assert (numWeights == numVertices * 4) : numWeights;
        for (int vIndex = 0; vIndex < numVertices; ++vIndex) {
            for (int wIndex = 0; wIndex < 4; ++wIndex) {
                float weight = weightBuffer.get();
                int boneIndex = RagUtils.readIndex(boneIndexBuffer);
                if (wIndex >= maxWeightsPerVert) continue;
                int n = boneIndex;
                totalWeights[n] = totalWeights[n] + FastMath.abs((float)weight);
            }
        }
    }

    private static String findManager(Mesh mesh, int vertexIndex, int[] iArray, float[] wArray, String[] managerMap) {
        RagUtils.vertexBoneIndices(mesh, vertexIndex, iArray);
        RagUtils.vertexBoneWeights(mesh, vertexIndex, wArray);
        Map<String, Float> weightMap = RagUtils.weightMap(iArray, wArray, managerMap);
        float bestTotalWeight = Float.NEGATIVE_INFINITY;
        String bestName = null;
        for (Map.Entry<String, Float> entry : weightMap.entrySet()) {
            float totalWeight = entry.getValue().floatValue();
            if (!(totalWeight >= bestTotalWeight)) continue;
            bestTotalWeight = totalWeight;
            bestName = entry.getKey();
        }
        return bestName;
    }

    private static List<Geometry> listGeometries(Spatial subtree, List<Geometry> addResult) {
        Geometry geometry;
        ArrayList<Geometry> result;
        ArrayList<Geometry> arrayList = result = addResult == null ? new ArrayList<Geometry>(50) : addResult;
        if (subtree instanceof Geometry && !result.contains(geometry = (Geometry)subtree)) {
            result.add(geometry);
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                RagUtils.listGeometries(child, result);
            }
        }
        return result;
    }

    private static List<Joint> preOrderJoints(Armature skeleton) {
        Joint[] rootBones;
        int numBones = skeleton.getJointCount();
        ArrayList<Joint> result = new ArrayList<Joint>(numBones);
        for (Joint rootBone : rootBones = skeleton.getRoots()) {
            RagUtils.addPreOrderJoints(rootBone, result);
        }
        assert (result.size() == numBones) : result.size();
        return result;
    }

    private static int readIndex(Buffer buffer) {
        int result;
        if (buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            byte b = byteBuffer.get();
            result = 0xFF & b;
        } else if (buffer instanceof ShortBuffer) {
            ShortBuffer shortBuffer = (ShortBuffer)buffer;
            short s = shortBuffer.get();
            result = 0xFFFF & s;
        } else {
            throw new IllegalArgumentException();
        }
        assert (result >= 0) : result;
        return result;
    }

    private static float[] totalWeights(Mesh[] meshes, Armature skeleton) {
        int numBones = skeleton.getJointCount();
        float[] result = new float[numBones];
        for (Mesh mesh : meshes) {
            RagUtils.addWeights(mesh, result);
        }
        List<Joint> bones = RagUtils.preOrderJoints(skeleton);
        Collections.reverse(bones);
        for (Joint childBone : bones) {
            int parentIndex;
            int childIndex = skeleton.getJointIndex(childBone);
            Joint parent = childBone.getParent();
            if (parent == null) continue;
            int n = parentIndex = skeleton.getJointIndex(parent);
            result[n] = result[n] + result[childIndex];
        }
        return result;
    }

    private static int[] vertexBoneIndices(Mesh mesh, int vertexIndex, int[] storeResult) {
        if (storeResult == null) {
            storeResult = new int[4];
        } else assert (storeResult.length >= 4) : storeResult.length;
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        if (maxWeightsPerVert <= 0) {
            maxWeightsPerVert = 1;
        }
        VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        Buffer boneIndexBuffer = biBuf.getDataReadOnly();
        boneIndexBuffer.position(4 * vertexIndex);
        for (int wIndex = 0; wIndex < maxWeightsPerVert; ++wIndex) {
            int boneIndex;
            storeResult[wIndex] = boneIndex = RagUtils.readIndex(boneIndexBuffer);
        }
        int length = storeResult.length;
        for (int wIndex = maxWeightsPerVert; wIndex < length; ++wIndex) {
            storeResult[wIndex] = -1;
        }
        return storeResult;
    }

    private static float[] vertexBoneWeights(Mesh mesh, int vertexIndex, float[] storeResult) {
        if (storeResult == null) {
            storeResult = new float[4];
        } else assert (storeResult.length >= 4) : storeResult.length;
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        if (maxWeightsPerVert <= 0) {
            maxWeightsPerVert = 1;
        }
        VertexBuffer wBuf = mesh.getBuffer(VertexBuffer.Type.BoneWeight);
        FloatBuffer weightBuffer = (FloatBuffer)wBuf.getDataReadOnly();
        weightBuffer.position(4 * vertexIndex);
        for (int wIndex = 0; wIndex < maxWeightsPerVert; ++wIndex) {
            storeResult[wIndex] = weightBuffer.get();
        }
        int length = storeResult.length;
        for (int wIndex = maxWeightsPerVert; wIndex < length; ++wIndex) {
            storeResult[wIndex] = 0.0f;
        }
        return storeResult;
    }

    private static Vector3f vertexVector3f(Mesh mesh, VertexBuffer.Type bufferType, int vertexIndex, Vector3f storeResult) {
        assert (bufferType == VertexBuffer.Type.BindPoseNormal || bufferType == VertexBuffer.Type.BindPosePosition || bufferType == VertexBuffer.Type.Binormal || bufferType == VertexBuffer.Type.Normal || bufferType == VertexBuffer.Type.Position) : bufferType;
        if (storeResult == null) {
            storeResult = new Vector3f();
        }
        VertexBuffer vertexBuffer = mesh.getBuffer(bufferType);
        FloatBuffer floatBuffer = (FloatBuffer)vertexBuffer.getDataReadOnly();
        floatBuffer.position(3 * vertexIndex);
        storeResult.x = floatBuffer.get();
        storeResult.y = floatBuffer.get();
        storeResult.z = floatBuffer.get();
        return storeResult;
    }

    private static Map<String, Float> weightMap(int[] biArray, float[] bwArray, String[] managerMap) {
        assert (biArray.length == 4);
        assert (bwArray.length == 4);
        HashMap<String, Float> weightMap = new HashMap<String, Float>(4);
        for (int j = 0; j < 4; ++j) {
            int boneIndex = biArray[j];
            if (boneIndex == -1) continue;
            String managerName = managerMap[boneIndex];
            if (weightMap.containsKey(managerName)) {
                float oldWeight = ((Float)weightMap.get(managerName)).floatValue();
                float newWeight = oldWeight + bwArray[j];
                weightMap.put(managerName, Float.valueOf(newWeight));
                continue;
            }
            weightMap.put(managerName, Float.valueOf(bwArray[j]));
        }
        return weightMap;
    }
}

