/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Joint;
import com.jme3.bullet.animation.DacLinks;
import com.jme3.bullet.animation.KinematicSubmode;
import com.jme3.bullet.animation.PhysicsLink;
import com.jme3.bullet.animation.RagUtils;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;

public class TorsoLink
extends PhysicsLink {
    public static final Logger logger2 = Logger.getLogger(TorsoLink.class.getName());
    private Joint[] managedBones = null;
    private KinematicSubmode submode = KinematicSubmode.Animated;
    private Transform endModelTransform = null;
    private Transform meshToModel = null;
    private Transform startModelTransform = new Transform();
    private Transform[] prevBoneTransforms = null;
    private Transform[] startBoneTransforms = null;

    protected TorsoLink() {
    }

    TorsoLink(DacLinks control, Joint mainRootBone, CollisionShape collisionShape, float mass, Transform meshToModel, Vector3f localOffset) {
        super(control, mainRootBone, collisionShape, mass, localOffset);
        this.meshToModel = meshToModel.clone();
        this.managedBones = control.listManagedBones("");
        int numManagedBones = this.managedBones.length;
        this.startBoneTransforms = new Transform[numManagedBones];
        for (int i = 0; i < numManagedBones; ++i) {
            this.startBoneTransforms[i] = new Transform();
        }
    }

    public void blendToKinematicMode(KinematicSubmode submode, float blendInterval, Transform endModelTransform) {
        super.blendToKinematicMode(blendInterval);
        this.submode = submode;
        this.endModelTransform = endModelTransform;
        if (endModelTransform != null) {
            Transform current = this.getControl().getSpatial().getLocalTransform();
            this.startModelTransform.set(current);
        }
        int numManagedBones = this.managedBones.length;
        for (int mbIndex = 0; mbIndex < numManagedBones; ++mbIndex) {
            Transform transform;
            if (this.prevBoneTransforms == null) {
                Joint managedBone = this.managedBones[mbIndex];
                transform = managedBone.getLocalTransform().clone();
            } else {
                transform = this.prevBoneTransforms[mbIndex];
            }
            this.startBoneTransforms[mbIndex].set(transform);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.managedBones = (Joint[])cloner.clone((Object)this.managedBones);
        this.endModelTransform = (Transform)cloner.clone((Object)this.endModelTransform);
        this.meshToModel = (Transform)cloner.clone((Object)this.meshToModel);
        this.prevBoneTransforms = (Transform[])cloner.clone((Object)this.prevBoneTransforms);
        this.startBoneTransforms = (Transform[])cloner.clone((Object)this.startBoneTransforms);
        this.startModelTransform = (Transform)cloner.clone((Object)this.startModelTransform);
    }

    @Override
    protected void dynamicUpdate() {
        Joint[] rootBones;
        Transform worldToParent;
        Node parent = this.getControl().getSpatial().getParent();
        if (parent == null) {
            worldToParent = new Transform();
        } else {
            Transform parentToWorld = parent.getWorldTransform();
            worldToParent = parentToWorld.invert();
        }
        Transform transform = this.meshToModel.clone();
        Transform shapeToWorld = new Transform();
        PhysicsRigidBody body = this.getRigidBody();
        body.getPhysicsLocation(shapeToWorld.getTranslation());
        body.getPhysicsRotation(shapeToWorld.getRotation());
        shapeToWorld.setScale(body.getCollisionShape().getScale());
        transform.combineWithParent(shapeToWorld);
        transform.combineWithParent(worldToParent);
        this.getControl().getSpatial().setLocalTransform(transform);
        this.localBoneTransform(transform);
        for (Joint rootBone : rootBones = this.getControl().getSkeleton().getRoots()) {
            rootBone.setLocalTransform(transform);
        }
        for (Joint managedBone : this.managedBones) {
            managedBone.updateModelTransforms();
        }
    }

    @Override
    public TorsoLink jmeClone() {
        try {
            TorsoLink clone = (TorsoLink)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected void kinematicUpdate(float tpf) {
        assert (tpf >= 0.0f) : tpf;
        assert (this.getRigidBody().isKinematic());
        Transform transform = new Transform();
        if (this.endModelTransform != null) {
            transform.interpolateTransforms(this.startModelTransform.clone(), this.endModelTransform, this.kinematicWeight());
            this.getControl().getSpatial().setLocalTransform(transform);
        }
        for (int mbIndex = 0; mbIndex < this.managedBones.length; ++mbIndex) {
            Joint managedBone = this.managedBones[mbIndex];
            switch (this.submode) {
                case Animated: {
                    transform.set(managedBone.getLocalTransform());
                    break;
                }
                case Frozen: {
                    transform.set(this.prevBoneTransforms[mbIndex]);
                    break;
                }
                default: {
                    throw new IllegalStateException(this.submode.toString());
                }
            }
            if (this.kinematicWeight() < 1.0f) {
                transform.interpolateTransforms(this.startBoneTransforms[mbIndex].clone(), transform, this.kinematicWeight());
            }
            managedBone.setLocalTransform(transform);
            managedBone.updateModelTransforms();
        }
        super.kinematicUpdate(tpf);
    }

    @Override
    public String name() {
        return "Torso:";
    }

    void postRebuild(TorsoLink oldLink) {
        int i;
        int numManagedBones = this.managedBones.length;
        assert (oldLink.managedBones.length == numManagedBones);
        super.postRebuild(oldLink);
        this.submode = oldLink.isKinematic() ? oldLink.submode : KinematicSubmode.Frozen;
        Transform emt = oldLink.endModelTransform;
        this.endModelTransform = emt == null ? null : emt.clone();
        this.startModelTransform.set(oldLink.startModelTransform);
        if (this.prevBoneTransforms == null) {
            this.prevBoneTransforms = new Transform[numManagedBones];
            for (i = 0; i < numManagedBones; ++i) {
                this.prevBoneTransforms[i] = new Transform();
            }
        }
        for (i = 0; i < numManagedBones; ++i) {
            this.prevBoneTransforms[i].set(oldLink.prevBoneTransforms[i]);
            this.startBoneTransforms[i].set(oldLink.startBoneTransforms[i]);
        }
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        Savable[] tmp = ic.readSavableArray("managedBones", null);
        if (tmp == null) {
            this.managedBones = null;
        } else {
            this.managedBones = new Joint[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                this.managedBones[i] = (Joint)tmp[i];
            }
        }
        this.submode = (KinematicSubmode)ic.readEnum("submode", KinematicSubmode.class, (Enum)KinematicSubmode.Animated);
        this.endModelTransform = (Transform)ic.readSavable("endModelTransform", (Savable)new Transform());
        this.meshToModel = (Transform)ic.readSavable("meshToModel", (Savable)new Transform());
        this.startModelTransform = (Transform)ic.readSavable("startModelTransform", (Savable)new Transform());
        this.prevBoneTransforms = RagUtils.readTransformArray(ic, "prevBoneTransforms");
        this.startBoneTransforms = RagUtils.readTransformArray(ic, "startBoneTransforms");
    }

    @Override
    void update(float tpf) {
        Joint managedBone;
        assert (tpf >= 0.0f) : tpf;
        if (this.prevBoneTransforms == null) {
            int numManagedBones = this.managedBones.length;
            this.prevBoneTransforms = new Transform[numManagedBones];
            for (int mbIndex = 0; mbIndex < numManagedBones; ++mbIndex) {
                Transform boneTransform;
                managedBone = this.managedBones[mbIndex];
                this.prevBoneTransforms[mbIndex] = boneTransform = managedBone.getLocalTransform().clone();
            }
        }
        super.update(tpf);
        for (int mbIndex = 0; mbIndex < this.managedBones.length; ++mbIndex) {
            Transform lastTransform = this.prevBoneTransforms[mbIndex];
            managedBone = this.managedBones[mbIndex];
            lastTransform.set(managedBone.getLocalTransform());
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write((Savable[])this.managedBones, "managedBones", null);
        oc.write((Enum)this.submode, "submode", (Enum)KinematicSubmode.Animated);
        oc.write((Savable)this.endModelTransform, "endModelTransforms", (Savable)new Transform());
        oc.write((Savable)this.meshToModel, "meshToModel", (Savable)new Transform());
        oc.write((Savable)this.startModelTransform, "startModelTransforms", (Savable)new Transform());
        oc.write((Savable[])this.prevBoneTransforms, "prevBoneTransforms", (Savable[])new Transform[0]);
        oc.write((Savable[])this.startBoneTransforms, "startBoneTransforms", (Savable[])new Transform[0]);
    }

    private Transform localBoneTransform(Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        Vector3f location = result.getTranslation();
        Quaternion orientation = result.getRotation();
        Vector3f scale = result.getScale();
        PhysicsRigidBody body = this.getRigidBody();
        body.getPhysicsLocation(result.getTranslation());
        body.getPhysicsRotation(result.getRotation());
        result.setScale(body.getCollisionShape().getScale());
        Transform worldToMesh = this.getControl().meshTransform(null).invert();
        result.combineWithParent(worldToMesh);
        Vector3f meshOffset = this.localOffset(null);
        meshOffset.multLocal(scale);
        orientation.mult(meshOffset, meshOffset);
        location.subtractLocal(meshOffset);
        return result;
    }
}

