/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PhysicsCollisionObject
implements Savable {
    protected long objectId = 0L;
    protected CollisionShape collisionShape;
    public static final int COLLISION_GROUP_NONE = 0;
    public static final int COLLISION_GROUP_01 = 1;
    public static final int COLLISION_GROUP_02 = 2;
    public static final int COLLISION_GROUP_03 = 4;
    public static final int COLLISION_GROUP_04 = 8;
    public static final int COLLISION_GROUP_05 = 16;
    public static final int COLLISION_GROUP_06 = 32;
    public static final int COLLISION_GROUP_07 = 64;
    public static final int COLLISION_GROUP_08 = 128;
    public static final int COLLISION_GROUP_09 = 256;
    public static final int COLLISION_GROUP_10 = 512;
    public static final int COLLISION_GROUP_11 = 1024;
    public static final int COLLISION_GROUP_12 = 2048;
    public static final int COLLISION_GROUP_13 = 4096;
    public static final int COLLISION_GROUP_14 = 8192;
    public static final int COLLISION_GROUP_15 = 16384;
    public static final int COLLISION_GROUP_16 = 32768;
    protected int collisionGroup = 1;
    protected int collisionGroupsMask = 1;
    private Object userObject;

    public void setCollisionShape(CollisionShape collisionShape) {
        this.collisionShape = collisionShape;
    }

    public CollisionShape getCollisionShape() {
        return this.collisionShape;
    }

    public float getDeactivationTime() {
        float time = this.getDeactivationTime(this.objectId);
        return time;
    }

    private native float getDeactivationTime(long var1);

    public int getCollisionGroup() {
        return this.collisionGroup;
    }

    public void setCollisionGroup(int collisionGroup) {
        this.collisionGroup = collisionGroup;
        if (this.objectId != 0L) {
            this.setCollisionGroup(this.objectId, collisionGroup);
        }
    }

    public void addCollideWithGroup(int collisionGroup) {
        this.collisionGroupsMask |= collisionGroup;
        if (this.objectId != 0L) {
            this.setCollideWithGroups(this.objectId, this.collisionGroupsMask);
        }
    }

    public void removeCollideWithGroup(int collisionGroup) {
        this.collisionGroupsMask &= ~collisionGroup;
        if (this.objectId != 0L) {
            this.setCollideWithGroups(this.collisionGroupsMask);
        }
    }

    public void setCollideWithGroups(int collisionGroups) {
        this.collisionGroupsMask = collisionGroups;
        if (this.objectId != 0L) {
            this.setCollideWithGroups(this.objectId, this.collisionGroupsMask);
        }
    }

    public int getCollideWithGroups() {
        return this.collisionGroupsMask;
    }

    protected void initUserPointer() {
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "initUserPointer() objectId = {0}", Long.toHexString(this.objectId));
        this.initUserPointer(this.objectId, this.collisionGroup, this.collisionGroupsMask);
    }

    native void initUserPointer(long var1, int var3, int var4);

    public Object getUserObject() {
        return this.userObject;
    }

    public boolean isContactResponse() {
        int flags = this.getCollisionFlags(this.objectId);
        boolean result = (flags & 4) == 0;
        return result;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public long getObjectId() {
        return this.objectId;
    }

    protected native void attachCollisionShape(long var1, long var3);

    native void setCollisionGroup(long var1, int var3);

    native void setCollideWithGroups(long var1, int var3);

    public void write(JmeExporter e) throws IOException {
        OutputCapsule capsule = e.getCapsule((Savable)this);
        capsule.write(this.collisionGroup, "collisionGroup", 1);
        capsule.write(this.collisionGroupsMask, "collisionGroupsMask", 1);
        capsule.write((Savable)this.collisionShape, "collisionShape", null);
    }

    public void read(JmeImporter e) throws IOException {
        CollisionShape shape;
        InputCapsule capsule = e.getCapsule((Savable)this);
        this.collisionGroup = capsule.readInt("collisionGroup", 1);
        this.collisionGroupsMask = capsule.readInt("collisionGroupsMask", 1);
        this.collisionShape = shape = (CollisionShape)capsule.readSavable("collisionShape", null);
    }

    protected native int getCollisionFlags(long var1);

    protected native void setCollisionFlags(long var1, int var3);

    protected void finalize() throws Throwable {
        super.finalize();
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Finalizing CollisionObject {0}", Long.toHexString(this.objectId));
        this.finalizeNative(this.objectId);
    }

    protected native void finalizeNative(long var1);
}

