/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HeightfieldCollisionShape
extends CollisionShape {
    protected int heightStickWidth;
    protected int heightStickLength;
    protected float[] heightfieldData;
    protected float heightScale;
    protected float minHeight;
    protected float maxHeight;
    protected int upAxis;
    protected boolean flipQuadEdges;
    protected ByteBuffer bbuf;

    protected HeightfieldCollisionShape() {
    }

    public HeightfieldCollisionShape(float[] heightmap) {
        this.createCollisionHeightfield(heightmap, Vector3f.UNIT_XYZ);
    }

    public HeightfieldCollisionShape(float[] heightmap, Vector3f scale) {
        this.createCollisionHeightfield(heightmap, scale);
    }

    protected void createCollisionHeightfield(float[] heightmap, Vector3f worldScale) {
        this.scale = worldScale;
        this.heightScale = 1.0f;
        this.heightfieldData = heightmap;
        float min = this.heightfieldData[0];
        float max = this.heightfieldData[0];
        for (int i = 0; i < this.heightfieldData.length; ++i) {
            if (this.heightfieldData[i] < min) {
                min = this.heightfieldData[i];
            }
            if (!(this.heightfieldData[i] > max)) continue;
            max = this.heightfieldData[i];
        }
        if (max < 0.0f) {
            max = -min;
        } else if (Math.abs(max) > Math.abs(min)) {
            min = -max;
        } else {
            max = -min;
        }
        this.minHeight = min;
        this.maxHeight = max;
        this.upAxis = 1;
        this.flipQuadEdges = true;
        this.heightStickLength = this.heightStickWidth = (int)FastMath.sqrt((float)this.heightfieldData.length);
        this.createShape();
    }

    protected void createShape() {
        this.bbuf = BufferUtils.createByteBuffer((int)(this.heightfieldData.length * 4));
        for (int i = 0; i < this.heightfieldData.length; ++i) {
            float f = this.heightfieldData[i];
            this.bbuf.putFloat(f);
        }
        this.objectId = this.createShape(this.heightStickWidth, this.heightStickLength, this.bbuf, this.heightScale, this.minHeight, this.maxHeight, this.upAxis, this.flipQuadEdges);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Shape {0}", Long.toHexString(this.objectId));
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private native long createShape(int var1, int var2, ByteBuffer var3, float var4, float var5, float var6, int var7, boolean var8);

    public Mesh createJmeMesh() {
        return null;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write(this.heightStickWidth, "heightStickWidth", 0);
        capsule.write(this.heightStickLength, "heightStickLength", 0);
        capsule.write(this.heightScale, "heightScale", 0.0f);
        capsule.write(this.minHeight, "minHeight", 0.0f);
        capsule.write(this.maxHeight, "maxHeight", 0.0f);
        capsule.write(this.upAxis, "upAxis", 1);
        capsule.write(this.heightfieldData, "heightfieldData", new float[0]);
        capsule.write(this.flipQuadEdges, "flipQuadEdges", false);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.heightStickWidth = capsule.readInt("heightStickWidth", 0);
        this.heightStickLength = capsule.readInt("heightStickLength", 0);
        this.heightScale = capsule.readFloat("heightScale", 0.0f);
        this.minHeight = capsule.readFloat("minHeight", 0.0f);
        this.maxHeight = capsule.readFloat("maxHeight", 0.0f);
        this.upAxis = capsule.readInt("upAxis", 1);
        this.heightfieldData = capsule.readFloatArray("heightfieldData", new float[0]);
        this.flipQuadEdges = capsule.readBoolean("flipQuadEdges", false);
        this.createShape();
    }
}

