/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HullCollisionShape
extends CollisionShape {
    private float[] points;

    protected HullCollisionShape() {
    }

    public HullCollisionShape(Mesh mesh) {
        this.points = this.getPoints(mesh);
        this.createShape();
    }

    public HullCollisionShape(float[] points) {
        this.points = points;
        this.createShape();
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write(this.points, "points", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        Mesh mesh = (Mesh)capsule.readSavable("hullMesh", null);
        this.points = mesh != null ? this.getPoints(mesh) : capsule.readFloatArray("points", null);
        this.createShape();
    }

    protected void createShape() {
        ByteBuffer bbuf = BufferUtils.createByteBuffer((int)(this.points.length * 4));
        for (int i = 0; i < this.points.length; ++i) {
            float f = this.points[i];
            bbuf.putFloat(f);
        }
        bbuf.rewind();
        this.objectId = this.createShape(bbuf);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Shape {0}", Long.toHexString(this.objectId));
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private native long createShape(ByteBuffer var1);

    protected float[] getPoints(Mesh mesh) {
        FloatBuffer vertices = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        vertices.rewind();
        int components = mesh.getVertexCount() * 3;
        float[] pointsArray = new float[components];
        for (int i = 0; i < components; i += 3) {
            pointsArray[i] = vertices.get();
            pointsArray[i + 1] = vertices.get();
            pointsArray[i + 2] = vertices.get();
        }
        return pointsArray;
    }
}

