/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimplexCollisionShape
extends CollisionShape {
    private Vector3f vector1;
    private Vector3f vector2;
    private Vector3f vector3;
    private Vector3f vector4;

    protected SimplexCollisionShape() {
    }

    public SimplexCollisionShape(Vector3f point1, Vector3f point2, Vector3f point3, Vector3f point4) {
        this.vector1 = point1;
        this.vector2 = point2;
        this.vector3 = point3;
        this.vector4 = point4;
        this.createShape();
    }

    public SimplexCollisionShape(Vector3f point1, Vector3f point2, Vector3f point3) {
        this.vector1 = point1;
        this.vector2 = point2;
        this.vector3 = point3;
        this.createShape();
    }

    public SimplexCollisionShape(Vector3f point1, Vector3f point2) {
        this.vector1 = point1;
        this.vector2 = point2;
        this.createShape();
    }

    public SimplexCollisionShape(Vector3f point1) {
        this.vector1 = point1;
        this.createShape();
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write((Savable)this.vector1, "simplexPoint1", null);
        capsule.write((Savable)this.vector2, "simplexPoint2", null);
        capsule.write((Savable)this.vector3, "simplexPoint3", null);
        capsule.write((Savable)this.vector4, "simplexPoint4", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.vector1 = (Vector3f)capsule.readSavable("simplexPoint1", null);
        this.vector2 = (Vector3f)capsule.readSavable("simplexPoint2", null);
        this.vector3 = (Vector3f)capsule.readSavable("simplexPoint3", null);
        this.vector4 = (Vector3f)capsule.readSavable("simplexPoint4", null);
        this.createShape();
    }

    protected void createShape() {
        this.objectId = this.vector4 != null ? this.createShape(this.vector1, this.vector2, this.vector3, this.vector4) : (this.vector3 != null ? this.createShape(this.vector1, this.vector2, this.vector3) : (this.vector2 != null ? this.createShape(this.vector1, this.vector2) : this.createShape(this.vector1)));
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Shape {0}", Long.toHexString(this.objectId));
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private native long createShape(Vector3f var1);

    private native long createShape(Vector3f var1, Vector3f var2);

    private native long createShape(Vector3f var1, Vector3f var2, Vector3f var3);

    private native long createShape(Vector3f var1, Vector3f var2, Vector3f var3, Vector3f var4);
}

