/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control.ragdoll;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RagdollUtils {
    private RagdollUtils() {
    }

    public static void setJointLimit(SixDofJoint joint, float maxX, float minX, float maxY, float minY, float maxZ, float minZ) {
        joint.getRotationalLimitMotor(0).setHiLimit(maxX);
        joint.getRotationalLimitMotor(0).setLoLimit(minX);
        joint.getRotationalLimitMotor(1).setHiLimit(maxY);
        joint.getRotationalLimitMotor(1).setLoLimit(minY);
        joint.getRotationalLimitMotor(2).setHiLimit(maxZ);
        joint.getRotationalLimitMotor(2).setLoLimit(minZ);
    }

    public static Map<Integer, List<Float>> buildPointMap(Spatial model) {
        Mesh[] targetMeshes;
        HashMap<Integer, List<Float>> map = new HashMap<Integer, List<Float>>();
        SkeletonControl skeletonCtrl = (SkeletonControl)model.getControl(SkeletonControl.class);
        for (Mesh mesh : targetMeshes = skeletonCtrl.getTargets()) {
            RagdollUtils.buildPointMapForMesh(mesh, map);
        }
        return map;
    }

    private static Map<Integer, List<Float>> buildPointMapForMesh(Mesh mesh, Map<Integer, List<Float>> map) {
        FloatBuffer vertices = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        ByteBuffer boneIndices = (ByteBuffer)mesh.getBuffer(VertexBuffer.Type.BoneIndex).getData();
        FloatBuffer boneWeight = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.BoneWeight).getData();
        vertices.rewind();
        boneIndices.rewind();
        boneWeight.rewind();
        int vertexComponents = mesh.getVertexCount() * 3;
        float maxWeight = 0.0f;
        for (int i = 0; i < vertexComponents; i += 3) {
            int start = i / 3 * 4;
            int index = 0;
            maxWeight = -1.0f;
            for (int k = start; k < start + 4; ++k) {
                float weight = boneWeight.get(k);
                if (!(weight > maxWeight)) continue;
                maxWeight = weight;
                index = boneIndices.get(k);
            }
            List<Float> points = map.get(index);
            if (points == null) {
                points = new ArrayList<Float>();
                map.put(index, points);
            }
            points.add(Float.valueOf(vertices.get(i)));
            points.add(Float.valueOf(vertices.get(i + 1)));
            points.add(Float.valueOf(vertices.get(i + 2)));
        }
        return map;
    }

    public static HullCollisionShape makeShapeFromPointMap(Map<Integer, List<Float>> pointsMap, List<Integer> boneIndices, Vector3f initialScale, Vector3f initialPosition) {
        ArrayList<Float> points = new ArrayList<Float>();
        for (Integer index : boneIndices) {
            List<Float> l = pointsMap.get(index);
            if (l == null) continue;
            for (int i = 0; i < l.size(); i += 3) {
                Vector3f pos = new Vector3f();
                pos.x = l.get(i).floatValue();
                pos.y = l.get(i + 1).floatValue();
                pos.z = l.get(i + 2).floatValue();
                pos.subtractLocal(initialPosition).multLocal(initialScale);
                points.add(Float.valueOf(pos.x));
                points.add(Float.valueOf(pos.y));
                points.add(Float.valueOf(pos.z));
            }
        }
        assert (!points.isEmpty());
        float[] p = new float[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            p[i] = ((Float)points.get(i)).floatValue();
        }
        return new HullCollisionShape(p);
    }

    public static List<Integer> getBoneIndices(Bone bone, Skeleton skeleton, Set<String> boneList) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        if (boneList.isEmpty()) {
            list.add(skeleton.getBoneIndex(bone));
        } else {
            list.add(skeleton.getBoneIndex(bone));
            for (Bone chilBone : bone.getChildren()) {
                if (boneList.contains(chilBone.getName())) continue;
                list.addAll(RagdollUtils.getBoneIndices(chilBone, skeleton, boneList));
            }
        }
        return list;
    }

    public static HullCollisionShape makeShapeFromVerticeWeights(Spatial model, List<Integer> boneIndices, Vector3f initialScale, Vector3f initialPosition, float weightThreshold) {
        Mesh[] targetMeshes;
        ArrayList<Float> points = new ArrayList<Float>(100);
        SkeletonControl skeletonCtrl = (SkeletonControl)model.getControl(SkeletonControl.class);
        for (Mesh mesh : targetMeshes = skeletonCtrl.getTargets()) {
            for (Integer index : boneIndices) {
                List<Float> bonePoints = RagdollUtils.getPoints(mesh, index, initialScale, initialPosition, weightThreshold);
                points.addAll(bonePoints);
            }
        }
        assert (!points.isEmpty());
        float[] p = new float[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            p[i] = ((Float)points.get(i)).floatValue();
        }
        return new HullCollisionShape(p);
    }

    private static List<Float> getPoints(Mesh mesh, int boneIndex, Vector3f initialScale, Vector3f offset, float weightThreshold) {
        FloatBuffer vertices = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        Buffer boneIndices = biBuf.getDataReadOnly();
        FloatBuffer boneWeight = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.BoneWeight).getData();
        vertices.rewind();
        boneIndices.rewind();
        boneWeight.rewind();
        ArrayList<Float> results = new ArrayList<Float>();
        int vertexComponents = mesh.getVertexCount() * 3;
        for (int i = 0; i < vertexComponents; i += 3) {
            int start;
            boolean add = false;
            for (int k = start = i / 3 * 4; k < start + 4; ++k) {
                if (RagdollUtils.readIndex(boneIndices, k) != boneIndex || !(boneWeight.get(k) >= weightThreshold)) continue;
                add = true;
                break;
            }
            if (!add) continue;
            Vector3f pos = new Vector3f();
            pos.x = vertices.get(i);
            pos.y = vertices.get(i + 1);
            pos.z = vertices.get(i + 2);
            pos.subtractLocal(offset).multLocal(initialScale);
            results.add(Float.valueOf(pos.x));
            results.add(Float.valueOf(pos.y));
            results.add(Float.valueOf(pos.z));
        }
        return results;
    }

    public static void setTransform(Bone bone, Vector3f pos, Quaternion rot, boolean restoreBoneControl, Set<String> boneList) {
        if (restoreBoneControl) {
            bone.setUserControl(true);
        }
        bone.setUserTransformsInModelSpace(pos, rot);
        for (Bone childBone : bone.getChildren()) {
            if (boneList.contains(childBone.getName())) continue;
            Transform t = childBone.getCombinedTransform(pos, rot);
            RagdollUtils.setTransform(childBone, t.getTranslation(), t.getRotation(), restoreBoneControl, boneList);
        }
        if (restoreBoneControl) {
            bone.setUserControl(false);
        }
    }

    public static void setUserControl(Bone bone, boolean bool) {
        bone.setUserControl(bool);
        for (Bone child : bone.getChildren()) {
            RagdollUtils.setUserControl(child, bool);
        }
    }

    public static boolean hasVertices(int boneIndex, Mesh[] targets, float weightThreshold) {
        for (Mesh mesh : targets) {
            VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
            Buffer boneIndices = biBuf.getDataReadOnly();
            FloatBuffer boneWeight = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.BoneWeight).getData();
            boneIndices.rewind();
            boneWeight.rewind();
            int vertexComponents = mesh.getVertexCount() * 3;
            for (int i = 0; i < vertexComponents; i += 3) {
                int start;
                for (int k = start = i / 3 * 4; k < start + 4; ++k) {
                    if (RagdollUtils.readIndex(boneIndices, k) != boneIndex || !(boneWeight.get(k) >= weightThreshold)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int readIndex(Buffer buffer, int k) {
        int result;
        if (buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            byte b = byteBuffer.get(k);
            result = 0xFF & b;
        } else if (buffer instanceof ShortBuffer) {
            ShortBuffer shortBuffer = (ShortBuffer)buffer;
            short s = shortBuffer.get(k);
            result = 0xFFFF & s;
        } else {
            throw new IllegalArgumentException(buffer.getClass().getName());
        }
        assert (result >= 0) : result;
        return result;
    }
}

