/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Point2PointJoint
extends PhysicsJoint {
    protected Point2PointJoint() {
    }

    public Point2PointJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.createJoint();
    }

    public void setDamping(float value) {
        this.setDamping(this.objectId, value);
    }

    private native void setDamping(long var1, float var3);

    public void setImpulseClamp(float value) {
        this.setImpulseClamp(this.objectId, value);
    }

    private native void setImpulseClamp(long var1, float var3);

    public void setTau(float value) {
        this.setTau(this.objectId, value);
    }

    private native void setTau(long var1, float var3);

    public float getDamping() {
        return this.getDamping(this.objectId);
    }

    private native float getDamping(long var1);

    public float getImpulseClamp() {
        return this.getImpulseClamp(this.objectId);
    }

    private native float getImpulseClamp(long var1);

    public float getTau() {
        return this.getTau(this.objectId);
    }

    private native float getTau(long var1);

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule cap = ex.getCapsule((Savable)this);
        cap.write(this.getDamping(), "damping", 1.0f);
        cap.write(this.getTau(), "tau", 0.3f);
        cap.write(this.getImpulseClamp(), "impulseClamp", 0.0f);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        this.createJoint();
        InputCapsule cap = im.getCapsule((Savable)this);
        this.setDamping(cap.readFloat("damping", 1.0f));
        this.setDamping(cap.readFloat("tau", 0.3f));
        this.setDamping(cap.readFloat("impulseClamp", 0.0f));
    }

    protected void createJoint() {
        this.objectId = this.createJoint(this.nodeA.getObjectId(), this.nodeB.getObjectId(), this.pivotA, this.pivotB);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Joint {0}", Long.toHexString(this.objectId));
    }

    private native long createJoint(long var1, long var3, Vector3f var5, Vector3f var6);
}

