/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhysicsGhostObject
extends PhysicsCollisionObject {
    protected boolean locationDirty = false;
    protected final Quaternion tmp_inverseWorldRotation = new Quaternion();
    private List<PhysicsCollisionObject> overlappingObjects = new LinkedList<PhysicsCollisionObject>();

    protected PhysicsGhostObject() {
    }

    public PhysicsGhostObject(CollisionShape shape) {
        this.collisionShape = shape;
        this.buildObject();
    }

    public PhysicsGhostObject(Spatial child, CollisionShape shape) {
        this.collisionShape = shape;
        this.buildObject();
    }

    protected void buildObject() {
        if (this.objectId == 0L) {
            this.objectId = this.createGhostObject();
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Ghost Object {0}", Long.toHexString(this.objectId));
            this.setGhostFlags(this.objectId);
            this.initUserPointer();
        }
        this.attachCollisionShape(this.objectId, this.collisionShape.getObjectId());
    }

    private native long createGhostObject();

    private native void setGhostFlags(long var1);

    @Override
    public void setCollisionShape(CollisionShape collisionShape) {
        super.setCollisionShape(collisionShape);
        if (this.objectId == 0L) {
            this.buildObject();
        } else {
            this.attachCollisionShape(this.objectId, collisionShape.getObjectId());
        }
    }

    public void setPhysicsLocation(Vector3f location) {
        this.setPhysicsLocation(this.objectId, location);
    }

    private native void setPhysicsLocation(long var1, Vector3f var3);

    public void setPhysicsRotation(Matrix3f rotation) {
        this.setPhysicsRotation(this.objectId, rotation);
    }

    private native void setPhysicsRotation(long var1, Matrix3f var3);

    public void setPhysicsRotation(Quaternion rotation) {
        this.setPhysicsRotation(this.objectId, rotation);
    }

    private native void setPhysicsRotation(long var1, Quaternion var3);

    public Vector3f getPhysicsLocation(Vector3f trans) {
        if (trans == null) {
            trans = new Vector3f();
        }
        this.getPhysicsLocation(this.objectId, trans);
        return trans;
    }

    private native void getPhysicsLocation(long var1, Vector3f var3);

    public Quaternion getPhysicsRotation(Quaternion rot) {
        if (rot == null) {
            rot = new Quaternion();
        }
        this.getPhysicsRotation(this.objectId, rot);
        return rot;
    }

    private native void getPhysicsRotation(long var1, Quaternion var3);

    public Matrix3f getPhysicsRotationMatrix(Matrix3f rot) {
        if (rot == null) {
            rot = new Matrix3f();
        }
        this.getPhysicsRotationMatrix(this.objectId, rot);
        return rot;
    }

    private native void getPhysicsRotationMatrix(long var1, Matrix3f var3);

    public Vector3f getPhysicsLocation() {
        Vector3f vec = new Vector3f();
        this.getPhysicsLocation(this.objectId, vec);
        return vec;
    }

    public Quaternion getPhysicsRotation() {
        Quaternion quat = new Quaternion();
        this.getPhysicsRotation(this.objectId, quat);
        return quat;
    }

    public Matrix3f getPhysicsRotationMatrix() {
        Matrix3f mtx = new Matrix3f();
        this.getPhysicsRotationMatrix(this.objectId, mtx);
        return mtx;
    }

    public void destroy() {
    }

    public List<PhysicsCollisionObject> getOverlappingObjects() {
        this.overlappingObjects.clear();
        this.getOverlappingObjects(this.objectId);
        return this.overlappingObjects;
    }

    protected native void getOverlappingObjects(long var1);

    private void addOverlappingObject_native(PhysicsCollisionObject co) {
        this.overlappingObjects.add(co);
    }

    public int getOverlappingCount() {
        return this.getOverlappingCount(this.objectId);
    }

    private native int getOverlappingCount(long var1);

    public PhysicsCollisionObject getOverlapping(int index) {
        return this.overlappingObjects.get(index);
    }

    public void setCcdSweptSphereRadius(float radius) {
        this.setCcdSweptSphereRadius(this.objectId, radius);
    }

    private native void setCcdSweptSphereRadius(long var1, float var3);

    public void setCcdMotionThreshold(float threshold) {
        this.setCcdMotionThreshold(this.objectId, threshold);
    }

    private native void setCcdMotionThreshold(long var1, float var3);

    public float getCcdSweptSphereRadius() {
        return this.getCcdSweptSphereRadius(this.objectId);
    }

    private native float getCcdSweptSphereRadius(long var1);

    public float getCcdMotionThreshold() {
        return this.getCcdMotionThreshold(this.objectId);
    }

    private native float getCcdMotionThreshold(long var1);

    public float getCcdSquareMotionThreshold() {
        return this.getCcdSquareMotionThreshold(this.objectId);
    }

    private native float getCcdSquareMotionThreshold(long var1);

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule((Savable)this);
        capsule.write((Savable)this.getPhysicsLocation(new Vector3f()), "physicsLocation", (Savable)new Vector3f());
        capsule.write((Savable)this.getPhysicsRotationMatrix(new Matrix3f()), "physicsRotation", (Savable)new Matrix3f());
        capsule.write(this.getCcdMotionThreshold(), "ccdMotionThreshold", 0.0f);
        capsule.write(this.getCcdSweptSphereRadius(), "ccdSweptSphereRadius", 0.0f);
    }

    @Override
    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule capsule = e.getCapsule((Savable)this);
        this.buildObject();
        this.setPhysicsLocation((Vector3f)capsule.readSavable("physicsLocation", (Savable)new Vector3f()));
        this.setPhysicsRotation((Matrix3f)capsule.readSavable("physicsRotation", (Savable)new Matrix3f()));
        this.setCcdMotionThreshold(capsule.readFloat("ccdMotionThreshold", 0.0f));
        this.setCcdSweptSphereRadius(capsule.readFloat("ccdSweptSphereRadius", 0.0f));
    }
}

