/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.infos.RigidBodyMotionState;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhysicsRigidBody
extends PhysicsCollisionObject {
    protected RigidBodyMotionState motionState = new RigidBodyMotionState();
    protected float mass = 1.0f;
    protected boolean kinematic = false;
    protected ArrayList<PhysicsJoint> joints = new ArrayList(4);

    protected PhysicsRigidBody() {
    }

    public PhysicsRigidBody(CollisionShape shape) {
        this.collisionShape = shape;
        this.rebuildRigidBody();
    }

    public PhysicsRigidBody(CollisionShape shape, float mass) {
        this.collisionShape = shape;
        this.mass = mass;
        this.rebuildRigidBody();
    }

    protected void rebuildRigidBody() {
        boolean removed = false;
        if (this.collisionShape instanceof MeshCollisionShape && this.mass != 0.0f) {
            throw new IllegalStateException("Dynamic rigidbody can not have mesh collision shape!");
        }
        if (this.objectId != 0L) {
            if (this.isInWorld(this.objectId)) {
                PhysicsSpace.getPhysicsSpace().remove(this);
                removed = true;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Clearing RigidBody {0}", Long.toHexString(this.objectId));
            this.finalizeNative(this.objectId);
        }
        this.preRebuild();
        this.objectId = this.createRigidBody(this.mass, this.motionState.getObjectId(), this.collisionShape.getObjectId());
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created RigidBody {0}", Long.toHexString(this.objectId));
        this.postRebuild();
        if (removed) {
            PhysicsSpace.getPhysicsSpace().add(this);
        }
    }

    protected void preRebuild() {
    }

    private native long createRigidBody(float var1, long var2, long var4);

    protected void postRebuild() {
        if (this.mass == 0.0f) {
            this.setStatic(this.objectId, true);
        } else {
            this.setStatic(this.objectId, false);
        }
        this.initUserPointer();
    }

    public RigidBodyMotionState getMotionState() {
        return this.motionState;
    }

    public boolean isInWorld() {
        return this.isInWorld(this.objectId);
    }

    private native boolean isInWorld(long var1);

    public void setPhysicsLocation(Vector3f location) {
        this.setPhysicsLocation(this.objectId, location);
    }

    private native void setPhysicsLocation(long var1, Vector3f var3);

    public void setPhysicsRotation(Matrix3f rotation) {
        this.setPhysicsRotation(this.objectId, rotation);
    }

    private native void setPhysicsRotation(long var1, Matrix3f var3);

    public void setPhysicsRotation(Quaternion rotation) {
        this.setPhysicsRotation(this.objectId, rotation);
    }

    private native void setPhysicsRotation(long var1, Quaternion var3);

    public Vector3f getPhysicsLocation(Vector3f trans) {
        if (trans == null) {
            trans = new Vector3f();
        }
        this.getPhysicsLocation(this.objectId, trans);
        return trans;
    }

    private native void getPhysicsLocation(long var1, Vector3f var3);

    public Quaternion getPhysicsRotation(Quaternion rot) {
        if (rot == null) {
            rot = new Quaternion();
        }
        this.getPhysicsRotation(this.objectId, rot);
        return rot;
    }

    public void setInverseInertiaLocal(Vector3f gravity) {
        this.setInverseInertiaLocal(this.objectId, gravity);
    }

    private native void setInverseInertiaLocal(long var1, Vector3f var3);

    public Vector3f getInverseInertiaLocal(Vector3f trans) {
        if (trans == null) {
            trans = new Vector3f();
        }
        this.getInverseInertiaLocal(this.objectId, trans);
        return trans;
    }

    private native void getInverseInertiaLocal(long var1, Vector3f var3);

    private native void getPhysicsRotation(long var1, Quaternion var3);

    public Matrix3f getPhysicsRotationMatrix(Matrix3f rot) {
        if (rot == null) {
            rot = new Matrix3f();
        }
        this.getPhysicsRotationMatrix(this.objectId, rot);
        return rot;
    }

    private native void getPhysicsRotationMatrix(long var1, Matrix3f var3);

    public Vector3f getPhysicsLocation() {
        Vector3f vec = new Vector3f();
        this.getPhysicsLocation(this.objectId, vec);
        return vec;
    }

    public Quaternion getPhysicsRotation() {
        Quaternion quat = new Quaternion();
        this.getPhysicsRotation(this.objectId, quat);
        return quat;
    }

    public Matrix3f getPhysicsRotationMatrix() {
        Matrix3f mtx = new Matrix3f();
        this.getPhysicsRotationMatrix(this.objectId, mtx);
        return mtx;
    }

    public void setKinematic(boolean kinematic) {
        this.kinematic = kinematic;
        this.setKinematic(this.objectId, kinematic);
    }

    private native void setKinematic(long var1, boolean var3);

    public boolean isKinematic() {
        return this.kinematic;
    }

    public void setContactResponse(boolean responsive) {
        int flags = this.getCollisionFlags(this.objectId);
        flags = responsive ? (flags &= 0xFFFFFFFB) : (flags |= 4);
        this.setCollisionFlags(this.objectId, flags);
    }

    public void setCcdSweptSphereRadius(float radius) {
        this.setCcdSweptSphereRadius(this.objectId, radius);
    }

    private native void setCcdSweptSphereRadius(long var1, float var3);

    public void setCcdMotionThreshold(float threshold) {
        this.setCcdMotionThreshold(this.objectId, threshold);
    }

    private native void setCcdMotionThreshold(long var1, float var3);

    public float getCcdSweptSphereRadius() {
        return this.getCcdSweptSphereRadius(this.objectId);
    }

    private native float getCcdSweptSphereRadius(long var1);

    public float getCcdMotionThreshold() {
        return this.getCcdMotionThreshold(this.objectId);
    }

    private native float getCcdMotionThreshold(long var1);

    public float getCcdSquareMotionThreshold() {
        return this.getCcdSquareMotionThreshold(this.objectId);
    }

    private native float getCcdSquareMotionThreshold(long var1);

    public float getMass() {
        return this.mass;
    }

    public void setMass(float mass) {
        this.mass = mass;
        if (this.collisionShape instanceof MeshCollisionShape && mass != 0.0f) {
            throw new IllegalStateException("Dynamic rigidbody can not have mesh collision shape!");
        }
        if (this.objectId != 0L) {
            if (this.collisionShape != null) {
                this.updateMassProps(this.objectId, this.collisionShape.getObjectId(), mass);
            }
            if (mass == 0.0f) {
                this.setStatic(this.objectId, true);
            } else {
                this.setStatic(this.objectId, false);
            }
        }
    }

    private native void setStatic(long var1, boolean var3);

    private native long updateMassProps(long var1, long var3, float var5);

    public Vector3f getGravity() {
        return this.getGravity(null);
    }

    public Vector3f getGravity(Vector3f gravity) {
        if (gravity == null) {
            gravity = new Vector3f();
        }
        this.getGravity(this.objectId, gravity);
        return gravity;
    }

    private native void getGravity(long var1, Vector3f var3);

    public void setGravity(Vector3f gravity) {
        this.setGravity(this.objectId, gravity);
    }

    private native void setGravity(long var1, Vector3f var3);

    public float getFriction() {
        return this.getFriction(this.objectId);
    }

    private native float getFriction(long var1);

    public void setFriction(float friction) {
        this.setFriction(this.objectId, friction);
    }

    private native void setFriction(long var1, float var3);

    public void setDamping(float linearDamping, float angularDamping) {
        this.setDamping(this.objectId, linearDamping, angularDamping);
    }

    private native void setDamping(long var1, float var3, float var4);

    public void setLinearDamping(float linearDamping) {
        this.setDamping(this.objectId, linearDamping, this.getAngularDamping());
    }

    public void setAngularDamping(float angularDamping) {
        this.setAngularDamping(this.objectId, angularDamping);
    }

    private native void setAngularDamping(long var1, float var3);

    public float getLinearDamping() {
        return this.getLinearDamping(this.objectId);
    }

    private native float getLinearDamping(long var1);

    public float getAngularDamping() {
        return this.getAngularDamping(this.objectId);
    }

    private native float getAngularDamping(long var1);

    public float getRestitution() {
        return this.getRestitution(this.objectId);
    }

    private native float getRestitution(long var1);

    public void setRestitution(float restitution) {
        this.setRestitution(this.objectId, restitution);
    }

    private native void setRestitution(long var1, float var3);

    public Vector3f getAngularVelocity() {
        Vector3f vec = new Vector3f();
        this.getAngularVelocity(this.objectId, vec);
        return vec;
    }

    private native void getAngularVelocity(long var1, Vector3f var3);

    public void getAngularVelocity(Vector3f vec) {
        this.getAngularVelocity(this.objectId, vec);
    }

    public void setAngularVelocity(Vector3f vec) {
        this.setAngularVelocity(this.objectId, vec);
        this.activate();
    }

    private native void setAngularVelocity(long var1, Vector3f var3);

    public Vector3f getLinearVelocity() {
        Vector3f vec = new Vector3f();
        this.getLinearVelocity(this.objectId, vec);
        return vec;
    }

    private native void getLinearVelocity(long var1, Vector3f var3);

    public void getLinearVelocity(Vector3f vec) {
        this.getLinearVelocity(this.objectId, vec);
    }

    public void setLinearVelocity(Vector3f vec) {
        this.setLinearVelocity(this.objectId, vec);
        this.activate();
    }

    private native void setLinearVelocity(long var1, Vector3f var3);

    public void applyForce(Vector3f force, Vector3f location) {
        this.applyForce(this.objectId, force, location);
        this.activate();
    }

    private native void applyForce(long var1, Vector3f var3, Vector3f var4);

    public void applyCentralForce(Vector3f force) {
        this.applyCentralForce(this.objectId, force);
        this.activate();
    }

    private native void applyCentralForce(long var1, Vector3f var3);

    public void applyTorque(Vector3f torque) {
        this.applyTorque(this.objectId, torque);
        this.activate();
    }

    private native void applyTorque(long var1, Vector3f var3);

    public void applyImpulse(Vector3f impulse, Vector3f rel_pos) {
        this.applyImpulse(this.objectId, impulse, rel_pos);
        this.activate();
    }

    private native void applyImpulse(long var1, Vector3f var3, Vector3f var4);

    public void applyTorqueImpulse(Vector3f vec) {
        this.applyTorqueImpulse(this.objectId, vec);
        this.activate();
    }

    private native void applyTorqueImpulse(long var1, Vector3f var3);

    public void clearForces() {
        this.clearForces(this.objectId);
    }

    private native void clearForces(long var1);

    @Override
    public void setCollisionShape(CollisionShape collisionShape) {
        super.setCollisionShape(collisionShape);
        if (collisionShape instanceof MeshCollisionShape && this.mass != 0.0f) {
            throw new IllegalStateException("Dynamic rigidbody can not have mesh collision shape!");
        }
        if (this.objectId == 0L) {
            this.rebuildRigidBody();
        } else {
            this.setCollisionShape(this.objectId, collisionShape.getObjectId());
            this.updateMassProps(this.objectId, collisionShape.getObjectId(), this.mass);
        }
    }

    private native void setCollisionShape(long var1, long var3);

    public void activate() {
        this.activate(this.objectId);
    }

    private native void activate(long var1);

    public boolean isActive() {
        return this.isActive(this.objectId);
    }

    private native boolean isActive(long var1);

    public void setSleepingThresholds(float linear, float angular) {
        this.setSleepingThresholds(this.objectId, linear, angular);
    }

    private native void setSleepingThresholds(long var1, float var3, float var4);

    public void setLinearSleepingThreshold(float linearSleepingThreshold) {
        this.setLinearSleepingThreshold(this.objectId, linearSleepingThreshold);
    }

    private native void setLinearSleepingThreshold(long var1, float var3);

    public void setAngularSleepingThreshold(float angularSleepingThreshold) {
        this.setAngularSleepingThreshold(this.objectId, angularSleepingThreshold);
    }

    private native void setAngularSleepingThreshold(long var1, float var3);

    public float getLinearSleepingThreshold() {
        return this.getLinearSleepingThreshold(this.objectId);
    }

    private native float getLinearSleepingThreshold(long var1);

    public float getAngularSleepingThreshold() {
        return this.getAngularSleepingThreshold(this.objectId);
    }

    private native float getAngularSleepingThreshold(long var1);

    public float getAngularFactor() {
        return this.getAngularFactor(null).getX();
    }

    public Vector3f getAngularFactor(Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        this.getAngularFactor(this.objectId, store);
        return store;
    }

    private native void getAngularFactor(long var1, Vector3f var3);

    public void setAngularFactor(float factor) {
        this.setAngularFactor(this.objectId, new Vector3f(factor, factor, factor));
    }

    public void setAngularFactor(Vector3f factor) {
        this.setAngularFactor(this.objectId, factor);
    }

    private native void setAngularFactor(long var1, Vector3f var3);

    public Vector3f getLinearFactor() {
        Vector3f vec = new Vector3f();
        this.getLinearFactor(this.objectId, vec);
        return vec;
    }

    private native void getLinearFactor(long var1, Vector3f var3);

    public void setLinearFactor(Vector3f factor) {
        this.setLinearFactor(this.objectId, factor);
    }

    private native void setLinearFactor(long var1, Vector3f var3);

    public void addJoint(PhysicsJoint joint) {
        if (!this.joints.contains(joint)) {
            this.joints.add(joint);
        }
    }

    public void removeJoint(PhysicsJoint joint) {
        this.joints.remove(joint);
    }

    public List<PhysicsJoint> getJoints() {
        return this.joints;
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule((Savable)this);
        capsule.write(this.getMass(), "mass", 1.0f);
        capsule.write((Savable)this.getGravity(), "gravity", (Savable)Vector3f.ZERO);
        capsule.write(this.isContactResponse(), "contactResponse", true);
        capsule.write(this.getFriction(), "friction", 0.5f);
        capsule.write(this.getRestitution(), "restitution", 0.0f);
        Vector3f angularFactor = this.getAngularFactor(null);
        if (angularFactor.x == angularFactor.y && angularFactor.y == angularFactor.z) {
            capsule.write(this.getAngularFactor(), "angularFactor", 1.0f);
        } else {
            capsule.write((Savable)this.getAngularFactor(null), "angularFactor", (Savable)Vector3f.UNIT_XYZ);
            capsule.write((Savable)this.getLinearFactor(), "linearFactor", (Savable)Vector3f.UNIT_XYZ);
        }
        capsule.write(this.kinematic, "kinematic", false);
        capsule.write(this.getLinearDamping(), "linearDamping", 0.0f);
        capsule.write(this.getAngularDamping(), "angularDamping", 0.0f);
        capsule.write(this.getLinearSleepingThreshold(), "linearSleepingThreshold", 0.8f);
        capsule.write(this.getAngularSleepingThreshold(), "angularSleepingThreshold", 1.0f);
        capsule.write(this.getCcdMotionThreshold(), "ccdMotionThreshold", 0.0f);
        capsule.write(this.getCcdSweptSphereRadius(), "ccdSweptSphereRadius", 0.0f);
        capsule.write((Savable)this.getPhysicsLocation(new Vector3f()), "physicsLocation", (Savable)new Vector3f());
        capsule.write((Savable)this.getPhysicsRotationMatrix(new Matrix3f()), "physicsRotation", (Savable)new Matrix3f());
        capsule.write((Savable)this.getLinearVelocity(), "linearVelocity", null);
        capsule.write((Savable)this.getAngularVelocity(), "angularVelocity", null);
        capsule.writeSavableArrayList(this.joints, "joints", null);
    }

    @Override
    public void read(JmeImporter e) throws IOException {
        float mass;
        super.read(e);
        InputCapsule capsule = e.getCapsule((Savable)this);
        this.mass = mass = capsule.readFloat("mass", 1.0f);
        this.rebuildRigidBody();
        this.setGravity((Vector3f)capsule.readSavable("gravity", (Savable)Vector3f.ZERO.clone()));
        this.setContactResponse(capsule.readBoolean("contactResponse", true));
        this.setFriction(capsule.readFloat("friction", 0.5f));
        this.setKinematic(capsule.readBoolean("kinematic", false));
        this.setRestitution(capsule.readFloat("restitution", 0.0f));
        Vector3f angularFactor = (Vector3f)capsule.readSavable("angularFactor", null);
        if (angularFactor == null) {
            this.setAngularFactor(capsule.readFloat("angularFactor", 1.0f));
        } else {
            this.setAngularFactor(angularFactor);
            this.setLinearFactor((Vector3f)capsule.readSavable("linearFactor", (Savable)Vector3f.UNIT_XYZ.clone()));
        }
        this.setDamping(capsule.readFloat("linearDamping", 0.0f), capsule.readFloat("angularDamping", 0.0f));
        this.setSleepingThresholds(capsule.readFloat("linearSleepingThreshold", 0.8f), capsule.readFloat("angularSleepingThreshold", 1.0f));
        this.setCcdMotionThreshold(capsule.readFloat("ccdMotionThreshold", 0.0f));
        this.setCcdSweptSphereRadius(capsule.readFloat("ccdSweptSphereRadius", 0.0f));
        this.setPhysicsLocation((Vector3f)capsule.readSavable("physicsLocation", (Savable)new Vector3f()));
        this.setPhysicsRotation((Matrix3f)capsule.readSavable("physicsRotation", (Savable)new Matrix3f()));
        this.setLinearVelocity((Vector3f)capsule.readSavable("linearVelocity", (Savable)new Vector3f()));
        this.setAngularVelocity((Vector3f)capsule.readSavable("angularVelocity", (Savable)new Vector3f()));
        this.joints = capsule.readSavableArrayList("joints", null);
    }
}

