/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.system.AWTFrameProcessor;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class AWTComponentRenderer {
    protected static final int RUNNING_STATE = 1;
    protected static final int WAITING_STATE = 2;
    protected static final int DISPOSING_STATE = 3;
    protected static final int DISPOSED_STATE = 4;
    protected final AtomicInteger frameState;
    protected final AtomicInteger imageState;
    protected final FrameBuffer frameBuffer;
    protected final Graphics pixelWriter;
    protected final ByteBuffer frameByteBuffer;
    protected final AWTFrameProcessor.TransferMode transferMode;
    protected final byte[] byteBuffer;
    protected final int[] imageByteBuffer;
    protected final byte[] prevImageByteBuffer;
    protected int frameCount;
    private final int width;
    private final int height;
    private ColorModel colorModel = null;
    private Component component = null;
    private Graphics2D offGraphics = null;

    public AWTComponentRenderer(Component destination, int width, int height, AWTFrameProcessor.TransferMode transferMode) {
        this(destination, transferMode, null, width, height);
    }

    public AWTComponentRenderer(Component destination, AWTFrameProcessor.TransferMode transferMode, FrameBuffer frameBuffer, int width, int height) {
        this.transferMode = transferMode;
        this.frameState = new AtomicInteger(2);
        this.imageState = new AtomicInteger(2);
        this.width = frameBuffer != null ? frameBuffer.getWidth() : width;
        this.height = frameBuffer != null ? frameBuffer.getHeight() : height;
        this.frameCount = 0;
        if (frameBuffer != null) {
            this.frameBuffer = frameBuffer;
        } else {
            this.frameBuffer = new FrameBuffer(width, height, 1);
            this.frameBuffer.setDepthBuffer(Image.Format.Depth);
            this.frameBuffer.setColorBuffer(Image.Format.RGBA8);
            this.frameBuffer.setSrgb(true);
        }
        this.colorModel = ColorModel.getRGBdefault();
        this.frameByteBuffer = BufferUtils.createByteBuffer((int)(this.getWidth() * this.getHeight() * 4));
        this.byteBuffer = new byte[this.getWidth() * this.getHeight() * 4];
        this.prevImageByteBuffer = new byte[this.getWidth() * this.getHeight() * 4];
        this.imageByteBuffer = new int[this.getWidth() * this.getHeight()];
        this.pixelWriter = this.getGraphics(destination);
        this.component = destination;
    }

    public void init(Renderer renderer, boolean main) {
        if (main) {
            renderer.setMainFrameBufferOverride(this.frameBuffer);
        }
    }

    protected Graphics getGraphics(Component destination) {
        if (destination != null) {
            if (destination.getGraphics() != null) {
                return destination.getGraphics();
            }
            System.out.println("AWT component " + destination.getClass().getSimpleName() + " does not provide 2D graphics capabilities.");
            return null;
        }
        throw new NullPointerException("Component cannot be null.");
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrameBufferToImage(RenderManager renderManager) {
        while (!this.frameState.compareAndSet(2, 1)) {
            if (this.frameState.get() != 4) continue;
            return;
        }
        try {
            this.frameByteBuffer.clear();
            Renderer renderer = renderManager.getRenderer();
            renderer.readFrameBufferWithFormat(this.frameBuffer, this.frameByteBuffer, Image.Format.RGBA8);
        }
        finally {
            if (!this.frameState.compareAndSet(1, 2)) {
                throw new RuntimeException("unknown problem with the frame state");
            }
        }
        byte[] byArray = this.byteBuffer;
        synchronized (this.byteBuffer) {
            this.frameByteBuffer.get(this.byteBuffer);
            if (this.transferMode == AWTFrameProcessor.TransferMode.ON_CHANGES) {
                byte[] prevBuffer = this.getPrevImageByteBuffer();
                if (Arrays.equals(prevBuffer, this.byteBuffer)) {
                    if (this.frameCount == 0) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                } else {
                    this.frameCount = 2;
                    System.arraycopy(this.byteBuffer, 0, prevBuffer, 0, this.byteBuffer.length);
                }
                this.frameByteBuffer.position(0);
                --this.frameCount;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AWTComponentRenderer.this.writeFrame();
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFrame() {
        if (this.pixelWriter != null) {
            while (!this.imageState.compareAndSet(2, 1)) {
                if (this.imageState.get() != 4) continue;
                return;
            }
            try {
                int[] imageDataBuffer = this.getImageByteBuffer();
                byte[] byArray = this.byteBuffer;
                synchronized (this.byteBuffer) {
                    for (int i = 0; i < this.width * this.height; ++i) {
                        imageDataBuffer[i] = (0xFF & this.byteBuffer[i * 4 + 3]) << 24 | (0xFF & this.byteBuffer[i * 4]) << 16 | (0xFF & this.byteBuffer[i * 4 + 1]) << 8 | 0xFF & this.byteBuffer[i * 4 + 2];
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    DataBufferInt buffer = new DataBufferInt(imageDataBuffer, imageDataBuffer.length);
                    SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(3, this.getWidth(), this.getHeight(), new int[]{0xFF0000, 65280, 255, -16777216});
                    WritableRaster raster = Raster.createWritableRaster(sm, buffer, null);
                    BufferedImage img = new BufferedImage(this.colorModel, raster, false, null);
                    BufferedImage img2 = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                    this.offGraphics = img2.createGraphics();
                    this.offGraphics.setColor(this.component.getBackground());
                    img2.createGraphics().fillRect(0, 0, this.getWidth(), this.getHeight());
                    img2.createGraphics().drawImage(img, null, null);
                    this.component.getGraphics().drawImage(img2, 0, 0, null);
                }
            }
            finally {
                if (!this.imageState.compareAndSet(1, 2)) {
                    throw new RuntimeException("unknown problem with the image state");
                }
            }
        }
        System.out.println("No graphics context available for rendering.");
    }

    protected int[] getImageByteBuffer() {
        return this.imageByteBuffer;
    }

    protected byte[] getPrevImageByteBuffer() {
        return this.prevImageByteBuffer;
    }

    public void dispose() {
        while (!this.frameState.compareAndSet(2, 3)) {
        }
        while (!this.imageState.compareAndSet(2, 3)) {
        }
        this.frameBuffer.dispose();
        BufferUtils.destroyDirectBuffer((Buffer)this.frameByteBuffer);
        this.frameState.compareAndSet(3, 4);
        this.imageState.compareAndSet(3, 4);
    }
}

