/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cursors.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.cursors.plugins.JmeCursor;
import com.jme3.util.BufferUtils;
import com.jme3.util.LittleEndien;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class CursorLoader
implements AssetLoader {
    private static final int FDE_OFFSET = 6;
    private boolean isIco;
    private boolean isAni;
    private boolean isCur;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmeCursor load(AssetInfo info) throws IOException {
        this.isIco = false;
        this.isAni = false;
        this.isCur = false;
        this.isIco = info.getKey().getExtension().equals("ico");
        if (!this.isIco) {
            this.isCur = info.getKey().getExtension().equals("cur");
            if (!this.isCur) {
                this.isAni = info.getKey().getExtension().equals("ani");
            }
        }
        if (!(this.isAni || this.isIco || this.isCur)) {
            throw new IllegalArgumentException("Cursors supported are .ico, .cur or .ani");
        }
        try (InputStream in = null;){
            in = info.openStream();
            JmeCursor jmeCursor = this.loadCursor(in);
            return jmeCursor;
        }
    }

    private JmeCursor loadCursor(InputStream inStream) throws IOException {
        byte[] icoimages = new byte[]{};
        if (this.isAni) {
            CursorImageData ciDat = new CursorImageData();
            int numIcons = 0;
            int jiffy = 0;
            int steps = 0;
            int width = 0;
            int height = 0;
            int flag = 0;
            int[] rate = null;
            int[] animSeq = null;
            LittleEndien leIn = new LittleEndien(inStream);
            int riff = leIn.readInt();
            if (riff == 1179011410) {
                leIn.readInt();
                int nextInt = 0;
                nextInt = this.getNext((DataInput)leIn);
                if (nextInt == 1313817409) {
                    nextInt = this.getNext((DataInput)leIn);
                    while (nextInt >= 0) {
                        int i;
                        int length;
                        if (nextInt == 1751740001) {
                            leIn.skipBytes(8);
                            numIcons = leIn.readInt();
                            steps = leIn.readInt();
                            width = leIn.readInt();
                            height = leIn.readInt();
                            leIn.skipBytes(8);
                            jiffy = leIn.readInt();
                            flag = leIn.readInt();
                            nextInt = leIn.readInt();
                            continue;
                        }
                        if (nextInt == 1702125938) {
                            length = leIn.readInt();
                            rate = new int[length / 4];
                            for (i = 0; i < length / 4; ++i) {
                                rate[i] = leIn.readInt();
                            }
                            nextInt = leIn.readInt();
                            continue;
                        }
                        if (nextInt == 544302451) {
                            length = leIn.readInt();
                            animSeq = new int[length / 4];
                            for (i = 0; i < length / 4; ++i) {
                                animSeq[i] = leIn.readInt();
                            }
                            nextInt = leIn.readInt();
                            continue;
                        }
                        if (nextInt != 1414744396) continue;
                        length = leIn.readInt();
                        nextInt = leIn.readInt();
                        if (nextInt == 1330007625) {
                            leIn.skipBytes(length - 4);
                            nextInt = leIn.readInt();
                            continue;
                        }
                        if (nextInt != 1835102822 || leIn.readInt() != 1852793705) continue;
                        int icoLength = leIn.readInt();
                        ciDat.numImages = numIcons;
                        ArrayList<byte[]> icons = new ArrayList<byte[]>(numIcons);
                        for (int i2 = 0; i2 < numIcons; ++i2) {
                            if (i2 > 0) {
                                leIn.skipBytes(8);
                            }
                            byte[] data = new byte[icoLength];
                            ((InputStream)leIn).read(data, 0, icoLength);
                            if (width == 0 || height == 0 && i2 == 1) {
                                width = data[6];
                                height = data[7];
                            }
                            icons.add(data);
                        }
                        ciDat.assembleCursor(icons, rate, animSeq, jiffy, steps, width, height);
                        ciDat.completeCursor();
                        nextInt = leIn.readInt();
                        nextInt = nextInt > -1 ? -1 : nextInt;
                    }
                }
                return this.setJmeCursor(ciDat);
            }
            if (riff == 1481001298) {
                throw new IllegalArgumentException("Big-Endian RIFX is not supported. Sorry.");
            }
            throw new IllegalArgumentException("Unknown format.");
        }
        if (this.isCur || this.isIco) {
            int bytesRead;
            DataInputStream in = new DataInputStream(inStream);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[16384];
            while ((bytesRead = in.read(buffer)) >= 0) {
                out.write(buffer, 0, bytesRead);
            }
            icoimages = out.toByteArray();
        }
        BufferedImage[] bi = this.parseICOImage(icoimages);
        int hotSpotX = 0;
        int hotSpotY = 0;
        CursorImageData cid = new CursorImageData(bi, 0, hotSpotX, hotSpotY, 0);
        if (this.isCur) {
            hotSpotX = icoimages[10] + icoimages[11] * 255;
            hotSpotY = icoimages[12] + icoimages[13] * 255;
            cid.xHotSpot = hotSpotX;
            cid.yHotSpot = cid.height - 1 - hotSpotY;
        }
        cid.completeCursor();
        return this.setJmeCursor(cid);
    }

    private JmeCursor setJmeCursor(CursorImageData cid) {
        JmeCursor jmeCursor = new JmeCursor();
        jmeCursor.setWidth(cid.width);
        jmeCursor.setHeight(cid.height);
        jmeCursor.setxHotSpot(cid.xHotSpot);
        jmeCursor.setyHotSpot(cid.yHotSpot);
        jmeCursor.setNumImages(cid.numImages);
        jmeCursor.setImagesDelay(cid.imgDelay);
        jmeCursor.setImagesData(cid.data);
        return jmeCursor;
    }

    private BufferedImage[] parseICOImage(byte[] icoimage) throws IOException {
        int DE_LENGTH = 16;
        int BMIH_LENGTH = 40;
        if (icoimage[2] != 1 && icoimage[2] != 2 || icoimage[3] != 0) {
            throw new IllegalArgumentException("Bad data in ICO/CUR file. ImageType has to be either 1 or 2.");
        }
        int numImages = this.ubyte(icoimage[5]);
        numImages <<= 8;
        BufferedImage[] bi = new BufferedImage[numImages |= icoimage[4]];
        int[] colorCount = new int[numImages];
        for (int i = 0; i < numImages; ++i) {
            int width = this.ubyte(icoimage[6 + i * DE_LENGTH]);
            int height = this.ubyte(icoimage[6 + i * DE_LENGTH + 1]);
            colorCount[i] = this.ubyte(icoimage[6 + i * DE_LENGTH + 2]);
            int bytesInRes = this.ubyte(icoimage[6 + i * DE_LENGTH + 11]);
            bytesInRes <<= 8;
            bytesInRes |= this.ubyte(icoimage[6 + i * DE_LENGTH + 10]);
            bytesInRes <<= 8;
            bytesInRes |= this.ubyte(icoimage[6 + i * DE_LENGTH + 9]);
            bytesInRes <<= 8;
            bytesInRes |= this.ubyte(icoimage[6 + i * DE_LENGTH + 8]);
            int imageOffset = this.ubyte(icoimage[6 + i * DE_LENGTH + 15]);
            imageOffset <<= 8;
            imageOffset |= this.ubyte(icoimage[6 + i * DE_LENGTH + 14]);
            imageOffset <<= 8;
            imageOffset |= this.ubyte(icoimage[6 + i * DE_LENGTH + 13]);
            imageOffset <<= 8;
            if (icoimage[imageOffset |= this.ubyte(icoimage[6 + i * DE_LENGTH + 12])] == 40 && icoimage[imageOffset + 1] == 0 && icoimage[imageOffset + 2] == 0 && icoimage[imageOffset + 3] == 0) {
                int rgb;
                int index;
                int col;
                int row;
                int[] masks;
                int andImageOffset;
                int scanlineBytes;
                int xorImageOffset;
                int _width = this.ubyte(icoimage[imageOffset + 7]);
                _width <<= 8;
                _width |= this.ubyte(icoimage[imageOffset + 6]);
                _width <<= 8;
                _width |= this.ubyte(icoimage[imageOffset + 5]);
                _width <<= 8;
                _width |= this.ubyte(icoimage[imageOffset + 4]);
                if (width == 0) {
                    width = _width;
                }
                int _height = this.ubyte(icoimage[imageOffset + 11]);
                _height <<= 8;
                _height |= this.ubyte(icoimage[imageOffset + 10]);
                _height <<= 8;
                _height |= this.ubyte(icoimage[imageOffset + 9]);
                _height <<= 8;
                _height |= this.ubyte(icoimage[imageOffset + 8]);
                if (height == 0) {
                    height = _height >> 1;
                }
                int planes = this.ubyte(icoimage[imageOffset + 13]);
                planes <<= 8;
                planes |= this.ubyte(icoimage[imageOffset + 12]);
                int bitCount = this.ubyte(icoimage[imageOffset + 15]);
                bitCount <<= 8;
                bitCount |= this.ubyte(icoimage[imageOffset + 14]);
                if (colorCount[i] == 0) {
                    if (planes == 1) {
                        if (bitCount == 1) {
                            colorCount[i] = 2;
                        } else if (bitCount == 4) {
                            colorCount[i] = 16;
                        } else if (bitCount == 8) {
                            colorCount[i] = 256;
                        } else if (bitCount != 32) {
                            colorCount[i] = (int)Math.pow(2.0, bitCount);
                        }
                    } else {
                        colorCount[i] = (int)Math.pow(2.0, bitCount * planes);
                    }
                }
                bi[i] = new BufferedImage(width, height, 2);
                int colorTableOffset = imageOffset + BMIH_LENGTH;
                if (colorCount[i] == 2) {
                    xorImageOffset = colorTableOffset + 8;
                    scanlineBytes = this.calcScanlineBytes(width, 1);
                    andImageOffset = xorImageOffset + scanlineBytes * height;
                    masks = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
                    for (row = 0; row < height; ++row) {
                        for (col = 0; col < width; ++col) {
                            index = (this.ubyte(icoimage[xorImageOffset + row * scanlineBytes + col / 8]) & masks[col % 8]) != 0 ? 1 : 0;
                            rgb = 0;
                            rgb |= this.ubyte(icoimage[colorTableOffset + index * 4 + 2]);
                            rgb <<= 8;
                            rgb |= this.ubyte(icoimage[colorTableOffset + index * 4 + 1]);
                            rgb <<= 8;
                            rgb |= this.ubyte(icoimage[colorTableOffset + index * 4]);
                            if ((this.ubyte(icoimage[andImageOffset + row * scanlineBytes + col / 8]) & masks[col % 8]) != 0) {
                                bi[i].setRGB(col, height - 1 - row, rgb);
                                continue;
                            }
                            bi[i].setRGB(col, height - 1 - row, 0xFF000000 | rgb);
                        }
                    }
                    continue;
                }
                if (colorCount[i] == 16) {
                    xorImageOffset = colorTableOffset + 64;
                    scanlineBytes = this.calcScanlineBytes(width, 4);
                    andImageOffset = xorImageOffset + scanlineBytes * height;
                    masks = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
                    for (row = 0; row < height; ++row) {
                        for (col = 0; col < width; ++col) {
                            if ((col & 1) == 0) {
                                index = this.ubyte(icoimage[xorImageOffset + row * scanlineBytes + col / 2]);
                                index >>= 4;
                            } else {
                                index = this.ubyte(icoimage[xorImageOffset + row * scanlineBytes + col / 2]) & 0xF;
                            }
                            rgb = 0;
                            rgb |= this.ubyte(icoimage[colorTableOffset + index * 4 + 2]);
                            rgb <<= 8;
                            rgb |= this.ubyte(icoimage[colorTableOffset + index * 4 + 1]);
                            rgb <<= 8;
                            rgb |= this.ubyte(icoimage[colorTableOffset + index * 4]);
                            if ((this.ubyte(icoimage[andImageOffset + row * this.calcScanlineBytes(width, 1) + col / 8]) & masks[col % 8]) != 0) {
                                bi[i].setRGB(col, height - 1 - row, rgb);
                                continue;
                            }
                            bi[i].setRGB(col, height - 1 - row, 0xFF000000 | rgb);
                        }
                    }
                    continue;
                }
                if (colorCount[i] == 256) {
                    xorImageOffset = colorTableOffset + 1024;
                    scanlineBytes = this.calcScanlineBytes(width, 8);
                    andImageOffset = xorImageOffset + scanlineBytes * height;
                    masks = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
                    for (row = 0; row < height; ++row) {
                        for (col = 0; col < width; ++col) {
                            index = this.ubyte(icoimage[xorImageOffset + row * scanlineBytes + col]);
                            rgb = 0;
                            rgb |= this.ubyte(icoimage[colorTableOffset + index * 4 + 2]);
                            rgb <<= 8;
                            rgb |= this.ubyte(icoimage[colorTableOffset + index * 4 + 1]);
                            rgb <<= 8;
                            rgb |= this.ubyte(icoimage[colorTableOffset + index * 4]);
                            if ((this.ubyte(icoimage[andImageOffset + row * this.calcScanlineBytes(width, 1) + col / 8]) & masks[col % 8]) != 0) {
                                bi[i].setRGB(col, height - 1 - row, rgb);
                                continue;
                            }
                            bi[i].setRGB(col, height - 1 - row, 0xFF000000 | rgb);
                        }
                    }
                    continue;
                }
                if (colorCount[i] != 0) continue;
                int scanlineBytes2 = this.calcScanlineBytes(width, 32);
                for (int row2 = 0; row2 < height; ++row2) {
                    for (int col2 = 0; col2 < width; ++col2) {
                        int rgb2 = this.ubyte(icoimage[colorTableOffset + row2 * scanlineBytes2 + col2 * 4 + 3]);
                        rgb2 <<= 8;
                        rgb2 |= this.ubyte(icoimage[colorTableOffset + row2 * scanlineBytes2 + col2 * 4 + 2]);
                        rgb2 <<= 8;
                        rgb2 |= this.ubyte(icoimage[colorTableOffset + row2 * scanlineBytes2 + col2 * 4 + 1]);
                        rgb2 <<= 8;
                        bi[i].setRGB(col2, height - 1 - row2, rgb2 |= this.ubyte(icoimage[colorTableOffset + row2 * scanlineBytes2 + col2 * 4]));
                    }
                }
                continue;
            }
            if (this.ubyte(icoimage[imageOffset]) == 137 && icoimage[imageOffset + 1] == 80 && icoimage[imageOffset + 2] == 78 && icoimage[imageOffset + 3] == 71 && icoimage[imageOffset + 4] == 13 && icoimage[imageOffset + 5] == 10 && icoimage[imageOffset + 6] == 26 && icoimage[imageOffset + 7] == 10) {
                ByteArrayInputStream bais = new ByteArrayInputStream(icoimage, imageOffset, bytesInRes);
                bi[i] = ImageIO.read(bais);
                continue;
            }
            throw new IllegalArgumentException("Bad data in ICO/CUR file. BITMAPINFOHEADER or PNG expected");
        }
        icoimage = null;
        return bi;
    }

    private int ubyte(byte b) {
        return b < 0 ? 256 + b : b;
    }

    private int calcScanlineBytes(int width, int bitCount) {
        return (width * bitCount + 31) / 32 * 4;
    }

    private int getNext(DataInput in) throws IOException {
        return in.readInt();
    }

    private class CursorImageData {
        int width;
        int height;
        int xHotSpot;
        int yHotSpot;
        int numImages;
        IntBuffer imgDelay;
        IntBuffer data;

        public CursorImageData() {
        }

        CursorImageData(BufferedImage[] bi, int delay, int hsX, int hsY, int curType) {
            int count;
            IntBuffer singleCursor = null;
            ArrayList<IntBuffer> cursors = new ArrayList<IntBuffer>();
            int bwidth = 0;
            int bheight = 0;
            boolean multIcons = false;
            for (int i = 0; i < bi.length; ++i) {
                BufferedImage img = bi[i];
                bwidth = img.getWidth();
                bheight = img.getHeight();
                if (curType == 1) {
                    hsX = 0;
                    hsY = bheight - 1;
                } else if (curType == 2) {
                    if (hsY == 0) {
                        hsY = bheight - 1;
                    }
                } else {
                    if (bwidth != 32 && bheight != 32) {
                        multIcons = true;
                        continue;
                    }
                    if (img.getType() != 2) continue;
                    hsY = bheight - 1;
                }
                AffineTransform trans = AffineTransform.getScaleInstance(1.0, -1.0);
                trans.translate(0.0, -img.getHeight(null));
                AffineTransformOp op = new AffineTransformOp(trans, 2);
                img = op.filter(img, null);
                singleCursor = BufferUtils.createIntBuffer((int)(img.getWidth() * img.getHeight()));
                DataBufferInt dataIntBuf = (DataBufferInt)img.getData().getDataBuffer();
                singleCursor = IntBuffer.wrap(dataIntBuf.getData());
                cursors.add(singleCursor);
            }
            if (multIcons) {
                bwidth = 32;
                bheight = 32;
                count = 1;
            } else {
                count = cursors.size();
            }
            this.data = BufferUtils.createIntBuffer((int)(bwidth * bheight));
            this.imgDelay = BufferUtils.createIntBuffer((int)bi.length);
            for (int i = 0; i < count; ++i) {
                this.data.put((IntBuffer)cursors.get(i));
                if (delay <= 0) continue;
                this.imgDelay.put(delay);
            }
            this.width = bwidth;
            this.height = bheight;
            this.xHotSpot = hsX;
            this.yHotSpot = hsY;
            this.numImages = count;
            this.data.rewind();
            if (this.imgDelay != null) {
                this.imgDelay.rewind();
            }
        }

        private void addFrame(byte[] imgData, int rate, int jiffy, int width, int height, int numSeq) throws IOException {
            BufferedImage[] bi = CursorLoader.this.parseICOImage(imgData);
            int hotspotx = 0;
            int hotspoty = 0;
            int type = imgData[2] | imgData[3];
            if (type == 2) {
                hotspotx = imgData[10] | imgData[11];
                hotspoty = imgData[12] | imgData[13];
            } else if (type == 1) {
                hotspotx = 0;
                hotspoty = height - 1;
            }
            if (rate == 0) {
                rate = jiffy;
            }
            CursorImageData cid = new CursorImageData(bi, rate, hotspotx, hotspoty, type);
            this.width = width == 0 ? cid.width : width;
            this.height = height == 0 ? cid.height : height;
            if (this.data == null) {
                this.data = numSeq > this.numImages ? BufferUtils.createIntBuffer((int)(this.width * this.height * numSeq)) : BufferUtils.createIntBuffer((int)(this.width * this.height * this.numImages));
                this.data.put(cid.data);
            } else {
                this.data.put(cid.data);
            }
            if (this.imgDelay == null && (this.numImages > 1 || numSeq > 1)) {
                this.imgDelay = numSeq > this.numImages ? BufferUtils.createIntBuffer((int)numSeq) : BufferUtils.createIntBuffer((int)this.numImages);
                this.imgDelay.put(cid.imgDelay);
            } else if (this.imgDelay != null) {
                this.imgDelay.put(cid.imgDelay);
            }
            this.xHotSpot = cid.xHotSpot;
            this.yHotSpot = cid.yHotSpot;
            cid = null;
        }

        void assembleCursor(ArrayList<byte[]> icons, int[] rate, int[] animSeq, int jiffy, int steps, int width, int height) throws IOException {
            int MULT = 17;
            this.numImages = icons.size();
            int frRate = 0;
            byte[] frame = new byte[]{};
            if (animSeq != null && animSeq.length > 0) {
                for (int i = 0; i < animSeq.length; ++i) {
                    frRate = rate != null ? rate[i] * 17 : jiffy * 17;
                    frame = icons.get(animSeq[i]);
                    this.addFrame(frame, frRate, jiffy, width, height, animSeq.length);
                }
            } else {
                for (int i = 0; i < icons.size(); ++i) {
                    frame = icons.get(i);
                    frRate = rate == null ? jiffy * 17 : rate[i] * 17;
                    this.addFrame(frame, frRate, jiffy, width, height, 0);
                }
            }
        }

        void completeCursor() {
            if (this.numImages == 1) {
                this.imgDelay = null;
            } else {
                this.imgDelay.rewind();
            }
            this.data.rewind();
        }
    }
}

