/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.system.JmeSystem;
import com.jme3.system.NativeLibrary;
import com.jme3.system.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NativeLibraryLoader {
    private static final Logger logger = Logger.getLogger(NativeLibraryLoader.class.getName());
    private static final byte[] buf = new byte[102400];
    private static File extractionFolderOverride = null;
    private static File extractionFolder = null;
    private static final HashMap<NativeLibrary.Key, NativeLibrary> nativeLibraryMap = new HashMap();

    public static void registerNativeLibrary(String name, Platform platform, String path, String extractAsName) {
        nativeLibraryMap.put(new NativeLibrary.Key(name, platform), new NativeLibrary(name, platform, path, extractAsName));
    }

    public static void registerNativeLibrary(String name, Platform platform, String path) {
        NativeLibraryLoader.registerNativeLibrary(name, platform, path, null);
    }

    private NativeLibraryLoader() {
    }

    public static boolean isUsingNativeBullet() {
        try {
            Class<?> clazz = Class.forName("com.jme3.bullet.util.NativeMeshUtil");
            return clazz != null;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static void setCustomExtractionFolder(String path) {
        extractionFolderOverride = new File(path).getAbsoluteFile();
    }

    public static File getExtractionFolder() {
        if (extractionFolderOverride != null) {
            return extractionFolderOverride;
        }
        if (extractionFolder == null) {
            File workingFolder = new File("").getAbsoluteFile();
            if (!workingFolder.canWrite()) {
                NativeLibraryLoader.setExtractionFolderToUserCache();
            } else {
                try {
                    File file = new File(workingFolder + File.separator + ".jmetestwrite");
                    file.createNewFile();
                    file.delete();
                    extractionFolder = workingFolder;
                }
                catch (Exception e) {
                    NativeLibraryLoader.setExtractionFolderToUserCache();
                }
            }
        }
        return extractionFolder;
    }

    private static File getJmeUserCacheFolder() {
        File userHomeFolder = new File(System.getProperty("user.home"));
        File userCacheFolder = null;
        switch (JmeSystem.getPlatform()) {
            case Linux32: 
            case Linux64: {
                userCacheFolder = new File(userHomeFolder, ".cache");
                break;
            }
            case MacOSX32: 
            case MacOSX64: 
            case MacOSX_PPC32: 
            case MacOSX_PPC64: {
                userCacheFolder = new File(new File(userHomeFolder, "Library"), "Caches");
                break;
            }
            case Windows32: 
            case Windows64: {
                userCacheFolder = new File(new File(userHomeFolder, "AppData"), "Local");
            }
        }
        if (userCacheFolder == null || !userCacheFolder.exists()) {
            return new File(userHomeFolder, ".jme3");
        }
        return new File(userCacheFolder, "jme3");
    }

    private static void setExtractionFolderToUserCache() {
        File extractFolderInHome = NativeLibraryLoader.getJmeUserCacheFolder();
        if (!extractFolderInHome.exists()) {
            extractFolderInHome.mkdir();
        }
        if (!(extractionFolder = new File(extractFolderInHome, "natives_" + Integer.toHexString(NativeLibraryLoader.computeNativesHash()))).exists()) {
            extractionFolder.mkdir();
        }
        logger.log(Level.WARNING, "Working directory is not writable. Natives will be extracted to:\n{0}", extractionFolder);
    }

    private static int computeNativesHash() {
        URLConnection conn = null;
        try {
            int hash;
            String classpath = System.getProperty("java.class.path");
            URL url = Thread.currentThread().getContextClassLoader().getResource("com/jme3/system/NativeLibraryLoader.class");
            StringBuilder sb = new StringBuilder(url.toString());
            if (sb.indexOf("jar:") == 0) {
                sb.delete(0, 4);
                sb.delete(sb.indexOf("!"), sb.length());
                sb.delete(sb.lastIndexOf("/") + 1, sb.length());
            }
            try {
                url = new URL(sb.toString());
            }
            catch (MalformedURLException ex) {
                throw new UnsupportedOperationException(ex);
            }
            conn = url.openConnection();
            int n = hash = classpath.hashCode() ^ (int)conn.getLastModified();
            return n;
        }
        catch (IOException ex) {
            throw new UnsupportedOperationException(ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.getInputStream().close();
                    conn.getOutputStream().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static File[] getJarsWithNatives() {
        HashSet<File> jarFiles = new HashSet<File>();
        for (Map.Entry<NativeLibrary.Key, NativeLibrary> lib : nativeLibraryMap.entrySet()) {
            File jarFile = NativeLibraryLoader.getJarForNativeLibrary(lib.getValue().getPlatform(), lib.getValue().getName());
            if (jarFile == null) continue;
            jarFiles.add(jarFile);
        }
        return jarFiles.toArray(new File[0]);
    }

    public static void extractNativeLibraries(Platform platform, File targetDir) throws IOException {
        for (Map.Entry<NativeLibrary.Key, NativeLibrary> lib : nativeLibraryMap.entrySet()) {
            if (lib.getValue().getPlatform() != platform) continue;
            if (!targetDir.exists()) {
                targetDir.mkdirs();
            }
            NativeLibraryLoader.extractNativeLibrary(platform, lib.getValue().getName(), targetDir);
        }
    }

    private static String unmapLibraryName(String filename) {
        int dot;
        StringBuilder sb = new StringBuilder(filename);
        if (sb.indexOf("lib") == 0 && !filename.toLowerCase().endsWith(".dll")) {
            sb.delete(0, 3);
        }
        if ((dot = sb.lastIndexOf(".")) > 0) {
            sb.delete(dot, sb.length());
        }
        return sb.toString();
    }

    public static File getJarForNativeLibrary(Platform platform, String name) {
        NativeLibrary library = nativeLibraryMap.get(new NativeLibrary.Key(name, platform));
        if (library == null) {
            return null;
        }
        String pathInJar = library.getPathInNativesJar();
        if (pathInJar == null) {
            return null;
        }
        String fileNameInJar = pathInJar.contains("/") ? pathInJar.substring(pathInJar.lastIndexOf("/") + 1) : pathInJar;
        URL url = Thread.currentThread().getContextClassLoader().getResource(pathInJar);
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(fileNameInJar);
        }
        if (url == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(url.toString());
        if (sb.indexOf("jar:file:/") == 0) {
            sb.delete(0, 9);
            sb.delete(sb.indexOf("!"), sb.length());
            return new File(sb.toString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractNativeLibrary(Platform platform, String name, File targetDir) throws IOException {
        NativeLibrary library = nativeLibraryMap.get(new NativeLibrary.Key(name, platform));
        if (library == null) {
            return;
        }
        String pathInJar = library.getPathInNativesJar();
        if (pathInJar == null) {
            return;
        }
        String fileNameInJar = pathInJar.contains("/") ? pathInJar.substring(pathInJar.lastIndexOf("/") + 1) : pathInJar;
        URL url = Thread.currentThread().getContextClassLoader().getResource(pathInJar);
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(fileNameInJar);
        }
        if (url == null) {
            return;
        }
        String loadedAsFileName = library.getExtractedAsName() != null ? library.getExtractedAsName() : fileNameInJar;
        URLConnection conn = url.openConnection();
        InputStream in = conn.getInputStream();
        File targetFile = new File(targetDir, loadedAsFileName);
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(targetFile);
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void loadNativeLibrary(String name, boolean isRequired) {
        InputStream in;
        URLConnection conn;
        if (JmeSystem.isLowPermissions()) {
            throw new UnsupportedOperationException("JVM is running under reduced permissions. Cannot load native libraries.");
        }
        Platform platform = JmeSystem.getPlatform();
        NativeLibrary library = nativeLibraryMap.get(new NativeLibrary.Key(name, platform));
        if (library == null) {
            if (isRequired) {
                throw new UnsatisfiedLinkError("The required native library '" + name + "' is not available for your OS: " + platform);
            }
            logger.log(Level.FINE, "The optional native library ''{0}'' is not available for your OS: {1}", new Object[]{name, platform});
            return;
        }
        String pathInJar = library.getPathInNativesJar();
        if (pathInJar == null) {
            return;
        }
        String fileNameInJar = pathInJar.contains("/") ? pathInJar.substring(pathInJar.lastIndexOf("/") + 1) : pathInJar;
        URL url = Thread.currentThread().getContextClassLoader().getResource(pathInJar);
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(fileNameInJar);
        }
        if (url == null) {
            String unmappedName = NativeLibraryLoader.unmapLibraryName(fileNameInJar);
            try {
                if (!name.equals("lwjgl") && !name.equals("jinput")) {
                    System.loadLibrary(unmappedName);
                    logger.log(Level.FINE, "Loaded system installed version of native library: {0}", unmappedName);
                }
            }
            catch (UnsatisfiedLinkError e) {
                if (isRequired) {
                    throw new UnsatisfiedLinkError("The required native library '" + unmappedName + "' was not found in the classpath via '" + pathInJar + "'. Error message: " + e.getMessage());
                }
                logger.log(Level.FINE, "The optional native library ''{0}'' was not found in the classpath via ''{1}''. Error message: {2}", new Object[]{unmappedName, pathInJar, e.getMessage()});
            }
            return;
        }
        String loadedAsFileName = library.getExtractedAsName() != null ? library.getExtractedAsName() : fileNameInJar;
        File extactionDirectory = NativeLibraryLoader.getExtractionFolder();
        try {
            conn = url.openConnection();
            in = conn.getInputStream();
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to open file: '" + url + "'. Error: " + ex, ex);
        }
        File targetFile = new File(extactionDirectory, loadedAsFileName);
        FileOutputStream out = null;
        try {
            int len;
            long sourceLastModified;
            long targetLastModified;
            if (targetFile.exists() && (targetLastModified = targetFile.lastModified()) + 1000L > (sourceLastModified = conn.getLastModified())) {
                logger.log(Level.FINE, "Not copying library {0}. Latest already extracted.", loadedAsFileName);
                return;
            }
            out = new FileOutputStream(targetFile);
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            in = null;
            ((OutputStream)out).close();
            out = null;
            targetFile.setLastModified(conn.getLastModified());
        }
        catch (IOException ex) {
            if (ex.getMessage().contains("used by another process")) {
                return;
            }
            throw new UncheckedIOException("Failed to extract native library to: " + targetFile, ex);
        }
        finally {
            if (name.equals("lwjgl") || name.equals("lwjgl3")) {
                System.setProperty("org.lwjgl.librarypath", extactionDirectory.getAbsolutePath());
            } else if (name.equals("jinput")) {
                System.setProperty("net.java.games.input.librarypath", extactionDirectory.getAbsolutePath());
            } else {
                System.load(targetFile.getAbsolutePath());
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
        logger.log(Level.FINE, "Loaded native library from ''{0}'' into ''{1}''", new Object[]{url, targetFile});
    }

    static {
        NativeLibraryLoader.registerNativeLibrary("lwjgl", Platform.Windows32, "native/windows/lwjgl.dll");
        NativeLibraryLoader.registerNativeLibrary("lwjgl", Platform.Windows64, "native/windows/lwjgl64.dll");
        NativeLibraryLoader.registerNativeLibrary("lwjgl", Platform.Linux32, "native/linux/liblwjgl.so");
        NativeLibraryLoader.registerNativeLibrary("lwjgl", Platform.Linux64, "native/linux/liblwjgl64.so");
        NativeLibraryLoader.registerNativeLibrary("lwjgl", Platform.MacOSX32, "native/macosx/liblwjgl.dylib");
        NativeLibraryLoader.registerNativeLibrary("lwjgl", Platform.MacOSX64, "native/macosx/liblwjgl.dylib");
        NativeLibraryLoader.registerNativeLibrary("openal", Platform.Windows32, "native/windows/OpenAL32.dll");
        NativeLibraryLoader.registerNativeLibrary("openal", Platform.Windows64, "native/windows/OpenAL64.dll");
        NativeLibraryLoader.registerNativeLibrary("openal", Platform.Linux32, "native/linux/libopenal.so");
        NativeLibraryLoader.registerNativeLibrary("openal", Platform.Linux64, "native/linux/libopenal64.so");
        NativeLibraryLoader.registerNativeLibrary("openal", Platform.MacOSX32, "native/macosx/openal.dylib", "libopenal.dylib");
        NativeLibraryLoader.registerNativeLibrary("openal", Platform.MacOSX64, "native/macosx/openal.dylib", "libopenal.dylib");
        NativeLibraryLoader.registerNativeLibrary("lwjgl3", Platform.Windows32, "native/windows/lwjgl32.dll");
        NativeLibraryLoader.registerNativeLibrary("lwjgl3", Platform.Windows64, "native/windows/lwjgl.dll");
        NativeLibraryLoader.registerNativeLibrary("lwjgl3", Platform.Linux32, "native/linux/liblwjgl32.so");
        NativeLibraryLoader.registerNativeLibrary("lwjgl3", Platform.Linux64, "native/linux/liblwjgl.so");
        NativeLibraryLoader.registerNativeLibrary("lwjgl3", Platform.MacOSX32, "native/macosx/liblwjgl.dylib");
        NativeLibraryLoader.registerNativeLibrary("lwjgl3", Platform.MacOSX64, "native/macosx/liblwjgl.dylib");
        NativeLibraryLoader.registerNativeLibrary("glfw-lwjgl3", Platform.Windows32, "native/windows/glfw32.dll");
        NativeLibraryLoader.registerNativeLibrary("glfw-lwjgl3", Platform.Windows64, "native/windows/glfw.dll");
        NativeLibraryLoader.registerNativeLibrary("glfw-lwjgl3", Platform.Linux32, "native/linux/libglfw32.so");
        NativeLibraryLoader.registerNativeLibrary("glfw-lwjgl3", Platform.Linux64, "native/linux/libglfw.so");
        NativeLibraryLoader.registerNativeLibrary("glfw-lwjgl3", Platform.MacOSX32, "native/macosx/libglfw.dylib");
        NativeLibraryLoader.registerNativeLibrary("glfw-lwjgl3", Platform.MacOSX64, "native/macosx/libglfw.dylib");
        NativeLibraryLoader.registerNativeLibrary("jemalloc-lwjgl3", Platform.Windows32, "native/windows/jemalloc32.dll");
        NativeLibraryLoader.registerNativeLibrary("jemalloc-lwjgl3", Platform.Windows64, "native/windows/jemalloc.dll");
        NativeLibraryLoader.registerNativeLibrary("jemalloc-lwjgl3", Platform.Linux32, "native/linux/libjemalloc32.so");
        NativeLibraryLoader.registerNativeLibrary("jemalloc-lwjgl3", Platform.Linux64, "native/linux/libjemalloc.so");
        NativeLibraryLoader.registerNativeLibrary("jemalloc-lwjgl3", Platform.MacOSX32, "native/macosx/libjemalloc.dylib");
        NativeLibraryLoader.registerNativeLibrary("jemalloc-lwjgl3", Platform.MacOSX64, "native/macosx/libjemalloc.dylib");
        NativeLibraryLoader.registerNativeLibrary("openal-lwjgl3", Platform.Windows32, "native/windows/OpenAL32.dll");
        NativeLibraryLoader.registerNativeLibrary("openal-lwjgl3", Platform.Windows64, "native/windows/OpenAL.dll");
        NativeLibraryLoader.registerNativeLibrary("openal-lwjgl3", Platform.Linux32, "native/linux/libopenal32.so");
        NativeLibraryLoader.registerNativeLibrary("openal-lwjgl3", Platform.Linux64, "native/linux/libopenal.so");
        NativeLibraryLoader.registerNativeLibrary("openal-lwjgl3", Platform.MacOSX32, "native/macosx/openal.dylib", "libopenal.dylib");
        NativeLibraryLoader.registerNativeLibrary("openal-lwjgl3", Platform.MacOSX64, "native/macosx/openal.dylib", "libopenal.dylib");
        NativeLibraryLoader.registerNativeLibrary("bulletjme", Platform.Windows32, "native/windows/x86/bulletjme.dll");
        NativeLibraryLoader.registerNativeLibrary("bulletjme", Platform.Windows64, "native/windows/x86_64/bulletjme.dll");
        NativeLibraryLoader.registerNativeLibrary("bulletjme", Platform.Linux32, "native/linux/x86/libbulletjme.so");
        NativeLibraryLoader.registerNativeLibrary("bulletjme", Platform.Linux64, "native/linux/x86_64/libbulletjme.so");
        NativeLibraryLoader.registerNativeLibrary("bulletjme", Platform.Linux_ARM32, "native/linux/arm32/libbulletjme.so");
        NativeLibraryLoader.registerNativeLibrary("bulletjme", Platform.Linux_ARM64, "native/linux/arm64/libbulletjme.so");
        NativeLibraryLoader.registerNativeLibrary("bulletjme", Platform.MacOSX32, "native/osx/x86/libbulletjme.dylib");
        NativeLibraryLoader.registerNativeLibrary("bulletjme", Platform.MacOSX64, "native/osx/x86_64/libbulletjme.dylib");
        NativeLibraryLoader.registerNativeLibrary("jinput", Platform.Windows32, "native/windows/jinput-raw.dll");
        NativeLibraryLoader.registerNativeLibrary("jinput", Platform.Windows64, "native/windows/jinput-raw_64.dll");
        NativeLibraryLoader.registerNativeLibrary("jinput", Platform.Linux32, "native/windows/libjinput-linux.so");
        NativeLibraryLoader.registerNativeLibrary("jinput", Platform.Linux64, "native/windows/libjinput-linux64.so");
        NativeLibraryLoader.registerNativeLibrary("jinput", Platform.MacOSX32, "native/macosx/libjinput-osx.jnilib", "libjinput-osx.dylib");
        NativeLibraryLoader.registerNativeLibrary("jinput", Platform.MacOSX64, "native/macosx/libjinput-osx.jnilib", "libjinput-osx.dylib");
        NativeLibraryLoader.registerNativeLibrary("jinput-dx8", Platform.Windows32, "native/windows/jinput-dx8.dll");
        NativeLibraryLoader.registerNativeLibrary("jinput-dx8", Platform.Windows64, "native/windows/jinput-dx8_64.dll");
        NativeLibraryLoader.registerNativeLibrary("jinput-dx8", Platform.Linux32, null);
        NativeLibraryLoader.registerNativeLibrary("jinput-dx8", Platform.Linux64, null);
        NativeLibraryLoader.registerNativeLibrary("jinput-dx8", Platform.MacOSX32, null);
        NativeLibraryLoader.registerNativeLibrary("jinput-dx8", Platform.MacOSX64, null);
    }
}

