/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AWTTaskExecutor {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final AWTTaskExecutor INSTANCE = new AWTTaskExecutor();
    private final List<Runnable> waitTasks = new LinkedList<Runnable>();

    public static AWTTaskExecutor getInstance() {
        return INSTANCE;
    }

    private AWTTaskExecutor() {
    }

    public List<Runnable> getWaitingTasks() {
        return this.waitTasks;
    }

    public void addToExecute(Runnable task) {
        this.lock.writeLock().lock();
        try {
            this.waitTasks.add(task);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lock.writeLock().unlock();
    }

    public void execute() {
        if (this.waitTasks.isEmpty()) {
            return;
        }
        this.lock.readLock().lock();
        try {
            for (Runnable runnable : this.waitTasks) {
                runnable.run();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.waitTasks.clear();
        this.lock.readLock().unlock();
    }
}

