/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.system.Platform;
import java.util.function.Consumer;

final class NativeLibrary {
    private final String name;
    private final Platform platform;
    private final String pathInNativesJar;
    private final String extractedAsFileName;
    private final Consumer<String> loadFunction;

    public NativeLibrary(String name, Platform platform, String pathInNativesJar) {
        this(name, platform, pathInNativesJar, null);
    }

    public NativeLibrary(String name, Platform platform, String pathInNativesJar, String extractedAsFileName) {
        this(name, platform, pathInNativesJar, extractedAsFileName, System::load);
    }

    public NativeLibrary(String name, Platform platform, String pathInNativesJar, String extractedAsFileName, Consumer<String> loadFunction) {
        this.name = name;
        this.platform = platform;
        this.pathInNativesJar = pathInNativesJar;
        this.extractedAsFileName = extractedAsFileName;
        this.loadFunction = loadFunction;
    }

    public String getName() {
        return this.name;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getExtractedAsName() {
        return this.extractedAsFileName;
    }

    public String getPathInNativesJar() {
        return this.pathInNativesJar;
    }

    public Consumer<String> getLoadFunction() {
        return this.loadFunction;
    }

    public Key getKey() {
        return new Key(this.getName(), this.getPlatform());
    }

    static final class Key {
        private final String name;
        private final Platform platform;

        public Key(String name, Platform platform) {
            this.name = name;
            this.platform = platform;
        }

        public int hashCode() {
            int hash = 5;
            hash = 79 * hash + this.name.hashCode();
            hash = 79 * hash + this.platform.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            Key other = (Key)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            return this.platform == other.platform;
        }
    }
}

