/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import java.io.IOException;

public class PosterizationFilter
extends Filter {
    private int numColors = 8;
    private float gamma = 0.6f;
    private float strength = 1.0f;

    public PosterizationFilter() {
        super("PosterizationFilter");
    }

    public PosterizationFilter(int numColors) {
        this();
        this.numColors = numColors;
    }

    public PosterizationFilter(int numColors, float gamma) {
        this(numColors);
        this.gamma = gamma;
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(manager, "Common/MatDefs/Post/Posterization.j3md");
        this.material.setInt("NumColors", this.numColors);
        this.material.setFloat("Gamma", this.gamma);
        this.material.setFloat("Strength", this.strength);
    }

    protected Material getMaterial() {
        return this.material;
    }

    public void setNumColors(int numColors) {
        this.numColors = numColors;
        if (this.material != null) {
            this.material.setInt("NumColors", numColors);
        }
    }

    public void setGamma(float gamma) {
        this.gamma = gamma;
        if (this.material != null) {
            this.material.setFloat("Gamma", gamma);
        }
    }

    public void setStrength(float strength) {
        this.strength = strength;
        if (this.material != null) {
            this.material.setFloat("Strength", strength);
        }
    }

    public int getNumColors() {
        return this.numColors;
    }

    public float getGamma() {
        return this.gamma;
    }

    public float getStrength() {
        return this.strength;
    }

    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.gamma = capsule.readFloat("gamma", 0.6f);
        this.numColors = capsule.readInt("numColors", 8);
        this.strength = capsule.readFloat("strength", 1.0f);
    }

    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.gamma, "gamma", 0.6f);
        capsule.write(this.numColors, "numColors", 8);
        capsule.write(this.strength, "strength", 1.0f);
    }
}

