/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SoftBloomFilter
extends Filter {
    private static final Logger logger = Logger.getLogger(SoftBloomFilter.class.getName());
    private AssetManager assetManager;
    private RenderManager renderManager;
    private ViewPort viewPort;
    private int width;
    private int height;
    private Filter.Pass[] downsamplingPasses;
    private Filter.Pass[] upsamplingPasses;
    private final Image.Format format = Image.Format.RGBA16F;
    private boolean initialized = false;
    private int numSamplingPasses = 5;
    private float glowFactor = 0.05f;
    private boolean bilinearFiltering = true;

    public SoftBloomFilter() {
        super("SoftBloomFilter");
    }

    protected void initFilter(AssetManager am, RenderManager rm, ViewPort vp, int w, int h) {
        this.assetManager = am;
        this.renderManager = rm;
        this.viewPort = vp;
        this.postRenderPasses = new LinkedList();
        Renderer renderer = this.renderManager.getRenderer();
        this.width = w;
        this.height = h;
        this.capPassesToSize(w, h);
        this.downsamplingPasses = new Filter.Pass[this.numSamplingPasses];
        this.upsamplingPasses = new Filter.Pass[this.numSamplingPasses];
        final Material downsampleMat = new Material(this.assetManager, "Common/MatDefs/Post/Downsample.j3md");
        final Vector2f initTexelSize = new Vector2f(1.0f / (float)w, 1.0f / (float)h);
        Filter.Pass initialPass = new Filter.Pass(){

            public boolean requiresSceneAsTexture() {
                return true;
            }

            public void beforeRender() {
                downsampleMat.setVector2("TexelSize", initTexelSize);
            }
        };
        initialPass.init(renderer, w >>= 1, h >>= 1, this.format, Image.Format.Depth, 1, downsampleMat);
        this.postRenderPasses.add(initialPass);
        this.downsamplingPasses[0] = initialPass;
        for (int i = 1; i < this.downsamplingPasses.length; ++i) {
            final Vector2f texelSize = new Vector2f(1.0f / (float)w, 1.0f / (float)h);
            final Filter.Pass prev = this.downsamplingPasses[i - 1];
            Filter.Pass pass = new Filter.Pass(){

                public void beforeRender() {
                    downsampleMat.setTexture("Texture", (Texture)prev.getRenderedTexture());
                    downsampleMat.setVector2("TexelSize", texelSize);
                }
            };
            pass.init(renderer, w >>= 1, h >>= 1, this.format, Image.Format.Depth, 1, downsampleMat);
            if (this.bilinearFiltering) {
                pass.getRenderedTexture().setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
            }
            this.postRenderPasses.add(pass);
            this.downsamplingPasses[i] = pass;
        }
        final Material upsampleMat = new Material(this.assetManager, "Common/MatDefs/Post/Upsample.j3md");
        for (int i = 0; i < this.upsamplingPasses.length; ++i) {
            final Vector2f texelSize = new Vector2f(1.0f / (float)w, 1.0f / (float)h);
            final Filter.Pass prev = i == 0 ? this.downsamplingPasses[this.downsamplingPasses.length - 1] : this.upsamplingPasses[i - 1];
            Filter.Pass pass = new Filter.Pass(){

                public void beforeRender() {
                    upsampleMat.setTexture("Texture", (Texture)prev.getRenderedTexture());
                    upsampleMat.setVector2("TexelSize", texelSize);
                }
            };
            pass.init(renderer, w <<= 1, h <<= 1, this.format, Image.Format.Depth, 1, upsampleMat);
            if (this.bilinearFiltering) {
                pass.getRenderedTexture().setMagFilter(Texture.MagFilter.Bilinear);
            }
            this.postRenderPasses.add(pass);
            this.upsamplingPasses[i] = pass;
        }
        this.material = new Material(this.assetManager, "Common/MatDefs/Post/SoftBloomFinal.j3md");
        this.material.setTexture("GlowMap", (Texture)this.upsamplingPasses[this.upsamplingPasses.length - 1].getRenderedTexture());
        this.material.setFloat("GlowFactor", this.glowFactor);
        this.initialized = true;
    }

    protected Material getMaterial() {
        return this.material;
    }

    public void setNumSamplingPasses(int numSamplingPasses) {
        if (numSamplingPasses <= 0) {
            throw new IllegalArgumentException("Number of sampling passes must be greater than zero (found: " + numSamplingPasses + ").");
        }
        if (this.numSamplingPasses != numSamplingPasses) {
            this.numSamplingPasses = numSamplingPasses;
            if (this.initialized) {
                this.initFilter(this.assetManager, this.renderManager, this.viewPort, this.width, this.height);
            }
        }
    }

    public void setGlowFactor(float factor) {
        this.glowFactor = FastMath.clamp((float)factor, (float)0.0f, (float)1.0f);
        if (this.material != null) {
            this.material.setFloat("GlowFactor", this.glowFactor);
        }
    }

    public void setBilinearFiltering(boolean bilinearFiltering) {
        if (this.bilinearFiltering != bilinearFiltering) {
            this.bilinearFiltering = bilinearFiltering;
            if (this.initialized) {
                for (Filter.Pass p : this.downsamplingPasses) {
                    if (this.bilinearFiltering) {
                        p.getRenderedTexture().setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
                        continue;
                    }
                    p.getRenderedTexture().setMinFilter(Texture.MinFilter.NearestNoMipMaps);
                }
                for (Filter.Pass p : this.upsamplingPasses) {
                    if (this.bilinearFiltering) {
                        p.getRenderedTexture().setMagFilter(Texture.MagFilter.Bilinear);
                        continue;
                    }
                    p.getRenderedTexture().setMagFilter(Texture.MagFilter.Nearest);
                }
            }
        }
    }

    public int getNumSamplingPasses() {
        return this.numSamplingPasses;
    }

    public float getGlowFactor() {
        return this.glowFactor;
    }

    public boolean isBilinearFiltering() {
        return this.bilinearFiltering;
    }

    private void capPassesToSize(int w, int h) {
        int limit = Math.min(w, h);
        for (int i = 0; i < this.numSamplingPasses; ++i) {
            if ((limit >>= 1) > 2) continue;
            this.numSamplingPasses = i;
            logger.log(Level.INFO, "Number of sampling passes capped at {0} due to texture size.", i);
            break;
        }
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.numSamplingPasses, "numSamplingPasses", 5);
        oc.write(this.glowFactor, "glowFactor", 0.05f);
        oc.write(this.bilinearFiltering, "bilinearFiltering", true);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.numSamplingPasses = ic.readInt("numSamplingPasses", 5);
        this.glowFactor = ic.readFloat("glowFactor", 0.05f);
        this.bilinearFiltering = ic.readBoolean("bilinearFiltering", true);
    }
}

