/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.water;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Plane;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import com.jme3.water.ReflectionProcessor;
import com.jme3.water.WaterUtils;
import java.io.IOException;

public class WaterFilter
extends Filter
implements JmeCloneable,
Cloneable {
    public static final String DEFAULT_NORMAL_MAP = "Common/MatDefs/Water/Textures/water_normalmap.dds";
    public static final String DEFAULT_FOAM = "Common/MatDefs/Water/Textures/foam.jpg";
    public static final String DEFAULT_CAUSTICS = "Common/MatDefs/Water/Textures/caustics.jpg";
    public static final String DEFAULT_HEIGHT_MAP = "Common/MatDefs/Water/Textures/heightmap.jpg";
    private Filter.Pass reflectionPass;
    protected Spatial reflectionScene;
    protected Spatial rootScene;
    protected ViewPort reflectionView;
    private Texture2D normalTexture;
    private Texture2D foamTexture;
    private Texture2D causticsTexture;
    private Texture2D heightTexture;
    private Camera reflectionCam;
    private Vector3f targetLocation = new Vector3f();
    private ReflectionProcessor reflectionProcessor;
    private Matrix4f biasMatrix = new Matrix4f(0.5f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 1.0f);
    private Matrix4f textureProjMatrix = new Matrix4f();
    private boolean underWater;
    private RenderManager renderManager;
    private ViewPort viewPort;
    private float time = 0.0f;
    private float speed = 1.0f;
    private Vector3f lightDirection = new Vector3f(0.0f, -1.0f, 0.0f);
    private ColorRGBA lightColor = ColorRGBA.White;
    private float waterHeight = 0.0f;
    private Plane plane = new Plane(Vector3f.UNIT_Y, this.waterHeight);
    private ColorRGBA waterColor = new ColorRGBA(0.0078f, 0.3176f, 0.5f, 1.0f);
    private ColorRGBA deepWaterColor = new ColorRGBA(0.0039f, 0.00196f, 0.145f, 1.0f);
    private Vector3f colorExtinction = new Vector3f(5.0f, 20.0f, 30.0f);
    private float waterTransparency = 0.1f;
    private float maxAmplitude = 1.5f;
    private float shoreHardness = 0.1f;
    private boolean useFoam = true;
    private float foamIntensity = 0.5f;
    private float foamHardness = 1.0f;
    private Vector3f foamExistence = new Vector3f(0.45f, 4.35f, 1.5f);
    private float waveScale = 0.005f;
    private float sunScale = 3.0f;
    private float shininess = 0.7f;
    private Vector2f windDirection = new Vector2f(0.0f, -1.0f);
    private int reflectionMapSize = 512;
    private boolean useRipples = true;
    private float normalScale = 3.0f;
    private boolean useHQShoreline = true;
    private boolean useSpecular = true;
    private boolean useRefraction = true;
    private float refractionStrength = 0.0f;
    private float refractionConstant = 0.5f;
    private float reflectionDisplace = 30.0f;
    private float underWaterFogDistance = 120.0f;
    private boolean useCaustics = true;
    private float causticsIntensity = 0.5f;
    private Vector3f center;
    private float radius;
    private AreaShape shapeType = AreaShape.Circular;
    private boolean needSaveReflectionScene;

    public WaterFilter() {
        super("WaterFilter");
    }

    public WaterFilter(Node reflectionScene, Vector3f lightDirection) {
        super("WaterFilter");
        this.reflectionScene = reflectionScene;
        this.lightDirection = lightDirection;
    }

    protected boolean isRequiresDepthTexture() {
        return true;
    }

    protected void preFrame(float tpf) {
        this.time += tpf * this.speed;
        this.material.setFloat("Time", this.time);
        Camera sceneCam = this.viewPort.getCamera();
        this.biasMatrix.mult(sceneCam.getViewProjectionMatrix(), this.textureProjMatrix);
        this.material.setMatrix4("TextureProjMatrix", this.textureProjMatrix);
        this.material.setVector3("CameraPosition", sceneCam.getLocation());
        WaterUtils.updateReflectionCam(this.reflectionCam, this.plane, sceneCam);
        if (sceneCam.getLocation().y >= this.waterHeight) {
            boolean rtb = true;
            if (!this.renderManager.isHandleTranslucentBucket()) {
                this.renderManager.setHandleTranslucentBucket(true);
                rtb = false;
            }
            this.renderManager.renderViewPort(this.reflectionView, tpf);
            if (!rtb) {
                this.renderManager.setHandleTranslucentBucket(false);
            }
            this.renderManager.setCamera(sceneCam, false);
            this.renderManager.getRenderer().setFrameBuffer(this.viewPort.getOutputFrameBuffer());
            this.underWater = false;
        } else {
            this.underWater = true;
        }
    }

    protected Material getMaterial() {
        return this.material;
    }

    private DirectionalLight findLight(Node node) {
        for (Light light : node.getWorldLightList()) {
            if (!(light instanceof DirectionalLight)) continue;
            return (DirectionalLight)light;
        }
        for (Spatial child : node.getChildren()) {
            if (!(child instanceof Node)) continue;
            return this.findLight((Node)child);
        }
        return null;
    }

    protected boolean useDirectionLightFromScene() {
        return true;
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.rootScene = (Spatial)vp.getScenes().get(0);
        if (this.reflectionScene == null) {
            this.reflectionScene = this.rootScene;
            DirectionalLight directionalLight = this.findLight((Node)this.reflectionScene);
            if (directionalLight != null && this.useDirectionLightFromScene()) {
                this.lightDirection = directionalLight.getDirection();
            }
        }
        this.renderManager = renderManager;
        this.viewPort = vp;
        this.reflectionPass = new Filter.Pass((Filter)this);
        this.reflectionPass.init(renderManager.getRenderer(), this.reflectionMapSize, this.reflectionMapSize, Image.Format.RGBA8, Image.Format.Depth);
        this.reflectionCam = new Camera(this.reflectionMapSize, this.reflectionMapSize);
        this.reflectionView = new ViewPort("reflectionView", this.reflectionCam);
        this.reflectionView.setClearFlags(true, true, true);
        this.reflectionView.attachScene(this.reflectionScene);
        this.reflectionView.setOutputFrameBuffer(this.reflectionPass.getRenderFrameBuffer());
        this.plane = new Plane(Vector3f.UNIT_Y, new Vector3f(0.0f, this.waterHeight, 0.0f).dot(Vector3f.UNIT_Y));
        this.reflectionProcessor = new ReflectionProcessor(this.reflectionCam, this.reflectionPass.getRenderFrameBuffer(), this.plane);
        this.reflectionProcessor.setReflectionClipPlane(this.plane);
        this.reflectionView.addProcessor((SceneProcessor)this.reflectionProcessor);
        if (this.normalTexture == null) {
            this.normalTexture = (Texture2D)manager.loadTexture(DEFAULT_NORMAL_MAP);
            this.normalTexture.setWrap(Texture.WrapMode.Repeat);
        }
        if (this.foamTexture == null) {
            this.foamTexture = (Texture2D)manager.loadTexture(DEFAULT_FOAM);
            this.foamTexture.setWrap(Texture.WrapMode.Repeat);
        }
        if (this.causticsTexture == null) {
            this.causticsTexture = (Texture2D)manager.loadTexture(DEFAULT_CAUSTICS);
            this.causticsTexture.setWrap(Texture.WrapMode.Repeat);
        }
        if (this.heightTexture == null) {
            this.heightTexture = (Texture2D)manager.loadTexture(DEFAULT_HEIGHT_MAP);
            this.heightTexture.setWrap(Texture.WrapMode.Repeat);
        }
        this.material = new Material(manager, "Common/MatDefs/Water/Water.j3md");
        this.material.setTexture("HeightMap", (Texture)this.heightTexture);
        this.material.setTexture("CausticsMap", (Texture)this.causticsTexture);
        this.material.setTexture("FoamMap", (Texture)this.foamTexture);
        this.material.setTexture("NormalMap", (Texture)this.normalTexture);
        this.material.setTexture("ReflectionMap", (Texture)this.reflectionPass.getRenderedTexture());
        this.material.setFloat("WaterTransparency", this.waterTransparency);
        this.material.setFloat("NormalScale", this.normalScale);
        this.material.setFloat("R0", this.refractionConstant);
        this.material.setFloat("MaxAmplitude", this.maxAmplitude);
        this.material.setVector3("LightDir", this.lightDirection);
        this.material.setColor("LightColor", this.lightColor);
        this.material.setFloat("ShoreHardness", this.shoreHardness);
        this.material.setFloat("RefractionStrength", this.refractionStrength);
        this.material.setFloat("WaveScale", this.waveScale);
        this.material.setVector3("FoamExistence", this.foamExistence);
        this.material.setFloat("SunScale", this.sunScale);
        this.material.setVector3("ColorExtinction", this.colorExtinction);
        this.material.setFloat("Shininess", this.shininess);
        this.material.setColor("WaterColor", this.waterColor);
        this.material.setColor("DeepWaterColor", this.deepWaterColor);
        this.material.setVector2("WindDirection", this.windDirection);
        this.material.setFloat("FoamHardness", this.foamHardness);
        this.material.setBoolean("UseRipples", this.useRipples);
        this.material.setBoolean("UseHQShoreline", this.useHQShoreline);
        this.material.setBoolean("UseSpecular", this.useSpecular);
        this.material.setBoolean("UseFoam", this.useFoam);
        this.material.setBoolean("UseCaustics", this.useCaustics);
        this.material.setBoolean("UseRefraction", this.useRefraction);
        this.material.setFloat("ReflectionDisplace", this.reflectionDisplace);
        this.material.setFloat("FoamIntensity", this.foamIntensity);
        this.material.setFloat("UnderWaterFogDistance", this.underWaterFogDistance);
        this.material.setFloat("CausticsIntensity", this.causticsIntensity);
        if (this.center != null) {
            this.material.setVector3("Center", this.center);
            this.material.setFloat("Radius", this.radius * this.radius);
            this.material.setBoolean("SquareArea", this.shapeType == AreaShape.Square);
        }
        this.material.setFloat("WaterHeight", this.waterHeight);
    }

    protected void cleanUpFilter(Renderer r) {
        this.reflectionPass.cleanup(r);
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        Spatial reflectionScene = this.getReflectionScene();
        boolean needSaveReflectionScene = this.isNeedSaveReflectionScene();
        AssetKey causticsTextureKey = this.causticsTexture.getKey();
        AssetKey heightTextureKey = this.heightTexture.getKey();
        AssetKey normalTextureKey = this.normalTexture.getKey();
        AssetKey foamTextureKey = this.foamTexture.getKey();
        if (causticsTextureKey != null && !DEFAULT_CAUSTICS.equals(causticsTextureKey.getName())) {
            oc.write((Savable)causticsTextureKey, "causticsTexture", null);
        }
        if (heightTextureKey != null && !DEFAULT_HEIGHT_MAP.equals(heightTextureKey.getName())) {
            oc.write((Savable)heightTextureKey, "heightTexture", null);
        }
        if (normalTextureKey != null && !DEFAULT_NORMAL_MAP.equals(normalTextureKey.getName())) {
            oc.write((Savable)normalTextureKey, "normalTexture", null);
        }
        if (foamTextureKey != null && !DEFAULT_FOAM.equals(foamTextureKey.getName())) {
            oc.write((Savable)foamTextureKey, "foamTexture", null);
        }
        oc.write(needSaveReflectionScene, "needSaveReflectionScene", false);
        if (needSaveReflectionScene) {
            oc.write((Savable)reflectionScene, "reflectionScene", null);
        }
        oc.write(this.speed, "speed", 1.0f);
        oc.write((Savable)this.lightDirection, "lightDirection", (Savable)new Vector3f(0.0f, -1.0f, 0.0f));
        oc.write((Savable)this.lightColor, "lightColor", (Savable)ColorRGBA.White);
        oc.write(this.waterHeight, "waterHeight", 0.0f);
        oc.write((Savable)this.waterColor, "waterColor", (Savable)new ColorRGBA(0.0078f, 0.3176f, 0.5f, 1.0f));
        oc.write((Savable)this.deepWaterColor, "deepWaterColor", (Savable)new ColorRGBA(0.0039f, 0.00196f, 0.145f, 1.0f));
        oc.write((Savable)this.colorExtinction, "colorExtinction", (Savable)new Vector3f(5.0f, 20.0f, 30.0f));
        oc.write(this.waterTransparency, "waterTransparency", 0.1f);
        oc.write(this.maxAmplitude, "maxAmplitude", 1.5f);
        oc.write(this.shoreHardness, "shoreHardness", 0.1f);
        oc.write(this.useFoam, "useFoam", true);
        oc.write(this.foamIntensity, "foamIntensity", 0.5f);
        oc.write(this.foamHardness, "foamHardness", 1.0f);
        oc.write((Savable)this.foamExistence, "foamExistence", (Savable)new Vector3f(0.45f, 4.35f, 1.5f));
        oc.write(this.waveScale, "waveScale", 0.005f);
        oc.write(this.sunScale, "sunScale", 3.0f);
        oc.write(this.shininess, "shininess", 0.7f);
        oc.write((Savable)this.windDirection, "windDirection", (Savable)new Vector2f(0.0f, -1.0f));
        oc.write(this.reflectionMapSize, "reflectionMapSize", 512);
        oc.write(this.useRipples, "useRipples", true);
        oc.write(this.normalScale, "normalScale", 3.0f);
        oc.write(this.useHQShoreline, "useHQShoreline", true);
        oc.write(this.useSpecular, "useSpecular", true);
        oc.write(this.useRefraction, "useRefraction", true);
        oc.write(this.refractionStrength, "refractionStrength", 0.0f);
        oc.write(this.refractionConstant, "refractionConstant", 0.5f);
        oc.write(this.reflectionDisplace, "reflectionDisplace", 30.0f);
        oc.write(this.underWaterFogDistance, "underWaterFogDistance", 120.0f);
        oc.write(this.causticsIntensity, "causticsIntensity", 0.5f);
        oc.write(this.useCaustics, "useCaustics", true);
        oc.write((Savable)this.center, "center", null);
        oc.write(this.radius, "radius", 0.0f);
        oc.write(this.shapeType.ordinal(), "shapeType", AreaShape.Circular.ordinal());
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.speed = ic.readFloat("speed", 1.0f);
        this.lightDirection = (Vector3f)ic.readSavable("lightDirection", (Savable)new Vector3f(0.0f, -1.0f, 0.0f));
        this.lightColor = (ColorRGBA)ic.readSavable("lightColor", (Savable)ColorRGBA.White);
        this.waterHeight = ic.readFloat("waterHeight", 0.0f);
        this.waterColor = (ColorRGBA)ic.readSavable("waterColor", (Savable)new ColorRGBA(0.0078f, 0.3176f, 0.5f, 1.0f));
        this.deepWaterColor = (ColorRGBA)ic.readSavable("deepWaterColor", (Savable)new ColorRGBA(0.0039f, 0.00196f, 0.145f, 1.0f));
        this.colorExtinction = (Vector3f)ic.readSavable("colorExtinction", (Savable)new Vector3f(5.0f, 20.0f, 30.0f));
        this.waterTransparency = ic.readFloat("waterTransparency", 0.1f);
        this.maxAmplitude = ic.readFloat("maxAmplitude", 1.5f);
        this.shoreHardness = ic.readFloat("shoreHardness", 0.1f);
        this.useFoam = ic.readBoolean("useFoam", true);
        this.foamIntensity = ic.readFloat("foamIntensity", 0.5f);
        this.foamHardness = ic.readFloat("foamHardness", 1.0f);
        this.foamExistence = (Vector3f)ic.readSavable("foamExistence", (Savable)new Vector3f(0.45f, 4.35f, 1.5f));
        this.waveScale = ic.readFloat("waveScale", 0.005f);
        this.sunScale = ic.readFloat("sunScale", 3.0f);
        this.shininess = ic.readFloat("shininess", 0.7f);
        this.windDirection = (Vector2f)ic.readSavable("windDirection", (Savable)new Vector2f(0.0f, -1.0f));
        this.reflectionMapSize = ic.readInt("reflectionMapSize", 512);
        this.useRipples = ic.readBoolean("useRipples", true);
        this.normalScale = ic.readFloat("normalScale", 3.0f);
        this.useHQShoreline = ic.readBoolean("useHQShoreline", true);
        this.useSpecular = ic.readBoolean("useSpecular", true);
        this.useRefraction = ic.readBoolean("useRefraction", true);
        this.refractionStrength = ic.readFloat("refractionStrength", 0.0f);
        this.refractionConstant = ic.readFloat("refractionConstant", 0.5f);
        this.reflectionDisplace = ic.readFloat("reflectionDisplace", 30.0f);
        this.underWaterFogDistance = ic.readFloat("underWaterFogDistance", 120.0f);
        this.causticsIntensity = ic.readFloat("causticsIntensity", 0.5f);
        this.useCaustics = ic.readBoolean("useCaustics", true);
        TextureKey causticsTextureKey = (TextureKey)ic.readSavable("causticsTexture", null);
        TextureKey heightTextureKey = (TextureKey)ic.readSavable("heightTexture", null);
        TextureKey normalTextureKey = (TextureKey)ic.readSavable("normalTexture", null);
        TextureKey foamTextureKey = (TextureKey)ic.readSavable("foamTexture", null);
        this.needSaveReflectionScene = ic.readBoolean("needSaveReflectionScene", false);
        this.reflectionScene = (Spatial)ic.readSavable("reflectionScene", null);
        AssetManager assetManager = im.getAssetManager();
        if (causticsTextureKey != null) {
            this.setCausticsTexture((Texture2D)assetManager.loadTexture(causticsTextureKey));
        }
        if (heightTextureKey != null) {
            this.setHeightTexture((Texture2D)assetManager.loadTexture(heightTextureKey));
        }
        if (normalTextureKey != null) {
            this.setNormalTexture((Texture2D)assetManager.loadTexture(normalTextureKey));
        }
        if (foamTextureKey != null) {
            this.setFoamTexture((Texture2D)assetManager.loadTexture(foamTextureKey));
        }
        this.center = (Vector3f)ic.readSavable("center", null);
        this.radius = ic.readFloat("radius", 0.0f);
        int shapeType = ic.readInt("shapeType", AreaShape.Circular.ordinal());
        this.shapeType = AreaShape.values()[shapeType];
    }

    public float getWaterHeight() {
        return this.waterHeight;
    }

    public void setWaterHeight(float waterHeight) {
        this.waterHeight = waterHeight;
        this.plane = new Plane(Vector3f.UNIT_Y, waterHeight);
        if (this.material != null) {
            this.material.setFloat("WaterHeight", waterHeight);
        }
        if (this.reflectionProcessor != null) {
            this.reflectionProcessor.setReflectionClipPlane(this.plane);
        }
    }

    public void setReflectionScene(Spatial reflectionScene) {
        Spatial currentScene = this.getReflectionScene();
        if (this.reflectionView != null) {
            this.reflectionView.detachScene(currentScene == null ? this.rootScene : currentScene);
        }
        this.reflectionScene = reflectionScene;
        if (this.reflectionView != null) {
            this.reflectionView.attachScene(reflectionScene == null ? this.rootScene : reflectionScene);
        }
    }

    public Spatial getReflectionScene() {
        return this.reflectionScene;
    }

    public ViewPort getReflectionView() {
        return this.reflectionView;
    }

    public float getWaterTransparency() {
        return this.waterTransparency;
    }

    public void setWaterTransparency(float waterTransparency) {
        this.waterTransparency = waterTransparency;
        if (this.material != null) {
            this.material.setFloat("WaterTransparency", waterTransparency);
        }
    }

    public float getNormalScale() {
        return this.normalScale;
    }

    public void setNormalScale(float normalScale) {
        this.normalScale = normalScale;
        if (this.material != null) {
            this.material.setFloat("NormalScale", normalScale);
        }
    }

    public float getRefractionConstant() {
        return this.refractionConstant;
    }

    public void setRefractionConstant(float refractionConstant) {
        this.refractionConstant = refractionConstant;
        if (this.material != null) {
            this.material.setFloat("R0", refractionConstant);
        }
    }

    public float getMaxAmplitude() {
        return this.maxAmplitude;
    }

    public void setMaxAmplitude(float maxAmplitude) {
        this.maxAmplitude = maxAmplitude;
        if (this.material != null) {
            this.material.setFloat("MaxAmplitude", maxAmplitude);
        }
    }

    public Vector3f getLightDirection() {
        return this.lightDirection;
    }

    public void setLightDirection(Vector3f lightDirection) {
        this.lightDirection = lightDirection;
        if (this.material != null) {
            this.material.setVector3("LightDir", lightDirection);
        }
    }

    public ColorRGBA getLightColor() {
        return this.lightColor;
    }

    public void setLightColor(ColorRGBA lightColor) {
        this.lightColor = lightColor;
        if (this.material != null) {
            this.material.setColor("LightColor", lightColor);
        }
    }

    public float getShoreHardness() {
        return this.shoreHardness;
    }

    public void setShoreHardness(float shoreHardness) {
        this.shoreHardness = shoreHardness;
        if (this.material != null) {
            this.material.setFloat("ShoreHardness", shoreHardness);
        }
    }

    public float getFoamHardness() {
        return this.foamHardness;
    }

    public void setFoamHardness(float foamHardness) {
        this.foamHardness = foamHardness;
        if (this.material != null) {
            this.material.setFloat("FoamHardness", foamHardness);
        }
    }

    public float getRefractionStrength() {
        return this.refractionStrength;
    }

    public void setRefractionStrength(float refractionStrength) {
        this.refractionStrength = refractionStrength;
        if (this.material != null) {
            this.material.setFloat("RefractionStrength", refractionStrength);
        }
    }

    public float getWaveScale() {
        return this.waveScale;
    }

    public void setWaveScale(float waveScale) {
        this.waveScale = waveScale;
        if (this.material != null) {
            this.material.setFloat("WaveScale", waveScale);
        }
    }

    public Vector3f getFoamExistence() {
        return this.foamExistence;
    }

    public void setFoamExistence(Vector3f foamExistence) {
        this.foamExistence = foamExistence;
        if (this.material != null) {
            this.material.setVector3("FoamExistence", foamExistence);
        }
    }

    public float getSunScale() {
        return this.sunScale;
    }

    public void setSunScale(float sunScale) {
        this.sunScale = sunScale;
        if (this.material != null) {
            this.material.setFloat("SunScale", sunScale);
        }
    }

    public Vector3f getColorExtinction() {
        return this.colorExtinction;
    }

    public void setColorExtinction(Vector3f colorExtinction) {
        this.colorExtinction = colorExtinction;
        if (this.material != null) {
            this.material.setVector3("ColorExtinction", colorExtinction);
        }
    }

    public void setFoamTexture(Texture2D foamTexture) {
        this.foamTexture = foamTexture;
        foamTexture.setWrap(Texture.WrapMode.Repeat);
        if (this.material != null) {
            this.material.setTexture("FoamMap", (Texture)foamTexture);
        }
    }

    public Texture2D getFoamTexture() {
        return this.foamTexture;
    }

    public void setHeightTexture(Texture2D heightTexture) {
        this.heightTexture = heightTexture;
        heightTexture.setWrap(Texture.WrapMode.Repeat);
        if (this.material != null) {
            this.material.setTexture("HeightMap", (Texture)heightTexture);
        }
    }

    public Texture2D getHeightTexture() {
        return this.heightTexture;
    }

    public void setNormalTexture(Texture2D normalTexture) {
        this.normalTexture = normalTexture;
        normalTexture.setWrap(Texture.WrapMode.Repeat);
        if (this.material != null) {
            this.material.setTexture("NormalMap", (Texture)normalTexture);
        }
    }

    public Texture2D getNormalTexture() {
        return this.normalTexture;
    }

    public float getShininess() {
        return this.shininess;
    }

    public void setShininess(float shininess) {
        this.shininess = shininess;
        if (this.material != null) {
            this.material.setFloat("Shininess", shininess);
        }
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public ColorRGBA getWaterColor() {
        return this.waterColor;
    }

    public void setWaterColor(ColorRGBA waterColor) {
        this.waterColor = waterColor;
        if (this.material != null) {
            this.material.setColor("WaterColor", waterColor);
        }
    }

    public ColorRGBA getDeepWaterColor() {
        return this.deepWaterColor;
    }

    public void setDeepWaterColor(ColorRGBA deepWaterColor) {
        this.deepWaterColor = deepWaterColor;
        if (this.material != null) {
            this.material.setColor("DeepWaterColor", deepWaterColor);
        }
    }

    public Vector2f getWindDirection() {
        return this.windDirection;
    }

    public void setWindDirection(Vector2f windDirection) {
        this.windDirection = windDirection;
        if (this.material != null) {
            this.material.setVector2("WindDirection", windDirection);
        }
    }

    public int getReflectionMapSize() {
        return this.reflectionMapSize;
    }

    public void setReflectionMapSize(int reflectionMapSize) {
        this.reflectionMapSize = reflectionMapSize;
        if (this.reflectionPass != null) {
            this.reflectionPass.init(this.renderManager.getRenderer(), reflectionMapSize, reflectionMapSize, Image.Format.RGBA8, Image.Format.Depth);
            this.reflectionCam.resize(reflectionMapSize, reflectionMapSize, true);
            this.reflectionProcessor.setReflectionBuffer(this.reflectionPass.getRenderFrameBuffer());
            this.material.setTexture("ReflectionMap", (Texture)this.reflectionPass.getRenderedTexture());
        }
    }

    public boolean isUseFoam() {
        return this.useFoam;
    }

    public void setUseFoam(boolean useFoam) {
        this.useFoam = useFoam;
        if (this.material != null) {
            this.material.setBoolean("UseFoam", useFoam);
        }
    }

    public void setCausticsTexture(Texture2D causticsTexture) {
        this.causticsTexture = causticsTexture;
        if (this.material != null) {
            this.material.setTexture("CausticsMap", (Texture)causticsTexture);
        }
    }

    public Texture2D getCausticsTexture() {
        return this.causticsTexture;
    }

    public boolean isUseCaustics() {
        return this.useCaustics;
    }

    public void setUseCaustics(boolean useCaustics) {
        this.useCaustics = useCaustics;
        if (this.material != null) {
            this.material.setBoolean("UseCaustics", useCaustics);
        }
    }

    public boolean isUseHQShoreline() {
        return this.useHQShoreline;
    }

    public void setUseHQShoreline(boolean useHQShoreline) {
        this.useHQShoreline = useHQShoreline;
        if (this.material != null) {
            this.material.setBoolean("UseHQShoreline", useHQShoreline);
        }
    }

    public boolean isUseRefraction() {
        return this.useRefraction;
    }

    public void setUseRefraction(boolean useRefraction) {
        this.useRefraction = useRefraction;
        if (this.material != null) {
            this.material.setBoolean("UseRefraction", useRefraction);
        }
    }

    public boolean isUseRipples() {
        return this.useRipples;
    }

    public void setUseRipples(boolean useRipples) {
        this.useRipples = useRipples;
        if (this.material != null) {
            this.material.setBoolean("UseRipples", useRipples);
        }
    }

    public boolean isUseSpecular() {
        return this.useSpecular;
    }

    public void setUseSpecular(boolean useSpecular) {
        this.useSpecular = useSpecular;
        if (this.material != null) {
            this.material.setBoolean("UseSpecular", useSpecular);
        }
    }

    public float getFoamIntensity() {
        return this.foamIntensity;
    }

    public void setFoamIntensity(float foamIntensity) {
        this.foamIntensity = foamIntensity;
        if (this.material != null) {
            this.material.setFloat("FoamIntensity", foamIntensity);
        }
    }

    public float getReflectionDisplace() {
        return this.reflectionDisplace;
    }

    public void setReflectionDisplace(float reflectionDisplace) {
        this.reflectionDisplace = reflectionDisplace;
        if (this.material != null) {
            this.material.setFloat("ReflectionDisplace", reflectionDisplace);
        }
    }

    public boolean isUnderWater() {
        return this.underWater;
    }

    public float getUnderWaterFogDistance() {
        return this.underWaterFogDistance;
    }

    public void setUnderWaterFogDistance(float underWaterFogDistance) {
        this.underWaterFogDistance = underWaterFogDistance;
        if (this.material != null) {
            this.material.setFloat("UnderWaterFogDistance", underWaterFogDistance);
        }
    }

    public float getCausticsIntensity() {
        return this.causticsIntensity;
    }

    public void setCausticsIntensity(float causticsIntensity) {
        this.causticsIntensity = causticsIntensity;
        if (this.material != null) {
            this.material.setFloat("CausticsIntensity", causticsIntensity);
        }
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public void setCenter(Vector3f center) {
        this.center = center;
        if (this.material != null) {
            this.material.setVector3("Center", center);
        }
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        if (this.material != null) {
            this.material.setFloat("Radius", radius * radius);
        }
    }

    public AreaShape getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(AreaShape shapeType) {
        this.shapeType = shapeType;
        if (this.material != null) {
            this.material.setBoolean("SquareArea", shapeType == AreaShape.Square);
        }
    }

    public Object jmeClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.normalTexture = (Texture2D)cloner.clone((Object)this.normalTexture);
        this.foamTexture = (Texture2D)cloner.clone((Object)this.foamTexture);
        this.causticsTexture = (Texture2D)cloner.clone((Object)this.causticsTexture);
        this.heightTexture = (Texture2D)cloner.clone((Object)this.heightTexture);
        this.targetLocation = (Vector3f)cloner.clone((Object)this.targetLocation);
        this.biasMatrix = (Matrix4f)cloner.clone((Object)this.biasMatrix);
        this.textureProjMatrix = (Matrix4f)cloner.clone((Object)this.textureProjMatrix);
        this.lightDirection = (Vector3f)cloner.clone((Object)this.lightDirection);
        this.lightColor = (ColorRGBA)cloner.clone((Object)this.lightColor);
        this.waterColor = (ColorRGBA)cloner.clone((Object)this.waterColor);
        this.deepWaterColor = (ColorRGBA)cloner.clone((Object)this.deepWaterColor);
        this.colorExtinction = (Vector3f)cloner.clone((Object)this.colorExtinction);
        this.foamExistence = (Vector3f)cloner.clone((Object)this.foamExistence);
        this.windDirection = (Vector2f)cloner.clone((Object)this.windDirection);
    }

    public void setNeedSaveReflectionScene(boolean needSaveReflectionScene) {
        this.needSaveReflectionScene = needSaveReflectionScene;
    }

    public boolean isNeedSaveReflectionScene() {
        return this.needSaveReflectionScene;
    }

    public static enum AreaShape {
        Circular,
        Square;

    }
}

