/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.ios;

import com.jme3.renderer.RendererException;
import com.jme3.renderer.ios.JmeIosGLES;
import com.jme3.renderer.opengl.GL;
import com.jme3.renderer.opengl.GL2;
import com.jme3.renderer.opengl.GLES_30;
import com.jme3.renderer.opengl.GLExt;
import com.jme3.renderer.opengl.GLFbo;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class IosGL
implements GL,
GL2,
GLES_30,
GLExt,
GLFbo {
    private final float[] tmpFloatArray = new float[16];
    private final int[] temp_array = new int[16];
    private final IntBuffer tmpBuff = BufferUtils.createIntBuffer((int)1);

    public void resetStats() {
    }

    private static int getLimitBytes(ByteBuffer buffer) {
        IosGL.checkLimit(buffer);
        return buffer.limit();
    }

    private static int getLimitBytes(ShortBuffer buffer) {
        IosGL.checkLimit(buffer);
        return buffer.limit() * 2;
    }

    private static int getLimitBytes(IntBuffer buffer) {
        IosGL.checkLimit(buffer);
        return buffer.limit() * 4;
    }

    private static int getLimitBytes(FloatBuffer buffer) {
        IosGL.checkLimit(buffer);
        return buffer.limit() * 4;
    }

    private static int getLimitCount(Buffer buffer, int elementSize) {
        IosGL.checkLimit(buffer);
        return buffer.limit() / elementSize;
    }

    public void glBlendEquationSeparate(int colorMode, int alphaMode) {
        JmeIosGLES.glBlendEquationSeparate(colorMode, alphaMode);
    }

    private int toArray(IntBuffer buffer) {
        int remain = buffer.remaining();
        if (buffer.remaining() > 16) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int pos = buffer.position();
        buffer.get(this.temp_array, 0, remain);
        buffer.position(pos);
        return remain;
    }

    private void fromArray(int n, float[] array, FloatBuffer buffer) {
        if (buffer.remaining() < n) {
            throw new BufferOverflowException();
        }
        int pos = buffer.position();
        buffer.put(array, 0, n);
        buffer.position(pos);
    }

    private void fromArray(int n, int[] array, IntBuffer buffer) {
        if (buffer.remaining() < n) {
            throw new BufferOverflowException();
        }
        int pos = buffer.position();
        buffer.put(array, 0, n);
        buffer.position(pos);
    }

    private static void checkLimit(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer.limit() == 0) {
            throw new RendererException("Attempting to upload empty buffer (limit = 0), that's an error");
        }
        if (buffer.remaining() == 0) {
            throw new RendererException("Attempting to upload empty buffer (remaining = 0), that's an error");
        }
    }

    public void glActiveTexture(int texture) {
        JmeIosGLES.glActiveTexture(texture);
    }

    public void glAttachShader(int program, int shader) {
        JmeIosGLES.glAttachShader(program, shader);
    }

    public void glBeginQuery(int target, int query) {
        JmeIosGLES.glBeginQuery(target, query);
    }

    public void glBindBuffer(int target, int buffer) {
        JmeIosGLES.glBindBuffer(target, buffer);
    }

    public void glBindTexture(int target, int texture) {
        JmeIosGLES.glBindTexture(target, texture);
    }

    public void glBlendFunc(int sFactor, int dFactor) {
        JmeIosGLES.glBlendFunc(sFactor, dFactor);
    }

    public void glBlendFuncSeparate(int sFactorRGB, int dFactorRGB, int sFactorAlpha, int dFactorAlpha) {
        JmeIosGLES.glBlendFuncSeparate(sFactorRGB, dFactorRGB, sFactorAlpha, dFactorAlpha);
    }

    public void glBufferData(int target, FloatBuffer data, int usage) {
        JmeIosGLES.glBufferData(target, IosGL.getLimitBytes(data), data, usage);
    }

    public void glBufferData(int target, ShortBuffer data, int usage) {
        JmeIosGLES.glBufferData(target, IosGL.getLimitBytes(data), data, usage);
    }

    public void glBufferData(int target, ByteBuffer data, int usage) {
        JmeIosGLES.glBufferData(target, IosGL.getLimitBytes(data), data, usage);
    }

    public void glBufferData(int target, long data_size, int usage) {
        JmeIosGLES.glBufferData(target, (int)data_size, null, usage);
    }

    public void glBufferSubData(int target, long offset, FloatBuffer data) {
        JmeIosGLES.glBufferSubData(target, (int)offset, IosGL.getLimitBytes(data), data);
    }

    public void glBufferSubData(int target, long offset, ShortBuffer data) {
        JmeIosGLES.glBufferSubData(target, (int)offset, IosGL.getLimitBytes(data), data);
    }

    public void glBufferSubData(int target, long offset, ByteBuffer data) {
        JmeIosGLES.glBufferSubData(target, (int)offset, IosGL.getLimitBytes(data), data);
    }

    public void glGetBufferSubData(int target, long offset, ByteBuffer data) {
        throw new UnsupportedOperationException("OpenGL ES 2 does not support glGetBufferSubData");
    }

    public void glClear(int mask) {
        JmeIosGLES.glClear(mask);
    }

    public void glClearColor(float red, float green, float blue, float alpha) {
        JmeIosGLES.glClearColor(red, green, blue, alpha);
    }

    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        JmeIosGLES.glColorMask(red, green, blue, alpha);
    }

    public void glCompileShader(int shader) {
        JmeIosGLES.glCompileShader(shader);
    }

    public void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, ByteBuffer data) {
        JmeIosGLES.glCompressedTexImage2D(target, level, internalformat, width, height, 0, IosGL.getLimitBytes(data), data);
    }

    public void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        JmeIosGLES.glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, IosGL.getLimitBytes(data), data);
    }

    public int glCreateProgram() {
        return JmeIosGLES.glCreateProgram();
    }

    public int glCreateShader(int shaderType) {
        return JmeIosGLES.glCreateShader(shaderType);
    }

    public void glCullFace(int mode) {
        JmeIosGLES.glCullFace(mode);
    }

    public void glDeleteBuffers(IntBuffer buffers) {
        IosGL.checkLimit(buffers);
        int n = this.toArray(buffers);
        JmeIosGLES.glDeleteBuffers(n, this.temp_array, 0);
    }

    public void glDeleteProgram(int program) {
        JmeIosGLES.glDeleteProgram(program);
    }

    public void glDeleteShader(int shader) {
        JmeIosGLES.glDeleteShader(shader);
    }

    public void glDeleteTextures(IntBuffer textures) {
        IosGL.checkLimit(textures);
        int n = this.toArray(textures);
        JmeIosGLES.glDeleteTextures(n, this.temp_array, 0);
    }

    public void glDepthFunc(int func) {
        JmeIosGLES.glDepthFunc(func);
    }

    public void glDepthMask(boolean flag) {
        JmeIosGLES.glDepthMask(flag);
    }

    public void glDepthRange(double nearVal, double farVal) {
        JmeIosGLES.glDepthRangef((float)nearVal, (float)farVal);
    }

    public void glDetachShader(int program, int shader) {
        JmeIosGLES.glDetachShader(program, shader);
    }

    public void glDisable(int cap) {
        JmeIosGLES.glDisable(cap);
    }

    public void glDisableVertexAttribArray(int index) {
        JmeIosGLES.glDisableVertexAttribArray(index);
    }

    public void glDrawArrays(int mode, int first, int count) {
        JmeIosGLES.glDrawArrays(mode, first, count);
    }

    public void glDrawRangeElements(int mode, int start, int end, int count, int type, long indices) {
        JmeIosGLES.glDrawElementsIndex(mode, count, type, (int)indices);
    }

    public void glEnable(int cap) {
        JmeIosGLES.glEnable(cap);
    }

    public void glEnableVertexAttribArray(int index) {
        JmeIosGLES.glEnableVertexAttribArray(index);
    }

    public void glEndQuery(int target) {
        JmeIosGLES.glEndQuery(target);
    }

    public void glGenBuffers(IntBuffer buffers) {
        IosGL.checkLimit(buffers);
        JmeIosGLES.glGenBuffers(buffers.remaining(), this.temp_array, 0);
        this.fromArray(buffers.remaining(), this.temp_array, buffers);
    }

    public void glGenTextures(IntBuffer textures) {
        IosGL.checkLimit(textures);
        JmeIosGLES.glGenTextures(textures.remaining(), this.temp_array, 0);
        this.fromArray(textures.remaining(), this.temp_array, textures);
    }

    public void glGenQueries(int num, IntBuffer buff) {
        JmeIosGLES.glGenQueries(num, buff);
    }

    public int glGetAttribLocation(int program, String name) {
        return JmeIosGLES.glGetAttribLocation(program, name);
    }

    public void glGetBoolean(int pname, ByteBuffer params) {
        JmeIosGLES.glGetBoolean(pname, params);
    }

    public int glGetError() {
        return JmeIosGLES.glGetError();
    }

    public void glGetFloat(int parameterId, FloatBuffer storeValues) {
        IosGL.checkLimit(storeValues);
        JmeIosGLES.glGetFloatv(parameterId, this.tmpFloatArray, 0);
        this.fromArray(storeValues.remaining(), this.tmpFloatArray, storeValues);
    }

    public void glGetInteger(int pname, IntBuffer params) {
        IosGL.checkLimit(params);
        JmeIosGLES.glGetIntegerv(pname, this.temp_array, 0);
        this.fromArray(params.remaining(), this.temp_array, params);
    }

    public void glGetProgram(int program, int pname, IntBuffer params) {
        IosGL.checkLimit(params);
        JmeIosGLES.glGetProgramiv(program, pname, this.temp_array, 0);
        this.fromArray(params.remaining(), this.temp_array, params);
    }

    public String glGetProgramInfoLog(int program, int maxLength) {
        return JmeIosGLES.glGetProgramInfoLog(program);
    }

    public long glGetQueryObjectui64(int query, int pname) {
        JmeIosGLES.glGetQueryObjectuiv(query, pname, this.temp_array);
        return this.temp_array[0];
    }

    public int glGetQueryObjectiv(int query, int pname) {
        JmeIosGLES.glGetQueryiv(query, pname, this.temp_array);
        return this.temp_array[0];
    }

    public void glGetShader(int shader, int pname, IntBuffer params) {
        IosGL.checkLimit(params);
        JmeIosGLES.glGetShaderiv(shader, pname, this.temp_array, 0);
        this.fromArray(params.remaining(), this.temp_array, params);
    }

    public String glGetShaderInfoLog(int shader, int maxLength) {
        return JmeIosGLES.glGetShaderInfoLog(shader);
    }

    public String glGetString(int name) {
        return JmeIosGLES.glGetString(name);
    }

    public int glGetUniformLocation(int program, String name) {
        return JmeIosGLES.glGetUniformLocation(program, name);
    }

    public boolean glIsEnabled(int cap) {
        if (cap == 32925) {
            return true;
        }
        return JmeIosGLES.glIsEnabled(cap);
    }

    public void glLineWidth(float width) {
        JmeIosGLES.glLineWidth(width);
    }

    public void glLinkProgram(int program) {
        JmeIosGLES.glLinkProgram(program);
    }

    public void glPixelStorei(int pname, int param) {
        JmeIosGLES.glPixelStorei(pname, param);
    }

    public void glPolygonOffset(float factor, float units) {
        JmeIosGLES.glPolygonOffset(factor, units);
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, ByteBuffer data) {
        JmeIosGLES.glReadPixels(x, y, width, height, format, type, data);
    }

    public void glScissor(int x, int y, int width, int height) {
        JmeIosGLES.glScissor(x, y, width, height);
    }

    public void glShaderSource(int shader, String[] string, IntBuffer length) {
        if (string.length != 1) {
            throw new UnsupportedOperationException("Today is not a good day");
        }
        JmeIosGLES.glShaderSource(shader, string[0]);
    }

    public void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        JmeIosGLES.glStencilFuncSeparate(face, func, ref, mask);
    }

    public void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        JmeIosGLES.glStencilOpSeparate(face, sfail, dpfail, dppass);
    }

    public void glTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, ByteBuffer data) {
        JmeIosGLES.glTexImage2D(target, level, internalFormat, width, height, 0, format, type, data);
    }

    public void glTexParameterf(int target, int pname, float param) {
        JmeIosGLES.glTexParameterf(target, pname, param);
    }

    public void glTexParameteri(int target, int pname, int param) {
        JmeIosGLES.glTexParameteri(target, pname, param);
    }

    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer data) {
        JmeIosGLES.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, data);
    }

    public void glUniform1(int location, FloatBuffer value) {
        JmeIosGLES.glUniform1fv(location, IosGL.getLimitCount(value, 1), value);
    }

    public void glUniform1(int location, IntBuffer value) {
        JmeIosGLES.glUniform1iv(location, IosGL.getLimitCount(value, 1), value);
    }

    public void glUniform1f(int location, float v0) {
        JmeIosGLES.glUniform1f(location, v0);
    }

    public void glUniform1i(int location, int v0) {
        JmeIosGLES.glUniform1i(location, v0);
    }

    public void glUniform2(int location, IntBuffer value) {
        throw new UnsupportedOperationException();
    }

    public void glUniform2(int location, FloatBuffer value) {
        JmeIosGLES.glUniform2fv(location, IosGL.getLimitCount(value, 2), value);
    }

    public void glUniform2f(int location, float v0, float v1) {
        JmeIosGLES.glUniform2f(location, v0, v1);
    }

    public void glUniform3(int location, IntBuffer value) {
        throw new UnsupportedOperationException();
    }

    public void glUniform3(int location, FloatBuffer value) {
        JmeIosGLES.glUniform3fv(location, IosGL.getLimitCount(value, 3), value);
    }

    public void glUniform3f(int location, float v0, float v1, float v2) {
        JmeIosGLES.glUniform3f(location, v0, v1, v2);
    }

    public void glUniform4(int location, FloatBuffer value) {
        JmeIosGLES.glUniform4fv(location, IosGL.getLimitCount(value, 4), value);
    }

    public void glUniform4(int location, IntBuffer value) {
        throw new UnsupportedOperationException();
    }

    public void glUniform4f(int location, float v0, float v1, float v2, float v3) {
        JmeIosGLES.glUniform4f(location, v0, v1, v2, v3);
    }

    public void glUniformMatrix3(int location, boolean transpose, FloatBuffer value) {
        JmeIosGLES.glUniformMatrix3fv(location, IosGL.getLimitCount(value, 9), transpose, value);
    }

    public void glUniformMatrix4(int location, boolean transpose, FloatBuffer value) {
        JmeIosGLES.glUniformMatrix4fv(location, IosGL.getLimitCount(value, 16), transpose, value);
    }

    public void glUseProgram(int program) {
        JmeIosGLES.glUseProgram(program);
    }

    public void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        JmeIosGLES.glVertexAttribPointer2(index, size, type, normalized, stride, (int)pointer);
    }

    public void glViewport(int x, int y, int width, int height) {
        JmeIosGLES.glViewport(x, y, width, height);
    }

    public void glBlitFramebufferEXT(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        JmeIosGLES.glBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }

    public void glBufferData(int target, IntBuffer data, int usage) {
        JmeIosGLES.glBufferData(target, IosGL.getLimitBytes(data), data, usage);
    }

    public void glBufferSubData(int target, long offset, IntBuffer data) {
        JmeIosGLES.glBufferSubData(target, (int)offset, IosGL.getLimitBytes(data), data);
    }

    public void glDrawArraysInstancedARB(int mode, int first, int count, int primcount) {
        JmeIosGLES.glDrawArraysInstanced(mode, first, count, primcount);
    }

    public void glDrawBuffers(IntBuffer bufs) {
        JmeIosGLES.glDrawBuffers(IosGL.getLimitBytes(bufs), bufs);
    }

    public void glDrawElementsInstancedARB(int mode, int indices_count, int type, long indices_buffer_offset, int primcount) {
        JmeIosGLES.glDrawElementsInstanced(mode, indices_count, type, indices_buffer_offset, primcount);
    }

    public void glGetMultisample(int pname, int index, FloatBuffer val) {
        throw new UnsupportedOperationException("Multisample renderbuffers not available on iOS");
    }

    public void glRenderbufferStorageMultisampleEXT(int target, int samples, int internalformat, int width, int height) {
        throw new UnsupportedOperationException("Multisample renderbuffers not available on iOS");
    }

    public void glTexImage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedSampleLocations) {
        throw new UnsupportedOperationException("Multisample textures not available on iOS");
    }

    public void glVertexAttribDivisorARB(int index, int divisor) {
        JmeIosGLES.glVertexAttribDivisor(index, divisor);
    }

    public void glBindFramebufferEXT(int param1, int param2) {
        JmeIosGLES.glBindFramebuffer(param1, param2);
    }

    public void glBindRenderbufferEXT(int param1, int param2) {
        JmeIosGLES.glBindRenderbuffer(param1, param2);
    }

    public int glCheckFramebufferStatusEXT(int param1) {
        return JmeIosGLES.glCheckFramebufferStatus(param1);
    }

    public void glDeleteFramebuffersEXT(IntBuffer param1) {
        IosGL.checkLimit(param1);
        int n = this.toArray(param1);
        JmeIosGLES.glDeleteFramebuffers(n, this.temp_array, 0);
    }

    public void glDeleteRenderbuffersEXT(IntBuffer param1) {
        IosGL.checkLimit(param1);
        int n = this.toArray(param1);
        JmeIosGLES.glDeleteRenderbuffers(n, this.temp_array, 0);
    }

    public void glFramebufferRenderbufferEXT(int param1, int param2, int param3, int param4) {
        JmeIosGLES.glFramebufferRenderbuffer(param1, param2, param3, param4);
    }

    public void glFramebufferTexture2DEXT(int param1, int param2, int param3, int param4, int param5) {
        JmeIosGLES.glFramebufferTexture2D(param1, param2, param3, param4, param5);
    }

    public void glGenFramebuffersEXT(IntBuffer param1) {
        IosGL.checkLimit(param1);
        JmeIosGLES.glGenFramebuffers(param1.remaining(), this.temp_array, 0);
        this.fromArray(param1.remaining(), this.temp_array, param1);
    }

    public void glGenRenderbuffersEXT(IntBuffer param1) {
        IosGL.checkLimit(param1);
        JmeIosGLES.glGenRenderbuffers(param1.remaining(), this.temp_array, 0);
        this.fromArray(param1.remaining(), this.temp_array, param1);
    }

    public void glGenerateMipmapEXT(int param1) {
        JmeIosGLES.glGenerateMipmap(param1);
    }

    public void glRenderbufferStorageEXT(int param1, int param2, int param3, int param4) {
        JmeIosGLES.glRenderbufferStorage(param1, param2, param3, param4);
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, long offset) {
        JmeIosGLES.glReadPixels(x, y, width, height, format, type, null);
    }

    public int glClientWaitSync(Object sync, int flags, long timeout) {
        throw new UnsupportedOperationException("OpenGL ES 2 does not support sync fences");
    }

    public void glDeleteSync(Object sync) {
        throw new UnsupportedOperationException("OpenGL ES 2 does not support sync fences");
    }

    public Object glFenceSync(int condition, int flags) {
        throw new UnsupportedOperationException("OpenGL ES 2 does not support sync fences");
    }

    public void glFramebufferTextureLayerEXT(int target, int attachment, int texture, int level, int layer) {
        JmeIosGLES.glFramebufferTextureLayer(target, attachment, texture, level, layer);
    }

    public void glAlphaFunc(int func, float ref) {
    }

    public void glPointSize(float size) {
    }

    public void glPolygonMode(int face, int mode) {
    }

    public void glDrawBuffer(int mode) {
        ((Buffer)this.tmpBuff).clear();
        this.tmpBuff.put(0, mode);
        this.tmpBuff.rewind();
        this.glDrawBuffers(this.tmpBuff);
    }

    public void glReadBuffer(int mode) {
        JmeIosGLES.glReadBuffer(mode);
    }

    public void glCompressedTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, ByteBuffer data) {
        JmeIosGLES.glCompressedTexImage3D(target, level, internalFormat, width, height, depth, border, IosGL.getLimitBytes(data), data);
    }

    public void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        JmeIosGLES.glCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, IosGL.getLimitBytes(data), data);
    }

    public void glTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, ByteBuffer data) {
        JmeIosGLES.glTexImage3D(target, level, internalFormat, width, height, depth, border, format, type, data);
    }

    public void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer data) {
        JmeIosGLES.glTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data);
    }

    public void glBindVertexArray(int array) {
        throw new UnsupportedOperationException("Unimplemented method 'glBindVertexArray'");
    }

    public void glDeleteVertexArrays(IntBuffer arrays) {
        throw new UnsupportedOperationException("Unimplemented method 'glDeleteVertexArrays'");
    }

    public void glGenVertexArrays(IntBuffer arrays) {
        throw new UnsupportedOperationException("Unimplemented method 'glGenVertexArrays'");
    }
}

