/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Joint;
import com.jme3.bullet.animation.DacLinks;
import com.jme3.bullet.animation.KinematicSubmode;
import com.jme3.bullet.animation.PhysicsLink;
import com.jme3.bullet.animation.RagUtils;
import com.jme3.bullet.animation.RangeOfMotion;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;

public class BoneLink
extends PhysicsLink {
    public static final Logger logger2 = Logger.getLogger(BoneLink.class.getName());
    private static final Matrix3f matrixIdentity = new Matrix3f();
    private Joint[] managedBones = null;
    private KinematicSubmode submode = KinematicSubmode.Animated;
    private Transform[] prevBoneTransforms = null;
    private Transform[] startBoneTransforms = null;

    protected BoneLink() {
    }

    BoneLink(DacLinks control, Joint bone, CollisionShape collisionShape, float mass, Vector3f localOffset) {
        super(control, bone, collisionShape, mass, localOffset);
    }

    void addJoint(PhysicsLink parentLink) {
        assert (parentLink != null);
        assert (this.getJoint() == null);
        this.setParent(parentLink);
        Transform parentToWorld = parentLink.physicsTransform(null);
        parentToWorld.setScale(1.0f);
        Transform worldToParent = parentToWorld.invert();
        Transform childToWorld = this.physicsTransform(null);
        childToWorld.setScale(1.0f);
        Transform childToParent = childToWorld.clone();
        childToParent.combineWithParent(worldToParent);
        Spatial transformer = this.getControl().getTransformer();
        Vector3f pivotMesh = this.getBone().getModelTransform().getTranslation();
        Vector3f pivotWorld = transformer.localToWorld(pivotMesh, null);
        PhysicsRigidBody parentBody = parentLink.getRigidBody();
        PhysicsRigidBody childBody = this.getRigidBody();
        Vector3f pivotParent = parentToWorld.transformInverseVector(pivotWorld, null);
        Vector3f pivotChild = childToWorld.transformInverseVector(pivotWorld, null);
        Matrix3f rotParent = childToParent.getRotation().toRotationMatrix();
        Matrix3f rotChild = matrixIdentity;
        SixDofJoint joint = new SixDofJoint(parentBody, childBody, pivotParent, pivotChild, rotParent, rotChild, true);
        super.setJoint(joint);
        String name = this.boneName();
        RangeOfMotion rangeOfMotion = this.getControl().getJointLimits(name);
        rangeOfMotion.setupJoint(joint);
        joint.setCollisionBetweenLinkedBodys(false);
        assert (this.managedBones == null);
        this.managedBones = this.getControl().listManagedBones(name);
        int numManagedBones = this.managedBones.length;
        this.startBoneTransforms = new Transform[numManagedBones];
        for (int i = 0; i < numManagedBones; ++i) {
            this.startBoneTransforms[i] = new Transform();
        }
    }

    public void blendToKinematicMode(KinematicSubmode submode, float blendInterval) {
        super.blendToKinematicMode(blendInterval);
        this.submode = submode;
        int numManagedBones = this.managedBones.length;
        for (int mbIndex = 0; mbIndex < numManagedBones; ++mbIndex) {
            Transform transform;
            if (this.prevBoneTransforms == null) {
                Joint managedBone = this.managedBones[mbIndex];
                transform = managedBone.getLocalTransform().clone();
            } else {
                transform = this.prevBoneTransforms[mbIndex];
            }
            this.startBoneTransforms[mbIndex].set(transform);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.managedBones = (Joint[])cloner.clone((Object)this.managedBones);
        this.prevBoneTransforms = (Transform[])cloner.clone((Object)this.prevBoneTransforms);
        this.startBoneTransforms = (Transform[])cloner.clone((Object)this.startBoneTransforms);
    }

    @Override
    protected void dynamicUpdate() {
        assert (!this.getRigidBody().isKinematic());
        Transform transform = this.localBoneTransform(null);
        this.getBone().setLocalTransform(transform);
        for (Joint managedBone : this.managedBones) {
            managedBone.updateModelTransforms();
        }
    }

    @Override
    public BoneLink jmeClone() {
        try {
            BoneLink clone = (BoneLink)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected void kinematicUpdate(float tpf) {
        assert (tpf >= 0.0f) : tpf;
        assert (this.getRigidBody().isKinematic());
        Transform transform = new Transform();
        for (int mbIndex = 0; mbIndex < this.managedBones.length; ++mbIndex) {
            Joint managedBone = this.managedBones[mbIndex];
            switch (this.submode) {
                case Animated: {
                    transform.set(managedBone.getLocalTransform());
                    break;
                }
                case Frozen: {
                    transform.set(this.prevBoneTransforms[mbIndex]);
                    break;
                }
                default: {
                    throw new IllegalStateException(this.submode.toString());
                }
            }
            if (this.kinematicWeight() < 1.0f) {
                Quaternion endQuat;
                Transform start = this.startBoneTransforms[mbIndex];
                Quaternion startQuat = start.getRotation();
                if (startQuat.dot(endQuat = transform.getRotation()) < 0.0f) {
                    endQuat.multLocal(-1.0f);
                }
                transform.interpolateTransforms(this.startBoneTransforms[mbIndex].clone(), transform, this.kinematicWeight());
            }
            managedBone.setLocalTransform(transform);
            managedBone.updateModelTransforms();
        }
        super.kinematicUpdate(tpf);
    }

    @Override
    public String name() {
        String result = "Bone:" + this.boneName();
        return result;
    }

    void postRebuild(BoneLink oldLink) {
        int i;
        int numManagedBones = this.managedBones.length;
        assert (oldLink.managedBones.length == numManagedBones);
        super.postRebuild(oldLink);
        this.submode = oldLink.isKinematic() ? oldLink.submode : KinematicSubmode.Frozen;
        if (this.prevBoneTransforms == null) {
            this.prevBoneTransforms = new Transform[numManagedBones];
            for (i = 0; i < numManagedBones; ++i) {
                this.prevBoneTransforms[i] = new Transform();
            }
        }
        for (i = 0; i < numManagedBones; ++i) {
            this.prevBoneTransforms[i].set(oldLink.prevBoneTransforms[i]);
            this.startBoneTransforms[i].set(oldLink.startBoneTransforms[i]);
        }
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        Savable[] tmp = ic.readSavableArray("managedBones", null);
        if (tmp == null) {
            this.managedBones = null;
        } else {
            this.managedBones = new Joint[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                this.managedBones[i] = (Joint)tmp[i];
            }
        }
        this.submode = (KinematicSubmode)ic.readEnum("submode", KinematicSubmode.class, (Enum)KinematicSubmode.Animated);
        this.prevBoneTransforms = RagUtils.readTransformArray(ic, "prevBoneTransforms");
        this.startBoneTransforms = RagUtils.readTransformArray(ic, "startBoneTransforms");
    }

    @Override
    public void setDynamic(Vector3f uniformAcceleration) {
        this.getControl().verifyReadyForDynamicMode("put link into dynamic mode");
        super.setDynamic(uniformAcceleration);
        String name = this.boneName();
        RangeOfMotion preset = this.getControl().getJointLimits(name);
        preset.setupJoint((SixDofJoint)this.getJoint());
    }

    @Override
    void update(float tpf) {
        Joint managedBone;
        assert (tpf >= 0.0f) : tpf;
        if (this.prevBoneTransforms == null) {
            int numManagedBones = this.managedBones.length;
            this.prevBoneTransforms = new Transform[numManagedBones];
            for (int mbIndex = 0; mbIndex < numManagedBones; ++mbIndex) {
                Transform boneTransform;
                managedBone = this.managedBones[mbIndex];
                this.prevBoneTransforms[mbIndex] = boneTransform = managedBone.getLocalTransform().clone();
            }
        }
        super.update(tpf);
        for (int mbIndex = 0; mbIndex < this.managedBones.length; ++mbIndex) {
            Transform lastTransform = this.prevBoneTransforms[mbIndex];
            managedBone = this.managedBones[mbIndex];
            lastTransform.set(managedBone.getLocalTransform());
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write((Savable[])this.managedBones, "managedBones", null);
        oc.write((Enum)this.submode, "submode", (Enum)KinematicSubmode.Animated);
        oc.write((Savable[])this.prevBoneTransforms, "prevBoneTransforms", (Savable[])new Transform[0]);
        oc.write((Savable[])this.startBoneTransforms, "startBoneTransforms", (Savable[])new Transform[0]);
    }

    private Transform localBoneTransform(Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        Vector3f location = result.getTranslation();
        Quaternion orientation = result.getRotation();
        Vector3f scale = result.getScale();
        PhysicsRigidBody body = this.getRigidBody();
        body.getPhysicsLocation(result.getTranslation());
        body.getPhysicsRotation(result.getRotation());
        result.setScale(body.getCollisionShape().getScale());
        Transform worldToMesh = this.getControl().meshTransform(null).invert();
        result.combineWithParent(worldToMesh);
        Joint parentBone = this.getBone().getParent();
        RagUtils.meshToLocal(parentBone, result);
        Vector3f parentOffset = this.localOffset(null);
        parentOffset.multLocal(scale);
        orientation.mult(parentOffset, parentOffset);
        location.subtractLocal(parentOffset);
        return result;
    }
}

