/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.bulletphysics.BulletGlobals;
import com.bulletphysics.ContactAddedCallback;
import com.bulletphysics.ContactDestroyedCallback;
import com.bulletphysics.ContactProcessedCallback;
import com.bulletphysics.collision.broadphase.AxisSweep3;
import com.bulletphysics.collision.broadphase.AxisSweep3_32;
import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.BroadphaseProxy;
import com.bulletphysics.collision.broadphase.DbvtBroadphase;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.broadphase.OverlapFilterCallback;
import com.bulletphysics.collision.broadphase.OverlappingPairCallback;
import com.bulletphysics.collision.broadphase.SimpleBroadphase;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.CollisionWorld;
import com.bulletphysics.collision.dispatch.DefaultCollisionConfiguration;
import com.bulletphysics.collision.dispatch.GhostPairCallback;
import com.bulletphysics.collision.dispatch.PairCachingGhostObject;
import com.bulletphysics.collision.narrowphase.ManifoldPoint;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.dynamics.ActionInterface;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.InternalTickCallback;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.ConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.dynamics.vehicle.RaycastVehicle;
import com.bulletphysics.extras.gimpact.GImpactCollisionAlgorithm;
import com.bulletphysics.linearmath.Transform;
import com.jme3.app.AppTask;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionEventFactory;
import com.jme3.bullet.collision.PhysicsCollisionGroupListener;
import com.jme3.bullet.collision.PhysicsCollisionListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.PhysicsRayTestResult;
import com.jme3.bullet.collision.PhysicsSweepTestResult;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.bullet.objects.PhysicsGhostObject;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.bullet.util.Converter;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Matrix3f;

public class PhysicsSpace {
    private static final Logger logger = Logger.getLogger(PhysicsSpace.class.getName());
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_Z = 2;
    private static ThreadLocal<ConcurrentLinkedQueue<AppTask<?>>> pQueueTL = new ThreadLocal<ConcurrentLinkedQueue<AppTask<?>>>(){

        @Override
        protected ConcurrentLinkedQueue<AppTask<?>> initialValue() {
            return new ConcurrentLinkedQueue();
        }
    };
    private ConcurrentLinkedQueue<AppTask<?>> pQueue = new ConcurrentLinkedQueue();
    private static ThreadLocal<PhysicsSpace> physicsSpaceTL = new ThreadLocal();
    private DiscreteDynamicsWorld dynamicsWorld = null;
    private BroadphaseInterface broadphase;
    private BroadphaseType broadphaseType = BroadphaseType.DBVT;
    private CollisionDispatcher dispatcher;
    private ConstraintSolver solver;
    private DefaultCollisionConfiguration collisionConfiguration;
    private Map<PairCachingGhostObject, PhysicsGhostObject> physicsGhostObjects = new ConcurrentHashMap<PairCachingGhostObject, PhysicsGhostObject>();
    private Map<PairCachingGhostObject, PhysicsCharacter> physicsCharacters = new ConcurrentHashMap<PairCachingGhostObject, PhysicsCharacter>();
    private Map<RigidBody, PhysicsRigidBody> physicsBodies = new ConcurrentHashMap<RigidBody, PhysicsRigidBody>();
    private Map<TypedConstraint, PhysicsJoint> physicsJoints = new ConcurrentHashMap<TypedConstraint, PhysicsJoint>();
    private Map<RaycastVehicle, PhysicsVehicle> physicsVehicles = new ConcurrentHashMap<RaycastVehicle, PhysicsVehicle>();
    private Map<Integer, PhysicsCollisionGroupListener> collisionGroupListeners = new ConcurrentHashMap<Integer, PhysicsCollisionGroupListener>();
    private ConcurrentLinkedQueue<PhysicsTickListener> tickListeners = new ConcurrentLinkedQueue();
    private final List<PhysicsCollisionListener> collisionListeners = new SafeArrayList(PhysicsCollisionListener.class);
    private ArrayDeque<PhysicsCollisionEvent> collisionEvents = new ArrayDeque();
    private PhysicsCollisionEventFactory eventFactory = new PhysicsCollisionEventFactory();
    private Vector3f worldMin = new Vector3f(-10000.0f, -10000.0f, -10000.0f);
    private Vector3f worldMax = new Vector3f(10000.0f, 10000.0f, 10000.0f);
    private float accuracy = 0.016666668f;
    private int maxSubSteps = 4;
    private javax.vecmath.Vector3f rayVec1 = new javax.vecmath.Vector3f();
    private javax.vecmath.Vector3f rayVec2 = new javax.vecmath.Vector3f();
    private Transform sweepTrans1 = new Transform(new Matrix3f());
    private Transform sweepTrans2 = new Transform(new Matrix3f());

    public static PhysicsSpace getPhysicsSpace() {
        return physicsSpaceTL.get();
    }

    public static void setLocalThreadPhysicsSpace(PhysicsSpace space) {
        physicsSpaceTL.set(space);
    }

    public PhysicsSpace() {
        this(new Vector3f(-10000.0f, -10000.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f), BroadphaseType.DBVT);
    }

    public PhysicsSpace(BroadphaseType broadphaseType) {
        this(new Vector3f(-10000.0f, -10000.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f), broadphaseType);
    }

    public PhysicsSpace(Vector3f worldMin, Vector3f worldMax) {
        this(worldMin, worldMax, BroadphaseType.AXIS_SWEEP_3);
    }

    public PhysicsSpace(Vector3f worldMin, Vector3f worldMax, BroadphaseType broadphaseType) {
        this.worldMin.set(worldMin);
        this.worldMax.set(worldMax);
        this.broadphaseType = broadphaseType;
        this.create();
    }

    public void create() {
        pQueueTL.set(this.pQueue);
        this.collisionConfiguration = new DefaultCollisionConfiguration();
        this.dispatcher = new CollisionDispatcher((CollisionConfiguration)this.collisionConfiguration);
        switch (this.broadphaseType.ordinal()) {
            case 0: {
                this.broadphase = new SimpleBroadphase();
                break;
            }
            case 1: {
                this.broadphase = new AxisSweep3(Converter.convert(this.worldMin), Converter.convert(this.worldMax));
                break;
            }
            case 2: {
                this.broadphase = new AxisSweep3_32(Converter.convert(this.worldMin), Converter.convert(this.worldMax));
                break;
            }
            case 3: {
                this.broadphase = new DbvtBroadphase();
            }
        }
        this.solver = new SequentialImpulseConstraintSolver();
        this.dynamicsWorld = new DiscreteDynamicsWorld((Dispatcher)this.dispatcher, this.broadphase, this.solver, (CollisionConfiguration)this.collisionConfiguration);
        this.dynamicsWorld.setGravity(new javax.vecmath.Vector3f(0.0f, -9.81f, 0.0f));
        this.broadphase.getOverlappingPairCache().setInternalGhostPairCallback((OverlappingPairCallback)new GhostPairCallback());
        GImpactCollisionAlgorithm.registerAlgorithm((CollisionDispatcher)this.dispatcher);
        physicsSpaceTL.set(this);
        this.setTickCallback();
        this.setContactCallbacks();
        this.setOverlapFilterCallback();
    }

    private void setOverlapFilterCallback() {
        OverlapFilterCallback callback = new OverlapFilterCallback(){

            public boolean needBroadphaseCollision(BroadphaseProxy bp, BroadphaseProxy bp1) {
                boolean collides;
                boolean bl = collides = (bp.collisionFilterGroup & bp1.collisionFilterMask) != 0;
                if (collides) {
                    boolean bl2 = collides = (bp1.collisionFilterGroup & bp.collisionFilterMask) != 0;
                }
                if (collides) {
                    assert (bp.clientObject instanceof CollisionObject && bp1.clientObject instanceof CollisionObject);
                    CollisionObject colOb = (CollisionObject)bp.clientObject;
                    CollisionObject colOb1 = (CollisionObject)bp1.clientObject;
                    assert (colOb.getUserPointer() != null && colOb1.getUserPointer() != null);
                    PhysicsCollisionObject collisionObject = (PhysicsCollisionObject)colOb.getUserPointer();
                    PhysicsCollisionObject collisionObject1 = (PhysicsCollisionObject)colOb1.getUserPointer();
                    if ((collisionObject.getCollideWithGroups() & collisionObject1.getCollisionGroup()) > 0 || (collisionObject1.getCollideWithGroups() & collisionObject.getCollisionGroup()) > 0) {
                        PhysicsCollisionGroupListener listener = (PhysicsCollisionGroupListener)PhysicsSpace.this.collisionGroupListeners.get(collisionObject.getCollisionGroup());
                        PhysicsCollisionGroupListener listener1 = (PhysicsCollisionGroupListener)PhysicsSpace.this.collisionGroupListeners.get(collisionObject1.getCollisionGroup());
                        if (listener != null) {
                            collides = listener.collide(collisionObject, collisionObject1);
                        }
                        if (listener1 != null && collisionObject.getCollisionGroup() != collisionObject1.getCollisionGroup()) {
                            collides = listener1.collide(collisionObject, collisionObject1) && collides;
                        }
                    } else {
                        return false;
                    }
                }
                return collides;
            }
        };
        this.dynamicsWorld.getPairCache().setOverlapFilterCallback(callback);
    }

    private void setTickCallback() {
        final PhysicsSpace space = this;
        InternalTickCallback callback2 = new InternalTickCallback(){

            public void internalTick(DynamicsWorld dw, float f) {
                AppTask task = (AppTask)PhysicsSpace.this.pQueue.poll();
                task = (AppTask)PhysicsSpace.this.pQueue.poll();
                while (task != null) {
                    while (task.isCancelled()) {
                        task = (AppTask)PhysicsSpace.this.pQueue.poll();
                    }
                    try {
                        task.invoke();
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                    task = (AppTask)PhysicsSpace.this.pQueue.poll();
                }
                for (PhysicsTickListener physicsTickCallback : PhysicsSpace.this.tickListeners) {
                    physicsTickCallback.prePhysicsTick(space, f);
                }
            }
        };
        this.dynamicsWorld.setPreTickCallback(callback2);
        InternalTickCallback callback = new InternalTickCallback(){

            public void internalTick(DynamicsWorld dw, float f) {
                for (PhysicsTickListener physicsTickCallback : PhysicsSpace.this.tickListeners) {
                    physicsTickCallback.physicsTick(space, f);
                }
            }
        };
        this.dynamicsWorld.setInternalTickCallback(callback, (Object)this);
    }

    private void setContactCallbacks() {
        BulletGlobals.setContactAddedCallback((ContactAddedCallback)new ContactAddedCallback(){

            public boolean contactAdded(ManifoldPoint cp, CollisionObject colObj0, int partId0, int index0, CollisionObject colObj1, int partId1, int index1) {
                System.out.println("contact added");
                return true;
            }
        });
        BulletGlobals.setContactProcessedCallback((ContactProcessedCallback)new ContactProcessedCallback(){

            public boolean contactProcessed(ManifoldPoint cp, Object body0, Object body1) {
                if (body0 instanceof CollisionObject && body1 instanceof CollisionObject) {
                    PhysicsCollisionObject node = null;
                    PhysicsCollisionObject node1 = null;
                    CollisionObject rBody0 = (CollisionObject)body0;
                    CollisionObject rBody1 = (CollisionObject)body1;
                    node = (PhysicsCollisionObject)rBody0.getUserPointer();
                    node1 = (PhysicsCollisionObject)rBody1.getUserPointer();
                    PhysicsSpace.this.collisionEvents.add(PhysicsSpace.this.eventFactory.getEvent(1, node, node1, cp));
                }
                return true;
            }
        });
        BulletGlobals.setContactDestroyedCallback((ContactDestroyedCallback)new ContactDestroyedCallback(){

            public boolean contactDestroyed(Object userPersistentData) {
                System.out.println("contact destroyed");
                return true;
            }
        });
    }

    public void update(float time) {
        this.update(time, this.maxSubSteps);
    }

    public void update(float time, int maxSteps) {
        if (this.getDynamicsWorld() == null) {
            return;
        }
        this.dynamicsWorld.stepSimulation(time, maxSteps, this.accuracy);
    }

    public void distributeEvents() {
        int cListSize = this.collisionListeners.size();
        while (!this.collisionEvents.isEmpty()) {
            PhysicsCollisionEvent physicsCollisionEvent = this.collisionEvents.pop();
            for (int i = 0; i < cListSize; ++i) {
                this.collisionListeners.get(i).collision(physicsCollisionEvent);
            }
            this.eventFactory.recycle(physicsCollisionEvent);
        }
    }

    public static <V> Future<V> enqueueOnThisThread(Callable<V> callable) {
        AppTask task = new AppTask(callable);
        System.out.println("created AppTask");
        pQueueTL.get().add(task);
        return task;
    }

    public <V> Future<V> enqueue(Callable<V> callable) {
        AppTask task = new AppTask(callable);
        this.pQueue.add(task);
        return task;
    }

    public void add(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof PhysicsControl) {
            ((PhysicsControl)obj).setPhysicsSpace(this);
        } else if (obj instanceof Spatial) {
            Spatial node = (Spatial)obj;
            for (int i = 0; i < node.getNumControls(); ++i) {
                if (!(node.getControl(i) instanceof PhysicsControl)) continue;
                this.add(node.getControl(i));
            }
        } else if (obj instanceof PhysicsCollisionObject) {
            this.addCollisionObject((PhysicsCollisionObject)obj);
        } else if (obj instanceof PhysicsJoint) {
            this.addJoint((PhysicsJoint)obj);
        } else {
            throw new UnsupportedOperationException("Cannot add this kind of object to the physics space.");
        }
    }

    public void addCollisionObject(PhysicsCollisionObject obj) {
        if (obj instanceof PhysicsGhostObject) {
            this.addGhostObject((PhysicsGhostObject)obj);
        } else if (obj instanceof PhysicsRigidBody) {
            this.addRigidBody((PhysicsRigidBody)obj);
        } else if (obj instanceof PhysicsVehicle) {
            this.addRigidBody((PhysicsVehicle)obj);
        } else if (obj instanceof PhysicsCharacter) {
            this.addCharacter((PhysicsCharacter)obj);
        }
    }

    public void remove(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof PhysicsControl) {
            ((PhysicsControl)obj).setPhysicsSpace(null);
        } else if (obj instanceof Spatial) {
            Spatial node = (Spatial)obj;
            for (int i = 0; i < node.getNumControls(); ++i) {
                if (!(node.getControl(i) instanceof PhysicsControl)) continue;
                this.remove(node.getControl(i));
            }
        } else if (obj instanceof PhysicsCollisionObject) {
            this.removeCollisionObject((PhysicsCollisionObject)obj);
        } else if (obj instanceof PhysicsJoint) {
            this.removeJoint((PhysicsJoint)obj);
        } else {
            throw new UnsupportedOperationException("Cannot remove this kind of object from the physics space.");
        }
    }

    public void removeCollisionObject(PhysicsCollisionObject obj) {
        if (obj instanceof PhysicsGhostObject) {
            this.removeGhostObject((PhysicsGhostObject)obj);
        } else if (obj instanceof PhysicsRigidBody) {
            this.removeRigidBody((PhysicsRigidBody)obj);
        } else if (obj instanceof PhysicsCharacter) {
            this.removeCharacter((PhysicsCharacter)obj);
        }
    }

    public void addAll(Spatial spatial) {
        this.add(spatial);
        if (spatial.getControl(RigidBodyControl.class) != null) {
            RigidBodyControl physicsNode = (RigidBodyControl)spatial.getControl(RigidBodyControl.class);
            List<PhysicsJoint> joints = physicsNode.getJoints();
            for (PhysicsJoint physicsJoint : joints) {
                if (!physicsNode.equals(physicsJoint.getBodyA())) continue;
                this.add(physicsJoint);
            }
        }
        if (spatial instanceof Node) {
            List children = ((Node)spatial).getChildren();
            for (Spatial spat : children) {
                this.addAll(spat);
            }
        }
    }

    public void removeAll(Spatial spatial) {
        if (spatial.getControl(RigidBodyControl.class) != null) {
            RigidBodyControl physicsNode = (RigidBodyControl)spatial.getControl(RigidBodyControl.class);
            List<PhysicsJoint> joints = physicsNode.getJoints();
            for (PhysicsJoint physicsJoint : joints) {
                if (!physicsNode.equals(physicsJoint.getBodyA())) continue;
                this.removeJoint(physicsJoint);
            }
        }
        this.remove(spatial);
        if (spatial instanceof Node) {
            List children = ((Node)spatial).getChildren();
            for (Spatial spat : children) {
                this.removeAll(spat);
            }
        }
    }

    private void addGhostObject(PhysicsGhostObject node) {
        if (this.physicsGhostObjects.containsKey(node.getObjectId())) {
            logger.log(Level.WARNING, "GhostObject {0} already exists in PhysicsSpace, cannot add.", node);
            return;
        }
        this.physicsGhostObjects.put(node.getObjectId(), node);
        logger.log(Level.FINE, "Adding ghost object {0} to physics space.", node.getObjectId());
        this.dynamicsWorld.addCollisionObject((CollisionObject)node.getObjectId());
    }

    private void removeGhostObject(PhysicsGhostObject node) {
        if (!this.physicsGhostObjects.containsKey(node.getObjectId())) {
            logger.log(Level.WARNING, "GhostObject {0} does not exist in PhysicsSpace, cannot remove.", node);
            return;
        }
        this.physicsGhostObjects.remove(node.getObjectId());
        logger.log(Level.FINE, "Removing ghost object {0} from physics space.", node.getObjectId());
        this.dynamicsWorld.removeCollisionObject((CollisionObject)node.getObjectId());
    }

    private void addCharacter(PhysicsCharacter node) {
        if (this.physicsCharacters.containsKey(node.getObjectId())) {
            logger.log(Level.WARNING, "Character {0} already exists in PhysicsSpace, cannot add.", node);
            return;
        }
        this.physicsCharacters.put(node.getObjectId(), node);
        logger.log(Level.FINE, "Adding character {0} to physics space.", node.getObjectId());
        this.dynamicsWorld.addCollisionObject((CollisionObject)node.getObjectId(), (short)32, (short)3);
        this.dynamicsWorld.addAction((ActionInterface)node.getControllerId());
    }

    private void removeCharacter(PhysicsCharacter node) {
        if (!this.physicsCharacters.containsKey(node.getObjectId())) {
            logger.log(Level.WARNING, "Character {0} does not exist in PhysicsSpace, cannot remove.", node);
            return;
        }
        this.physicsCharacters.remove(node.getObjectId());
        logger.log(Level.FINE, "Removing character {0} from physics space.", node.getObjectId());
        this.dynamicsWorld.removeAction((ActionInterface)node.getControllerId());
        this.dynamicsWorld.removeCollisionObject((CollisionObject)node.getObjectId());
    }

    private void addRigidBody(PhysicsRigidBody node) {
        if (this.physicsBodies.containsKey(node.getObjectId())) {
            logger.log(Level.WARNING, "RigidBody {0} already exists in PhysicsSpace, cannot add.", node);
            return;
        }
        this.physicsBodies.put(node.getObjectId(), node);
        boolean kinematic = false;
        if (node.isKinematic()) {
            kinematic = true;
            node.setKinematic(false);
        }
        this.dynamicsWorld.addRigidBody(node.getObjectId());
        if (kinematic) {
            node.setKinematic(true);
        }
        logger.log(Level.FINE, "Adding RigidBody {0} to physics space.", node.getObjectId());
        if (node instanceof PhysicsVehicle) {
            logger.log(Level.FINE, "Adding vehicle constraint {0} to physics space.", ((PhysicsVehicle)node).getVehicleId());
            ((PhysicsVehicle)node).createVehicle(this);
            this.physicsVehicles.put(((PhysicsVehicle)node).getVehicleId(), (PhysicsVehicle)node);
            this.dynamicsWorld.addVehicle(((PhysicsVehicle)node).getVehicleId());
        }
    }

    private void removeRigidBody(PhysicsRigidBody node) {
        if (!this.physicsBodies.containsKey(node.getObjectId())) {
            logger.log(Level.WARNING, "RigidBody {0} does not exist in PhysicsSpace, cannot remove.", node);
            return;
        }
        if (node instanceof PhysicsVehicle) {
            logger.log(Level.FINE, "Removing vehicle constraint {0} from physics space.", ((PhysicsVehicle)node).getVehicleId());
            this.physicsVehicles.remove(((PhysicsVehicle)node).getVehicleId());
            this.dynamicsWorld.removeVehicle(((PhysicsVehicle)node).getVehicleId());
        }
        logger.log(Level.FINE, "Removing RigidBody {0} from physics space.", node.getObjectId());
        this.physicsBodies.remove(node.getObjectId());
        this.dynamicsWorld.removeRigidBody(node.getObjectId());
    }

    private void addJoint(PhysicsJoint joint) {
        if (this.physicsJoints.containsKey(joint.getObjectId())) {
            logger.log(Level.WARNING, "Joint {0} already exists in PhysicsSpace, cannot add.", joint);
            return;
        }
        logger.log(Level.FINE, "Adding Joint {0} to physics space.", joint.getObjectId());
        this.physicsJoints.put(joint.getObjectId(), joint);
        this.dynamicsWorld.addConstraint(joint.getObjectId(), !joint.isCollisionBetweenLinkedBodys());
    }

    private void removeJoint(PhysicsJoint joint) {
        if (!this.physicsJoints.containsKey(joint.getObjectId())) {
            logger.log(Level.WARNING, "Joint {0} does not exist in PhysicsSpace, cannot remove.", joint);
            return;
        }
        logger.log(Level.FINE, "Removing Joint {0} from physics space.", joint.getObjectId());
        this.physicsJoints.remove(joint.getObjectId());
        this.dynamicsWorld.removeConstraint(joint.getObjectId());
    }

    public Collection<PhysicsRigidBody> getRigidBodyList() {
        return new LinkedList<PhysicsRigidBody>(this.physicsBodies.values());
    }

    public Collection<PhysicsGhostObject> getGhostObjectList() {
        return new LinkedList<PhysicsGhostObject>(this.physicsGhostObjects.values());
    }

    public Collection<PhysicsCharacter> getCharacterList() {
        return new LinkedList<PhysicsCharacter>(this.physicsCharacters.values());
    }

    public Collection<PhysicsJoint> getJointList() {
        return new LinkedList<PhysicsJoint>(this.physicsJoints.values());
    }

    public Collection<PhysicsVehicle> getVehicleList() {
        return new LinkedList<PhysicsVehicle>(this.physicsVehicles.values());
    }

    public void setGravity(Vector3f gravity) {
        this.dynamicsWorld.setGravity(Converter.convert(gravity));
    }

    public Vector3f getGravity(Vector3f gravity) {
        javax.vecmath.Vector3f tempVec = new javax.vecmath.Vector3f();
        this.dynamicsWorld.getGravity(tempVec);
        return Converter.convert(tempVec, gravity);
    }

    public void applyGravity() {
        this.dynamicsWorld.applyGravity();
    }

    public void clearForces() {
        this.dynamicsWorld.clearForces();
    }

    public void addTickListener(PhysicsTickListener listener) {
        this.tickListeners.add(listener);
    }

    public void removeTickListener(PhysicsTickListener listener) {
        this.tickListeners.remove(listener);
    }

    public void addCollisionListener(PhysicsCollisionListener listener) {
        this.collisionListeners.add(listener);
    }

    public void removeCollisionListener(PhysicsCollisionListener listener) {
        this.collisionListeners.remove(listener);
    }

    public void addCollisionGroupListener(PhysicsCollisionGroupListener listener, int collisionGroup) {
        this.collisionGroupListeners.put(collisionGroup, listener);
    }

    public void removeCollisionGroupListener(int collisionGroup) {
        this.collisionGroupListeners.remove(collisionGroup);
    }

    public List<PhysicsRayTestResult> rayTest(Vector3f from, Vector3f to) {
        LinkedList<PhysicsRayTestResult> results = new LinkedList<PhysicsRayTestResult>();
        this.dynamicsWorld.rayTest(Converter.convert(from, this.rayVec1), Converter.convert(to, this.rayVec2), (CollisionWorld.RayResultCallback)new InternalRayListener(results));
        return results;
    }

    public List<PhysicsRayTestResult> rayTest(Vector3f from, Vector3f to, List<PhysicsRayTestResult> results) {
        results.clear();
        this.dynamicsWorld.rayTest(Converter.convert(from, this.rayVec1), Converter.convert(to, this.rayVec2), (CollisionWorld.RayResultCallback)new InternalRayListener(results));
        return results;
    }

    public List<PhysicsSweepTestResult> sweepTest(CollisionShape shape, com.jme3.math.Transform start, com.jme3.math.Transform end) {
        LinkedList<PhysicsSweepTestResult> results = new LinkedList<PhysicsSweepTestResult>();
        if (!(shape.getCShape() instanceof ConvexShape)) {
            logger.log(Level.WARNING, "Trying to sweep test with incompatible mesh shape!");
            return results;
        }
        this.dynamicsWorld.convexSweepTest((ConvexShape)shape.getCShape(), Converter.convert(start, this.sweepTrans1), Converter.convert(end, this.sweepTrans2), (CollisionWorld.ConvexResultCallback)new InternalSweepListener(results));
        return results;
    }

    public List<PhysicsSweepTestResult> sweepTest(CollisionShape shape, com.jme3.math.Transform start, com.jme3.math.Transform end, List<PhysicsSweepTestResult> results) {
        results.clear();
        if (!(shape.getCShape() instanceof ConvexShape)) {
            logger.log(Level.WARNING, "Trying to sweep test with incompatible mesh shape!");
            return results;
        }
        this.dynamicsWorld.convexSweepTest((ConvexShape)shape.getCShape(), Converter.convert(start, this.sweepTrans1), Converter.convert(end, this.sweepTrans2), (CollisionWorld.ConvexResultCallback)new InternalSweepListener(results));
        return results;
    }

    public void destroy() {
        this.physicsBodies.clear();
        this.physicsJoints.clear();
        this.dynamicsWorld.destroy();
        this.dynamicsWorld = null;
    }

    public DynamicsWorld getDynamicsWorld() {
        return this.dynamicsWorld;
    }

    public BroadphaseType getBroadphaseType() {
        return this.broadphaseType;
    }

    public void setBroadphaseType(BroadphaseType broadphaseType) {
        this.broadphaseType = broadphaseType;
    }

    public void setMaxSubSteps(int steps) {
        this.maxSubSteps = steps;
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(float accuracy) {
        this.accuracy = accuracy;
    }

    public Vector3f getWorldMin() {
        return this.worldMin;
    }

    public void setWorldMin(Vector3f worldMin) {
        this.worldMin.set(worldMin);
    }

    public Vector3f getWorldMax() {
        return this.worldMax;
    }

    public void setWorldMax(Vector3f worldMax) {
        this.worldMax.set(worldMax);
    }

    public void setSolverNumIterations(int numIterations) {
        this.dynamicsWorld.getSolverInfo().numIterations = numIterations;
    }

    public int getSolverNumIterations() {
        return this.dynamicsWorld.getSolverInfo().numIterations;
    }

    public static enum BroadphaseType {
        SIMPLE,
        AXIS_SWEEP_3,
        AXIS_SWEEP_3_32,
        DBVT;

    }

    private class InternalRayListener
    extends CollisionWorld.RayResultCallback {
        private List<PhysicsRayTestResult> results;

        public InternalRayListener(List<PhysicsRayTestResult> results) {
            this.results = results;
        }

        public float addSingleResult(CollisionWorld.LocalRayResult lrr, boolean bln) {
            PhysicsCollisionObject obj = (PhysicsCollisionObject)lrr.collisionObject.getUserPointer();
            this.results.add(new PhysicsRayTestResult(obj, Converter.convert(lrr.hitNormalLocal), lrr.hitFraction, bln));
            return lrr.hitFraction;
        }
    }

    private class InternalSweepListener
    extends CollisionWorld.ConvexResultCallback {
        private List<PhysicsSweepTestResult> results;

        public InternalSweepListener(List<PhysicsSweepTestResult> results) {
            this.results = results;
        }

        public float addSingleResult(CollisionWorld.LocalConvexResult lcr, boolean bln) {
            PhysicsCollisionObject obj = (PhysicsCollisionObject)lcr.hitCollisionObject.getUserPointer();
            this.results.add(new PhysicsSweepTestResult(obj, Converter.convert(lcr.hitNormalLocal), lcr.hitFraction, bln));
            return lcr.hitFraction;
        }
    }
}

