/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.bulletphysics.collision.shapes.ConeShape;
import com.bulletphysics.collision.shapes.ConeShapeX;
import com.bulletphysics.collision.shapes.ConeShapeZ;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;

public class ConeCollisionShape
extends CollisionShape {
    protected float radius;
    protected float height;
    protected int axis;

    protected ConeCollisionShape() {
    }

    public ConeCollisionShape(float radius, float height, int axis) {
        this.radius = radius;
        this.height = height;
        this.axis = axis;
        if (axis < 0 || axis > 2) {
            throw new UnsupportedOperationException("axis must be one of the PhysicsSpace.AXIS_* constants!");
        }
        this.createShape();
    }

    public ConeCollisionShape(float radius, float height) {
        this.radius = radius;
        this.height = height;
        this.axis = 1;
        this.createShape();
    }

    public float getRadius() {
        return this.radius;
    }

    public float getHeight() {
        return this.height;
    }

    public int getAxis() {
        return this.axis;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write(this.radius, "radius", 0.5f);
        capsule.write(this.height, "height", 0.5f);
        capsule.write(this.axis, "axis", 1);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.radius = capsule.readFloat("radius", 0.5f);
        this.height = capsule.readFloat("height", 0.5f);
        this.axis = capsule.readInt("axis", 1);
        this.createShape();
    }

    protected void createShape() {
        if (this.axis == 0) {
            this.cShape = new ConeShapeX(this.radius, this.height);
        } else if (this.axis == 1) {
            this.cShape = new ConeShape(this.radius, this.height);
        } else if (this.axis == 2) {
            this.cShape = new ConeShapeZ(this.radius, this.height);
        } else {
            throw new UnsupportedOperationException("Unexpected axis: " + this.axis);
        }
        this.cShape.setLocalScaling(Converter.convert(this.getScale()));
        this.cShape.setMargin(this.margin);
    }
}

