/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;

public class BulletCharacterDebugControl
extends AbstractPhysicsDebugControl {
    protected final PhysicsCharacter body;
    protected final Vector3f location = new Vector3f();
    protected final Quaternion rotation = new Quaternion();
    protected CollisionShape myShape;
    protected Spatial geom;
    private final Vector3f oldScale = new Vector3f();

    public BulletCharacterDebugControl(BulletDebugAppState debugAppState, PhysicsCharacter body) {
        super(debugAppState);
        this.body = body;
        this.myShape = body.getCollisionShape();
        this.oldScale.set(this.myShape.getScale());
        this.geom = DebugShapeFactory.getDebugShape(this.myShape);
        this.geom.setName(body.toString());
        this.geom.setMaterial(debugAppState.DEBUG_PINK);
    }

    public void setSpatial(Spatial spatial) {
        if (spatial != null && spatial instanceof Node) {
            Node node = (Node)spatial;
            node.attachChild(this.geom);
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            node.detachChild(this.geom);
        }
        super.setSpatial(spatial);
    }

    @Override
    protected void controlUpdate(float tpf) {
        CollisionShape newShape = this.body.getCollisionShape();
        Vector3f newScale = newShape.getScale();
        if (this.myShape != newShape || !this.oldScale.equals((Object)newScale)) {
            this.myShape = newShape;
            this.oldScale.set(newScale);
            Node node = (Node)this.spatial;
            node.detachChild(this.geom);
            this.geom = DebugShapeFactory.getDebugShape(this.myShape);
            this.geom.setName(this.body.toString());
            node.attachChild(this.geom);
        }
        this.geom.setMaterial(this.debugAppState.DEBUG_PINK);
        this.body.getPhysicsLocation(this.location);
        this.applyPhysicsTransform(this.location, Quaternion.IDENTITY);
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }
}

