/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector4f;
import com.jme3.opencl.Buffer;
import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Device;
import com.jme3.opencl.Event;
import com.jme3.opencl.Image;
import com.jme3.opencl.Kernel;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.lwjgl.LwjglBuffer;
import com.jme3.opencl.lwjgl.LwjglCommandQueue;
import com.jme3.opencl.lwjgl.LwjglDevice;
import com.jme3.opencl.lwjgl.LwjglEvent;
import com.jme3.opencl.lwjgl.LwjglImage;
import com.jme3.opencl.lwjgl.Utils;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLObject;

public class LwjglKernel
extends Kernel {
    private final CLKernel kernel;

    public LwjglKernel(CLKernel kernel) {
        super((OpenCLObject.ObjectReleaser)new ReleaserImpl(kernel));
        this.kernel = kernel;
    }

    public CLKernel getKernel() {
        return this.kernel;
    }

    public String getName() {
        return this.kernel.getInfoString(4496);
    }

    public int getArgCount() {
        return this.kernel.getInfoInt(4497);
    }

    public long getMaxWorkGroupSize(Device device) {
        CLDevice d = ((LwjglDevice)device).getDevice();
        return this.kernel.getWorkGroupInfoSize(d, 4528);
    }

    public void setArg(int index, Kernel.LocalMemPerElement t) {
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (long)((long)t.getSize() * this.workGroupSize.getSizes()[0] * this.workGroupSize.getSizes()[1] * this.workGroupSize.getSizes()[2]));
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, Kernel.LocalMem t) {
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (long)t.getSize());
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, Buffer t) {
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (CLObject)((LwjglBuffer)t).getBuffer());
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, Image i) {
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (CLObject)((LwjglImage)i).getImage());
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, byte b) {
        ByteBuffer buf = Utils.tempBuffers[0].b16;
        buf.position(0);
        buf.limit(1);
        buf.put(0, b);
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (ByteBuffer)buf);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, short s) {
        ShortBuffer buf = Utils.tempBuffers[0].b16s;
        buf.position(0);
        buf.limit(1);
        buf.put(0, s);
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (ShortBuffer)buf);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, int i) {
        IntBuffer buf = Utils.tempBuffers[0].b16i;
        buf.position(0);
        buf.limit(1);
        buf.put(0, i);
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (IntBuffer)buf);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, long l) {
        LongBuffer buf = Utils.tempBuffers[0].b16l;
        buf.position(0);
        buf.limit(1);
        buf.put(0, l);
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (LongBuffer)buf);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, float f) {
        FloatBuffer buf = Utils.tempBuffers[0].b16f;
        buf.position(0);
        buf.limit(1);
        buf.put(0, f);
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (FloatBuffer)buf);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, double d) {
        DoubleBuffer buf = Utils.tempBuffers[0].b16d;
        buf.position(0);
        buf.limit(1);
        buf.put(0, d);
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (DoubleBuffer)buf);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, Vector2f v) {
        FloatBuffer buf = Utils.tempBuffers[0].b16f;
        buf.position(0);
        buf.limit(2);
        buf.put(0, v.x);
        buf.put(1, v.y);
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (FloatBuffer)buf);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, Vector4f v) {
        FloatBuffer buf = Utils.tempBuffers[0].b16f;
        buf.position(0);
        buf.limit(4);
        buf.put(0, v.x);
        buf.put(1, v.y);
        buf.put(2, v.z);
        buf.put(3, v.w);
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (FloatBuffer)buf);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, Quaternion q) {
        FloatBuffer buf = Utils.tempBuffers[0].b16f;
        buf.position(0);
        buf.limit(4);
        buf.put(0, q.getX());
        buf.put(1, q.getY());
        buf.put(2, q.getZ());
        buf.put(3, q.getW());
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (FloatBuffer)buf);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, Matrix4f m) {
        FloatBuffer buf = Utils.b80f;
        buf.position(0);
        buf.limit(16);
        buf.put(m.m00).put(m.m01).put(m.m02).put(m.m03);
        buf.put(m.m10).put(m.m11).put(m.m12).put(m.m13);
        buf.put(m.m20).put(m.m21).put(m.m22).put(m.m23);
        buf.put(m.m30).put(m.m31).put(m.m32).put(m.m33);
        buf.position(0);
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (FloatBuffer)buf);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public void setArg(int index, ByteBuffer buffer, long size) {
        buffer.limit((int)((long)buffer.position() + size));
        int ret = CL10.clSetKernelArg((CLKernel)this.kernel, (int)index, (ByteBuffer)buffer);
        Utils.checkError(ret, "clSetKernelArg");
    }

    public Event Run(CommandQueue queue) {
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[1].put(this.globalWorkSize.getSizes());
        Utils.pointerBuffers[1].position(0);
        PointerBuffer p2 = null;
        if (this.workGroupSize.getSizes()[0] > 0L) {
            p2 = Utils.pointerBuffers[2].rewind();
            p2.put(this.workGroupSize.getSizes());
            p2.position(0);
        }
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueNDRangeKernel((CLCommandQueue)q, (CLKernel)this.kernel, (int)this.globalWorkSize.getDimension(), null, (PointerBuffer)Utils.pointerBuffers[1], (PointerBuffer)p2, null, (PointerBuffer)Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueNDRangeKernel");
        return new LwjglEvent(q.getCLEvent(Utils.pointerBuffers[0].get(0)));
    }

    public void RunNoEvent(CommandQueue queue) {
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[1].put(this.globalWorkSize.getSizes());
        Utils.pointerBuffers[1].position(0);
        PointerBuffer p2 = null;
        if (this.workGroupSize.getSizes()[0] > 0L) {
            p2 = Utils.pointerBuffers[2].rewind();
            p2.put(this.workGroupSize.getSizes());
            p2.position(0);
        }
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueNDRangeKernel((CLCommandQueue)q, (CLKernel)this.kernel, (int)this.globalWorkSize.getDimension(), null, (PointerBuffer)Utils.pointerBuffers[1], (PointerBuffer)p2, null, null);
        Utils.checkError(ret, "clEnqueueNDRangeKernel");
    }

    public OpenCLObject.ObjectReleaser getReleaser() {
        return new ReleaserImpl(this.kernel);
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private CLKernel kernel;

        private ReleaserImpl(CLKernel kernel) {
            this.kernel = kernel;
        }

        public void release() {
            if (this.kernel != null) {
                int ret = CL10.clReleaseKernel((CLKernel)this.kernel);
                this.kernel = null;
                Utils.reportError(ret, "clReleaseKernel");
            }
        }
    }
}

