/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.lwjgl;

import com.jme3.input.lwjgl.JInputJoyInput;
import com.jme3.input.lwjgl.LwjglKeyInput;
import com.jme3.input.lwjgl.LwjglMouseInput;
import com.jme3.opencl.Context;
import com.jme3.opencl.DefaultPlatformChooser;
import com.jme3.opencl.Device;
import com.jme3.opencl.PlatformChooser;
import com.jme3.opencl.lwjgl.LwjglDevice;
import com.jme3.opencl.lwjgl.LwjglPlatform;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.RendererException;
import com.jme3.renderer.lwjgl.LwjglGL;
import com.jme3.renderer.lwjgl.LwjglGLExt;
import com.jme3.renderer.lwjgl.LwjglGLFboEXT;
import com.jme3.renderer.lwjgl.LwjglGLFboGL3;
import com.jme3.renderer.opengl.GL;
import com.jme3.renderer.opengl.GL2;
import com.jme3.renderer.opengl.GL3;
import com.jme3.renderer.opengl.GL4;
import com.jme3.renderer.opengl.GLDebug;
import com.jme3.renderer.opengl.GLExt;
import com.jme3.renderer.opengl.GLFbo;
import com.jme3.renderer.opengl.GLRenderer;
import com.jme3.renderer.opengl.GLTiming;
import com.jme3.renderer.opengl.GLTimingState;
import com.jme3.renderer.opengl.GLTracer;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.NativeLibraries;
import com.jme3.system.NativeLibraryLoader;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import com.jme3.system.lwjgl.LwjglGLDebugOutputHandler;
import com.jme3.system.lwjgl.LwjglTimer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.ARBDebugOutputCallback;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;

public abstract class LwjglContext
implements JmeContext {
    private static final Logger logger = Logger.getLogger(LwjglContext.class.getName());
    protected static final String THREAD_NAME = "jME3 Main";
    protected AtomicBoolean created = new AtomicBoolean(false);
    protected AtomicBoolean renderable = new AtomicBoolean(false);
    protected final Object createdLock = new Object();
    protected AppSettings settings = new AppSettings(true);
    protected Renderer renderer;
    protected LwjglKeyInput keyInput;
    protected LwjglMouseInput mouseInput;
    protected JInputJoyInput joyInput;
    protected Timer timer;
    protected SystemListener listener;
    protected LwjglPlatform clPlatform;
    protected com.jme3.opencl.lwjgl.LwjglContext clContext;

    public SystemListener getSystemListener() {
        return this.listener;
    }

    public void setSystemListener(SystemListener listener) {
        this.listener = listener;
    }

    protected void printContextInitInfo() {
        logger.log(Level.INFO, "LWJGL {0} context running on thread {1}\n * Graphics Adapter: {2}\n * Driver Version: {3}\n * Scaling Factor: {4}", new Object[]{Sys.getVersion(), Thread.currentThread().getName(), Display.getAdapter(), Display.getVersion(), Float.valueOf(Display.getPixelScaleFactor())});
    }

    protected int[] getGLVersion(String renderer) {
        int[] nArray;
        int maj = -1;
        int min = -1;
        switch (this.settings.getRenderer()) {
            case "LWJGL-OpenGL2": {
                maj = 2;
                min = 0;
                break;
            }
            case "LWJGL-OpenGL30": {
                maj = 3;
                min = 0;
                break;
            }
            case "LWJGL-OpenGL31": {
                maj = 3;
                min = 1;
                break;
            }
            case "LWJGL-OpenGL3": {
                maj = 3;
                min = 2;
                break;
            }
            case "LWJGL-OpenGL33": {
                maj = 3;
                min = 3;
                break;
            }
            case "LWJGL-OpenGL4": {
                maj = 4;
                min = 0;
                break;
            }
            case "LWJGL-OpenGL41": {
                maj = 4;
                min = 1;
                break;
            }
            case "LWJGL-OpenGL42": {
                maj = 4;
                min = 2;
                break;
            }
            case "LWJGL-OpenGL43": {
                maj = 4;
                min = 3;
                break;
            }
            case "LWJGL-OpenGL44": {
                maj = 4;
                min = 4;
                break;
            }
            case "LWJGL-OpenGL45": {
                maj = 4;
                min = 5;
            }
        }
        if (maj == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = maj;
            nArray = nArray2;
            nArray2[1] = min;
        }
        return nArray;
    }

    protected ContextAttribs createContextAttribs() {
        int[] vers = this.getGLVersion(this.settings.getRenderer());
        if (this.settings.isGraphicsDebug() || vers != null && vers[0] != 2) {
            ContextAttribs attr;
            if (vers != null && vers[0] != 2) {
                attr = new ContextAttribs(vers[0], vers[1]);
                attr = attr.withProfileCore(true).withForwardCompatible(true).withProfileCompatibility(false);
            } else {
                attr = new ContextAttribs();
            }
            if (this.settings.isGraphicsDebug()) {
                attr = attr.withDebug(true);
            }
            return attr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int determineMaxSamples(int requestedSamples) {
        try {
            if (Display.isCreated() && Display.isCurrent()) {
                if (GLContext.getCapabilities().GL_ARB_framebuffer_object) {
                    return GL11.glGetInteger((int)36183);
                }
                if (GLContext.getCapabilities().GL_EXT_framebuffer_multisample) {
                    return GL11.glGetInteger((int)36183);
                }
                return Integer.MAX_VALUE;
            }
        }
        catch (LWJGLException ex) {
            this.listener.handleError("Failed to check if display is current", (Throwable)ex);
        }
        if ((Pbuffer.getCapabilities() & 1) == 0) {
            return Integer.MAX_VALUE;
        }
        Pbuffer pb = null;
        try {
            pb = new Pbuffer(1, 1, new PixelFormat(0, 0, 0), null);
            pb.makeCurrent();
            if (GLContext.getCapabilities().GL_ARB_framebuffer_object) {
                int n = GL11.glGetInteger((int)36183);
                return n;
            }
            if (GLContext.getCapabilities().GL_EXT_framebuffer_multisample) {
                int n = GL11.glGetInteger((int)36183);
                return n;
            }
            int n = Integer.MAX_VALUE;
            return n;
        }
        catch (LWJGLException ex) {
            int n = Integer.MAX_VALUE;
            return n;
        }
        finally {
            if (pb != null) {
                pb.destroy();
            }
        }
    }

    protected void loadNatives() {
        if (JmeSystem.isLowPermissions()) {
            return;
        }
        if ("LWJGL".equals(this.settings.getAudioRenderer())) {
            NativeLibraryLoader.loadNativeLibrary((String)NativeLibraries.OpenAL.getName(), (boolean)true);
        }
        if (this.settings.useJoysticks()) {
            NativeLibraryLoader.loadNativeLibrary((String)NativeLibraries.JInput.getName(), (boolean)true);
            NativeLibraryLoader.loadNativeLibrary((String)NativeLibraries.JInputDX8.getName(), (boolean)true);
        }
        NativeLibraryLoader.loadNativeLibrary((String)NativeLibraries.Lwjgl.getName(), (boolean)true);
    }

    protected int getNumSamplesToUse() {
        int supportedSamples;
        int samples = 0;
        if (this.settings.getSamples() > 1 && (supportedSamples = this.determineMaxSamples(samples = this.settings.getSamples())) < samples) {
            logger.log(Level.WARNING, "Couldn''t satisfy antialiasing samples requirement: x{0}. Video hardware only supports: x{1}", new Object[]{samples, supportedSamples});
            samples = supportedSamples;
        }
        return samples;
    }

    protected void reinitContext() {
        this.initContext(false);
    }

    protected void initContextFirstTime() {
        this.initContext(true);
    }

    private void initContext(boolean first) {
        if (!GLContext.getCapabilities().OpenGL20) {
            throw new RendererException("OpenGL 2.0 or higher is required for jMonkeyEngine");
        }
        int[] version = this.getGLVersion(this.settings.getRenderer());
        if (version != null) {
            if (first) {
                LwjglGL gl = new LwjglGL();
                LwjglGLExt glext = new LwjglGLExt();
                Object glfbo = GLContext.getCapabilities().OpenGL30 ? new LwjglGLFboGL3() : new LwjglGLFboEXT();
                if (this.settings.isGraphicsDebug()) {
                    gl = (GL)GLDebug.createProxy((GL)gl, (Object)gl, (Class[])new Class[]{GL.class, GL2.class, GL3.class, GL4.class});
                    glext = (GLExt)GLDebug.createProxy((GL)gl, (Object)glext, (Class[])new Class[]{GLExt.class});
                    glfbo = (GLFbo)GLDebug.createProxy((GL)gl, (Object)glfbo, (Class[])new Class[]{GLFbo.class});
                }
                if (this.settings.isGraphicsTiming()) {
                    GLTimingState timingState = new GLTimingState();
                    gl = (GL)GLTiming.createGLTiming((Object)gl, (GLTimingState)timingState, (Class[])new Class[]{GL.class, GL2.class, GL3.class, GL4.class});
                    glext = (GLExt)GLTiming.createGLTiming((Object)glext, (GLTimingState)timingState, (Class[])new Class[]{GLExt.class});
                    glfbo = (GLFbo)GLTiming.createGLTiming((Object)glfbo, (GLTimingState)timingState, (Class[])new Class[]{GLFbo.class});
                }
                if (this.settings.isGraphicsTrace()) {
                    gl = (GL)GLTracer.createDesktopGlTracer((Object)gl, (Class[])new Class[]{GL.class, GL2.class, GL3.class, GL4.class});
                    glext = (GLExt)GLTracer.createDesktopGlTracer((Object)glext, (Class[])new Class[]{GLExt.class});
                    glfbo = (GLFbo)GLTracer.createDesktopGlTracer((Object)glfbo, (Class[])new Class[]{GLFbo.class});
                }
                this.renderer = new GLRenderer((GL)gl, (GLExt)glext, (GLFbo)glfbo);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported renderer: " + this.settings.getRenderer());
        }
        this.renderer.initialize();
        if (GLContext.getCapabilities().GL_ARB_debug_output && this.settings.isGraphicsDebug()) {
            ARBDebugOutput.glDebugMessageCallbackARB((ARBDebugOutputCallback)new ARBDebugOutputCallback((ARBDebugOutputCallback.Handler)new LwjglGLDebugOutputHandler()));
        }
        this.renderer.setMainFrameBufferSrgb(this.settings.isGammaCorrection());
        this.renderer.setLinearizeSrgbImages(this.settings.isGammaCorrection());
        if (first) {
            if (this.keyInput != null) {
                this.keyInput.initialize();
            }
            if (this.mouseInput != null) {
                this.mouseInput.initialize();
            }
            if (this.joyInput != null) {
                this.joyInput.initialize();
            }
        }
    }

    protected void initOpenCL() {
        List<Object> devices;
        logger.info("Initialize OpenCL with LWJGL2");
        try {
            CL.create();
        }
        catch (LWJGLException ex) {
            logger.log(Level.SEVERE, "Unable to initialize OpenCL", ex);
            return;
        }
        StringBuilder platformInfos = new StringBuilder();
        ArrayList<LwjglPlatform> platforms = new ArrayList<LwjglPlatform>();
        for (CLPlatform p : CLPlatform.getPlatforms()) {
            platforms.add(new LwjglPlatform(p));
        }
        platformInfos.append("Available OpenCL platforms:");
        for (int i = 0; i < platforms.size(); ++i) {
            LwjglPlatform platform = (LwjglPlatform)platforms.get(i);
            platformInfos.append("\n * Platform ").append(i + 1);
            platformInfos.append("\n *   Name: ").append(platform.getName());
            platformInfos.append("\n *   Vendor: ").append(platform.getVendor());
            platformInfos.append("\n *   Version: ").append(platform.getVersion());
            platformInfos.append("\n *   Profile: ").append(platform.getProfile());
            platformInfos.append("\n *   Supports interop: ").append(platform.hasOpenGLInterop());
            devices = platform.getDevices();
            platformInfos.append("\n *   Available devices:");
            for (int j = 0; j < devices.size(); ++j) {
                LwjglDevice device = (LwjglDevice)devices.get(j);
                platformInfos.append("\n *    * Device ").append(j + 1);
                platformInfos.append("\n *    *   Name: ").append(device.getName());
                platformInfos.append("\n *    *   Vendor: ").append(device.getVendor());
                platformInfos.append("\n *    *   Version: ").append(device.getVersion());
                platformInfos.append("\n *    *   Profile: ").append(device.getProfile());
                platformInfos.append("\n *    *   Compiler version: ").append(device.getCompilerVersion());
                platformInfos.append("\n *    *   Device type: ").append(device.getDeviceType());
                platformInfos.append("\n *    *   Compute units: ").append(device.getComputeUnits());
                platformInfos.append("\n *    *   Work group size: ").append(device.getMaxiumWorkItemsPerGroup());
                platformInfos.append("\n *    *   Global memory: ").append(device.getGlobalMemorySize()).append("B");
                platformInfos.append("\n *    *   Local memory: ").append(device.getLocalMemorySize()).append("B");
                platformInfos.append("\n *    *   Constant memory: ").append(device.getMaximumConstantBufferSize()).append("B");
                platformInfos.append("\n *    *   Supports double: ").append(device.hasDouble());
                platformInfos.append("\n *    *   Supports half floats: ").append(device.hasHalfFloat());
                platformInfos.append("\n *    *   Supports writable 3d images: ").append(device.hasWritableImage3D());
                platformInfos.append("\n *    *   Supports interop: ").append(device.hasOpenGLInterop());
            }
        }
        logger.info(platformInfos.toString());
        DefaultPlatformChooser chooser = null;
        if (this.settings.getOpenCLPlatformChooser() != null) {
            try {
                chooser = (PlatformChooser)Class.forName(this.settings.getOpenCLPlatformChooser()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "unable to instantiate custom PlatformChooser", ex);
            }
        }
        if (chooser == null) {
            chooser = new DefaultPlatformChooser();
        }
        List chosenDevices = chooser.chooseDevices(platforms);
        devices = new ArrayList<CLDevice>(chosenDevices.size());
        LwjglPlatform platform = null;
        for (Device d : chosenDevices) {
            if (!(d instanceof LwjglDevice)) {
                logger.log(Level.SEVERE, "attempt to return a custom Device implementation from PlatformChooser: {0}", d);
                return;
            }
            LwjglDevice ld = (LwjglDevice)d;
            if (platform == null) {
                platform = ld.getPlatform();
            } else if (platform != ld.getPlatform()) {
                logger.severe("attempt to use devices from different platforms");
                return;
            }
            devices.add(ld.getDevice());
        }
        if (devices.isEmpty()) {
            logger.warning("no devices specified, no OpenCL context created");
            return;
        }
        this.clPlatform = platform;
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "chosen platform: {0}", platform.getName());
            logger.log(Level.INFO, "chosen devices: {0}", chosenDevices);
        }
        try {
            CLContext c = CLContext.create((CLPlatform)platform.getPlatform(), devices, null, (Drawable)Display.getDrawable(), null);
            this.clContext = new com.jme3.opencl.lwjgl.LwjglContext(c, chosenDevices);
        }
        catch (LWJGLException ex) {
            logger.log(Level.SEVERE, "Unable to create OpenCL context", ex);
            return;
        }
        logger.info("OpenCL context created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalDestroy() {
        this.renderer = null;
        this.timer = null;
        this.renderable.set(false);
        Object object = this.createdLock;
        synchronized (object) {
            this.created.set(false);
            this.createdLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalCreate() {
        this.timer = new LwjglTimer();
        Object object = this.createdLock;
        synchronized (object) {
            this.created.set(true);
            this.createdLock.notifyAll();
        }
        if (this.renderable.get()) {
            this.initContextFirstTime();
        } else assert (this.getType() == JmeContext.Type.Canvas);
    }

    public void create() {
        this.create(false);
    }

    public void destroy() {
        this.destroy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitFor(boolean createdVal) {
        Object object = this.createdLock;
        synchronized (object) {
            while (this.created.get() != createdVal) {
                try {
                    this.createdLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isCreated() {
        return this.created.get();
    }

    public boolean isRenderable() {
        return this.renderable.get();
    }

    public void setSettings(AppSettings settings) {
        this.settings.copyFrom(settings);
    }

    public AppSettings getSettings() {
        return this.settings;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public Context getOpenCLContext() {
        return this.clContext;
    }

    public int getFramebufferHeight() {
        int result = Display.getHeight();
        return result;
    }

    public int getFramebufferWidth() {
        int result = Display.getWidth();
        return result;
    }

    public int getWindowXPosition() {
        int result = Display.getX();
        return result;
    }

    public int getWindowYPosition() {
        int result = Display.getY();
        return result;
    }
}

