/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.lwjgl;

import com.jme3.cursors.plugins.JmeCursor;
import com.jme3.input.MouseInput;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.math.Vector2f;
import com.jme3.system.lwjgl.LwjglWindow;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl.system.MemoryStack;

public class GlfwMouseInput
implements MouseInput {
    private static final Logger logger = Logger.getLogger(GlfwMouseInput.class.getName());
    private static final int WHEEL_SCALE = 120;
    private final Map<JmeCursor, long[]> jmeToGlfwCursorMap = new HashMap<JmeCursor, long[]>();
    private final Queue<MouseMotionEvent> mouseMotionEvents = new ArrayDeque<MouseMotionEvent>();
    private final Queue<MouseButtonEvent> mouseButtonEvents = new ArrayDeque<MouseButtonEvent>();
    private final LwjglWindow context;
    private RawInputListener listener;
    private IntBuffer currentCursorDelays;
    private GLFWCursorPosCallback cursorPosCallback;
    private GLFWScrollCallback scrollCallback;
    private GLFWMouseButtonCallback mouseButtonCallback;
    private long[] currentCursor;
    private double currentCursorFrameStartTime = 0.0;
    private int currentCursorFrame = 0;
    private int mouseX;
    private int mouseY;
    private int mouseWheel;
    private int currentHeight;
    private boolean cursorVisible;
    private boolean initialized;
    private final Vector2f inputScale = new Vector2f();

    private static long[] createGlfwCursor(JmeCursor jmeCursor) {
        long[] cursorArray = new long[jmeCursor.getNumImages()];
        for (int i = 0; i < jmeCursor.getNumImages(); ++i) {
            ByteBuffer buffer = GlfwMouseInput.transformCursorImage(jmeCursor.getImagesData(), jmeCursor.getWidth(), jmeCursor.getHeight(), i);
            GLFWImage glfwImage = new GLFWImage(BufferUtils.createByteBuffer((int)GLFWImage.SIZEOF));
            glfwImage.set(jmeCursor.getWidth(), jmeCursor.getHeight(), buffer);
            int hotspotX = jmeCursor.getXHotSpot();
            int hotspotY = jmeCursor.getHeight() - jmeCursor.getYHotSpot();
            cursorArray[i] = GLFW.glfwCreateCursor((GLFWImage)glfwImage, (int)hotspotX, (int)hotspotY);
        }
        return cursorArray;
    }

    private static ByteBuffer transformCursorImage(IntBuffer imageData, int width, int height, int index) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        for (int y = height - 1; y >= 0; --y) {
            for (int x = 0; x < width; ++x) {
                int pixel = imageData.get(width * height * index + y * width + x);
                byteBuffer.put((byte)(pixel >> 16 & 0xFF));
                byteBuffer.put((byte)(pixel >> 8 & 0xFF));
                byteBuffer.put((byte)(pixel & 0xFF));
                byteBuffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public GlfwMouseInput(LwjglWindow context) {
        this.context = context;
        this.cursorVisible = true;
    }

    private void onCursorPos(long window, double xpos, double ypos) {
        this.context.getWindowContentScale(this.inputScale);
        int x = (int)Math.round(xpos * (double)this.inputScale.x);
        int y = (int)Math.round(((double)this.currentHeight - ypos) * (double)this.inputScale.y);
        int xDelta = x - this.mouseX;
        int yDelta = y - this.mouseY;
        this.mouseX = x;
        this.mouseY = y;
        if (xDelta != 0 || yDelta != 0) {
            MouseMotionEvent mouseMotionEvent = new MouseMotionEvent(x, y, xDelta, yDelta, this.mouseWheel, 0);
            mouseMotionEvent.setTime(this.getInputTimeNanos());
            this.mouseMotionEvents.add(mouseMotionEvent);
        }
    }

    private void onWheelScroll(long window, double xOffset, double yOffset) {
        this.mouseWheel = (int)((double)this.mouseWheel + yOffset);
        MouseMotionEvent mouseMotionEvent = new MouseMotionEvent(this.mouseX, this.mouseY, 0, 0, this.mouseWheel, (int)Math.round(yOffset));
        mouseMotionEvent.setTime(this.getInputTimeNanos());
        this.mouseMotionEvents.add(mouseMotionEvent);
    }

    private void onMouseButton(long window, int button, int action, int mods) {
        boolean pressed = action == 1;
        MouseButtonEvent mouseButtonEvent = new MouseButtonEvent(this.convertButton(button), pressed, this.mouseX, this.mouseY);
        mouseButtonEvent.setTime(this.getInputTimeNanos());
        this.mouseButtonEvents.add(mouseButtonEvent);
    }

    public void initialize() {
        this.initCallbacks();
        if (this.listener != null) {
            this.sendFirstMouseEvent();
        }
        this.setCursorVisible(this.cursorVisible);
        logger.fine("Mouse created.");
        this.initialized = true;
    }

    public void resetContext() {
        if (!this.context.isRenderable()) {
            return;
        }
        this.closeCallbacks();
        this.initCallbacks();
    }

    private void initCallbacks() {
        long window = this.context.getWindowHandle();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer width = stack.callocInt(1);
            IntBuffer height = stack.callocInt(1);
            GLFW.glfwGetWindowSize((long)window, (IntBuffer)width, (IntBuffer)height);
            width.get();
            this.currentHeight = height.get();
        }
        this.initCurrentMousePosition(window);
        this.cursorPosCallback = new GLFWCursorPosCallback(){

            public void invoke(long window, double xpos, double ypos) {
                GlfwMouseInput.this.onCursorPos(window, xpos, ypos);
            }
        };
        GLFW.glfwSetCursorPosCallback((long)window, (GLFWCursorPosCallbackI)this.cursorPosCallback);
        this.scrollCallback = new GLFWScrollCallback(){

            public void invoke(long window, double xOffset, double yOffset) {
                GlfwMouseInput.this.onWheelScroll(window, xOffset, yOffset * 120.0);
            }
        };
        GLFW.glfwSetScrollCallback((long)window, (GLFWScrollCallbackI)this.scrollCallback);
        this.mouseButtonCallback = new GLFWMouseButtonCallback(){

            public void invoke(long window, int button, int action, int mods) {
                GlfwMouseInput.this.onMouseButton(window, button, action, mods);
            }
        };
        GLFW.glfwSetMouseButtonCallback((long)window, (GLFWMouseButtonCallbackI)this.mouseButtonCallback);
        GLFW.glfwSetWindowSizeCallback((long)window, (GLFWWindowSizeCallbackI)new GLFWWindowSizeCallback(){

            public void invoke(long window, int width, int height) {
                GlfwMouseInput.this.currentHeight = height;
            }
        });
    }

    private void initCurrentMousePosition(long window) {
        double[] x = new double[1];
        double[] y = new double[1];
        GLFW.glfwGetCursorPos((long)window, (double[])x, (double[])y);
        this.context.getWindowContentScale(this.inputScale);
        this.mouseX = (int)Math.round(x[0] * (double)this.inputScale.x);
        this.mouseY = (int)Math.round(((double)this.currentHeight - y[0]) * (double)this.inputScale.y);
    }

    private void sendFirstMouseEvent() {
        assert (this.listener != null);
        int xDelta = 0;
        int yDelta = 0;
        int wheelDelta = 0;
        MouseMotionEvent evt = new MouseMotionEvent(this.mouseX, this.mouseY, xDelta, yDelta, this.mouseWheel, wheelDelta);
        evt.setTime(this.getInputTimeNanos());
        this.listener.onMouseMotionEvent(evt);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public int getButtonCount() {
        return 8;
    }

    public void update() {
        if (this.currentCursor != null && this.currentCursor.length > 1) {
            double now = GLFW.glfwGetTime();
            double frameTime = (GLFW.glfwGetTime() - this.currentCursorFrameStartTime) * 1000.0;
            if (this.currentCursorDelays == null || frameTime >= (double)this.currentCursorDelays.get(this.currentCursorFrame)) {
                ++this.currentCursorFrame;
                this.currentCursorFrame %= this.currentCursor.length;
                this.currentCursorFrameStartTime = now;
                GLFW.glfwSetCursor((long)this.context.getWindowHandle(), (long)this.currentCursor[this.currentCursorFrame]);
            }
        }
        while (!this.mouseMotionEvents.isEmpty()) {
            this.listener.onMouseMotionEvent(this.mouseMotionEvents.poll());
        }
        while (!this.mouseButtonEvents.isEmpty()) {
            this.listener.onMouseButtonEvent(this.mouseButtonEvents.poll());
        }
    }

    public void destroy() {
        if (!this.context.isRenderable()) {
            return;
        }
        this.closeCallbacks();
        this.currentCursor = null;
        this.currentCursorDelays = null;
        for (long[] glfwCursors : this.jmeToGlfwCursorMap.values()) {
            for (long glfwCursor : glfwCursors) {
                GLFW.glfwDestroyCursor((long)glfwCursor);
            }
        }
        this.jmeToGlfwCursorMap.clear();
        logger.fine("Mouse destroyed.");
    }

    private void closeCallbacks() {
        this.cursorPosCallback.close();
        this.scrollCallback.close();
        this.mouseButtonCallback.close();
    }

    public void setCursorVisible(boolean visible) {
        this.cursorVisible = visible;
        if (!this.context.isRenderable()) {
            return;
        }
        if (this.cursorVisible) {
            GLFW.glfwSetInputMode((long)this.context.getWindowHandle(), (int)208897, (int)212993);
        } else {
            GLFW.glfwSetInputMode((long)this.context.getWindowHandle(), (int)208897, (int)212995);
        }
    }

    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
        if (listener != null && this.initialized) {
            this.sendFirstMouseEvent();
        }
    }

    public long getInputTimeNanos() {
        return (long)(GLFW.glfwGetTime() * 1.0E9);
    }

    public void setNativeCursor(JmeCursor jmeCursor) {
        if (jmeCursor != null) {
            long[] glfwCursor = this.jmeToGlfwCursorMap.computeIfAbsent(jmeCursor, GlfwMouseInput::createGlfwCursor);
            this.currentCursorFrame = 0;
            this.currentCursor = glfwCursor;
            this.currentCursorDelays = null;
            this.currentCursorFrameStartTime = GLFW.glfwGetTime();
            if (jmeCursor.getImagesDelay() != null) {
                this.currentCursorDelays = jmeCursor.getImagesDelay();
            }
            GLFW.glfwSetCursor((long)this.context.getWindowHandle(), (long)glfwCursor[this.currentCursorFrame]);
        } else {
            this.currentCursor = null;
            this.currentCursorDelays = null;
            GLFW.glfwSetCursor((long)this.context.getWindowHandle(), (long)0L);
        }
    }

    private int convertButton(int glfwButton) {
        switch (glfwButton) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return glfwButton;
    }
}

