/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Device;
import com.jme3.opencl.lwjgl.LwjglPlatform;
import com.jme3.opencl.lwjgl.Utils;
import com.jme3.opencl.lwjgl.info.Info;
import java.util.Arrays;
import java.util.Collection;
import org.lwjgl.PointerBuffer;

public final class LwjglDevice
implements Device {
    final long device;
    final LwjglPlatform platform;

    public LwjglDevice(long device, LwjglPlatform platform) {
        this.device = device;
        this.platform = platform;
    }

    public long getDevice() {
        return this.device;
    }

    public LwjglPlatform getPlatform() {
        return this.platform;
    }

    public Device.DeviceType getDeviceType() {
        int type = Info.clGetDeviceInfoInt(this.device, 4096);
        switch (type) {
            case 8: {
                return Device.DeviceType.ACCELEARTOR;
            }
            case 2: {
                return Device.DeviceType.CPU;
            }
            case 4: {
                return Device.DeviceType.GPU;
            }
        }
        return Device.DeviceType.DEFAULT;
    }

    public int getVendorId() {
        return Info.clGetDeviceInfoInt(this.device, 4097);
    }

    public boolean isAvailable() {
        return Info.clGetDeviceInfoBoolean(this.device, 4135);
    }

    public boolean hasCompiler() {
        return Info.clGetDeviceInfoBoolean(this.device, 4136);
    }

    public boolean hasDouble() {
        return this.hasExtension("cl_khr_fp64");
    }

    public boolean hasHalfFloat() {
        return this.hasExtension("cl_khr_fp16");
    }

    public boolean hasErrorCorrectingMemory() {
        return Info.clGetDeviceInfoBoolean(this.device, 4132);
    }

    public boolean hasUnifiedMemory() {
        return Info.clGetDeviceInfoBoolean(this.device, 4149);
    }

    public boolean hasImageSupport() {
        return Info.clGetDeviceInfoBoolean(this.device, 4118);
    }

    public boolean hasWritableImage3D() {
        return this.hasExtension("cl_khr_3d_image_writes");
    }

    public boolean hasOpenGLInterop() {
        return this.hasExtension("cl_khr_gl_sharing");
    }

    public boolean hasExtension(String extension) {
        return this.getExtensions().contains(extension);
    }

    public Collection<? extends String> getExtensions() {
        return Arrays.asList(Info.clGetDeviceInfoStringASCII(this.device, 4144).split(" "));
    }

    public int getComputeUnits() {
        return Info.clGetDeviceInfoInt(this.device, 4098);
    }

    public int getClockFrequency() {
        return Info.clGetDeviceInfoInt(this.device, 4108);
    }

    public int getAddressBits() {
        return Info.clGetDeviceInfoInt(this.device, 4109);
    }

    public boolean isLittleEndian() {
        return Info.clGetDeviceInfoBoolean(this.device, 4134);
    }

    public long getMaximumWorkItemDimensions() {
        return Info.clGetDeviceInfoInt(this.device, 4099);
    }

    public long[] getMaximumWorkItemSizes() {
        int dim = (int)this.getMaximumWorkItemDimensions();
        PointerBuffer sizes = PointerBuffer.allocateDirect((int)dim);
        Info.clGetDeviceInfoPointers(this.device, 4101, sizes);
        long[] sx = new long[dim];
        sizes.get(sx);
        return sx;
    }

    public long getMaxiumWorkItemsPerGroup() {
        return Info.clGetDeviceInfoPointer(this.device, 4100);
    }

    public int getMaximumSamplers() {
        return Info.clGetDeviceInfoInt(this.device, 4120);
    }

    public int getMaximumReadImages() {
        return Info.clGetDeviceInfoInt(this.device, 4110);
    }

    public int getMaximumWriteImages() {
        return Info.clGetDeviceInfoInt(this.device, 4111);
    }

    public long[] getMaximumImage2DSize() {
        return new long[]{Info.clGetDeviceInfoPointer(this.device, 4113), Info.clGetDeviceInfoPointer(this.device, 4114)};
    }

    public long[] getMaximumImage3DSize() {
        return new long[]{Info.clGetDeviceInfoPointer(this.device, 4115), Info.clGetDeviceInfoPointer(this.device, 4116), Info.clGetDeviceInfoPointer(this.device, 4117)};
    }

    public long getMaximumAllocationSize() {
        return Info.clGetDeviceInfoLong(this.device, 4112);
    }

    public long getGlobalMemorySize() {
        return Info.clGetDeviceInfoLong(this.device, 4127);
    }

    public long getLocalMemorySize() {
        return Info.clGetDeviceInfoLong(this.device, 4131);
    }

    public long getMaximumConstantBufferSize() {
        return Info.clGetDeviceInfoLong(this.device, 4128);
    }

    public int getMaximumConstantArguments() {
        return Info.clGetDeviceInfoInt(this.device, 4129);
    }

    public String getProfile() {
        return Info.clGetDeviceInfoStringASCII(this.device, 4142);
    }

    public String getVersion() {
        return Info.clGetDeviceInfoStringASCII(this.device, 4143);
    }

    public int getVersionMajor() {
        return Utils.getMajorVersion(this.getVersion(), "OpenCL ");
    }

    public int getVersionMinor() {
        return Utils.getMinorVersion(this.getVersion(), "OpenCL ");
    }

    public String getCompilerVersion() {
        return Info.clGetDeviceInfoStringASCII(this.device, 4157);
    }

    public int getCompilerVersionMajor() {
        return Utils.getMajorVersion(this.getCompilerVersion(), "OpenCL C ");
    }

    public int getCompilerVersionMinor() {
        return Utils.getMinorVersion(this.getCompilerVersion(), "OpenCL C ");
    }

    public String getDriverVersion() {
        return Info.clGetDeviceInfoStringASCII(this.device, 4141);
    }

    public int getDriverVersionMajor() {
        return Utils.getMajorVersion(this.getDriverVersion(), "");
    }

    public int getDriverVersionMinor() {
        return Utils.getMinorVersion(this.getDriverVersion(), "");
    }

    public String getName() {
        return Info.clGetDeviceInfoStringASCII(this.device, 4139);
    }

    public String getVendor() {
        return Info.clGetDeviceInfoStringASCII(this.device, 4140);
    }

    public String toString() {
        return this.getName();
    }
}

