/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl.info;

import com.jme3.lwjgl3.utils.APIBuffer;
import com.jme3.lwjgl3.utils.APIUtil;
import com.jme3.opencl.lwjgl.info.CLUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

abstract class InfoQuery {
    protected abstract int get(long var1, int var3, long var4, long var6, long var8);

    InfoQuery() {
    }

    boolean getBoolean(long object, int parameterName) {
        return this.getInt(object, parameterName) != 0;
    }

    int getInt(long object, int parameterName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int errcode = this.get(object, parameterName, 4L, __buffer.address(), 0L);
        if (Checks.DEBUG) {
            CLUtil.checkCLError(errcode);
        }
        return __buffer.intValue(0);
    }

    long getLong(long object, int parameterName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int errcode = this.get(object, parameterName, 8L, __buffer.address(), 0L);
        if (Checks.DEBUG) {
            CLUtil.checkCLError(errcode);
        }
        return __buffer.longValue(0);
    }

    long getPointer(long object, int parameterName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int errcode = this.get(object, parameterName, Pointer.POINTER_SIZE, __buffer.address(), 0L);
        if (Checks.DEBUG) {
            CLUtil.checkCLError(errcode);
        }
        return __buffer.pointerValue(0);
    }

    int getPointers(long object, int parameterName, PointerBuffer target) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int errcode = this.get(object, parameterName, target.remaining() * Pointer.POINTER_SIZE, MemoryUtil.memAddress((CustomBuffer)target), __buffer.address());
        if (Checks.DEBUG) {
            CLUtil.checkCLError(errcode);
        }
        return (int)(__buffer.pointerValue(0) >> Pointer.POINTER_SHIFT);
    }

    String getStringASCII(long object, int parameterName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int bytes = this.getString(object, parameterName, __buffer);
        return __buffer.stringValueASCII(0, bytes);
    }

    String getStringASCII(long object, int parameterName, int parameterValueSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int errcode = this.get(object, parameterName, parameterValueSize, __buffer.address(), 0L);
        if (Checks.DEBUG) {
            CLUtil.checkCLError(errcode);
        }
        return __buffer.stringValueASCII(0, parameterValueSize);
    }

    String getStringUTF8(long object, int parameterName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int bytes = this.getString(object, parameterName, __buffer);
        return __buffer.stringValueUTF8(0, bytes);
    }

    String getStringUTF8(long object, int parameterName, int parameterValueSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int errcode = this.get(object, parameterName, parameterValueSize, __buffer.address(), 0L);
        if (Checks.DEBUG) {
            CLUtil.checkCLError(errcode);
        }
        return __buffer.stringValueUTF8(0, parameterValueSize);
    }

    private int getString(long object, int parameterName, APIBuffer buffer) {
        int errcode = this.get(object, parameterName, 0L, 0L, buffer.address());
        if (Checks.DEBUG) {
            CLUtil.checkCLError(errcode);
        }
        int bytes = (int)buffer.pointerValue(0);
        buffer.bufferParam(bytes);
        errcode = this.get(object, parameterName, bytes, buffer.address(), 0L);
        if (Checks.DEBUG) {
            CLUtil.checkCLError(errcode);
        }
        return bytes - 1;
    }
}

