/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Device;
import com.jme3.opencl.Kernel;
import com.jme3.opencl.KernelCompilationException;
import com.jme3.opencl.OpenCLException;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.Program;
import com.jme3.opencl.lwjgl.LwjglContext;
import com.jme3.opencl.lwjgl.LwjglDevice;
import com.jme3.opencl.lwjgl.LwjglKernel;
import com.jme3.opencl.lwjgl.Utils;
import com.jme3.opencl.lwjgl.info.Info;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;
import org.lwjgl.system.MemoryUtil;

public class LwjglProgram
extends Program {
    private static final Logger LOG = Logger.getLogger(LwjglProgram.class.getName());
    private final long program;
    private final LwjglContext context;

    public LwjglProgram(long program, LwjglContext context) {
        super((OpenCLObject.ObjectReleaser)new ReleaserImpl(program));
        this.program = program;
        this.context = context;
    }

    public long getProgram() {
        return this.program;
    }

    public void build(String args, Device ... devices) throws KernelCompilationException {
        int ret;
        PointerBuffer deviceList = null;
        if (devices != null) {
            deviceList = PointerBuffer.allocateDirect((int)devices.length);
            deviceList.rewind();
            for (Device d : devices) {
                deviceList.put(((LwjglDevice)d).getDevice());
            }
            deviceList.flip();
        }
        if ((ret = CL10.clBuildProgram((long)this.program, (PointerBuffer)deviceList, (CharSequence)args, null, (long)0L)) != 0) {
            String log = this.Log();
            LOG.log(Level.WARNING, "Unable to compile program:\n{0}", log);
            if (ret == -11) {
                throw new KernelCompilationException("Failed to build program", ret, log);
            }
            Utils.checkError(ret, "clBuildProgram");
        } else {
            LOG.log(Level.INFO, "Program compiled:\n{0}", this.Log());
        }
    }

    private String Log(long device) {
        Utils.pointerBuffers[0].rewind();
        int ret = CL10.clGetProgramBuildInfo((long)this.program, (long)device, (int)4483, (ByteBuffer)null, (PointerBuffer)Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clGetProgramBuildInfo");
        int count = (int)Utils.pointerBuffers[0].get(0);
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)count);
        ret = CL10.clGetProgramBuildInfo((long)this.program, (long)device, (int)4483, (ByteBuffer)buffer, null);
        Utils.checkError(ret, "clGetProgramBuildInfo");
        return MemoryUtil.memASCII((ByteBuffer)buffer);
    }

    private String Log() {
        StringBuilder str = new StringBuilder();
        for (LwjglDevice device : this.context.getDevices()) {
            long d = device.getDevice();
            str.append(device.getName()).append(":\n");
            str.append(this.Log(d));
            str.append('\n');
        }
        return str.toString();
    }

    public Kernel createKernel(String name) {
        long kernel = CL10.clCreateKernel((long)this.program, (CharSequence)name, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateKernel");
        return new LwjglKernel(kernel);
    }

    public Kernel[] createAllKernels() {
        Utils.tempBuffers[0].b16i.rewind();
        int ret = CL10.clCreateKernelsInProgram((long)this.program, null, (IntBuffer)Utils.tempBuffers[0].b16i);
        Utils.checkError(ret, "clCreateKernelsInProgram");
        int count = Utils.tempBuffers[0].b16i.get(0);
        PointerBuffer buf = PointerBuffer.allocateDirect((int)count);
        ret = CL10.clCreateKernelsInProgram((long)this.program, (PointerBuffer)buf, (IntBuffer)null);
        Utils.checkError(ret, "clCreateKernelsInProgram");
        Kernel[] kx = new Kernel[count];
        for (int i = 0; i < count; ++i) {
            kx[i] = new LwjglKernel(buf.get());
        }
        return kx;
    }

    public ByteBuffer getBinary(Device d) {
        LwjglDevice device = (LwjglDevice)d;
        int numDevices = Info.clGetProgramInfoInt(this.program, 4450);
        PointerBuffer devices = PointerBuffer.allocateDirect((int)numDevices);
        int ret = CL10.clGetProgramInfo((long)this.program, (int)4451, (PointerBuffer)devices, null);
        Utils.checkError(ret, "clGetProgramInfo: CL_PROGRAM_DEVICES");
        int index = -1;
        for (int i = 0; i < numDevices; ++i) {
            if (devices.get(i) != device.getDevice()) continue;
            index = i;
        }
        if (index == -1) {
            throw new OpenCLException("Program was not built against the specified device " + device);
        }
        PointerBuffer sizes = PointerBuffer.allocateDirect((int)numDevices);
        ret = CL10.clGetProgramInfo((long)this.program, (int)4453, (PointerBuffer)sizes, null);
        Utils.checkError(ret, "clGetProgramInfo: CL_PROGRAM_BINARY_SIZES");
        int size = (int)sizes.get(index);
        PointerBuffer binaryPointers = PointerBuffer.allocateDirect((int)numDevices);
        for (int i = 0; i < binaryPointers.capacity(); ++i) {
            binaryPointers.put(0L);
        }
        binaryPointers.rewind();
        ByteBuffer binaries = ByteBuffer.allocateDirect(size);
        binaryPointers.put(index, binaries);
        ret = CL10.clGetProgramInfo((long)this.program, (int)4454, (PointerBuffer)binaryPointers, null);
        Utils.checkError(ret, "clGetProgramInfo: CL_PROGRAM_BINARIES");
        return binaries;
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private long program;

        private ReleaserImpl(long program) {
            this.program = program;
        }

        public void release() {
            if (this.program != 0L) {
                int ret = CL10.clReleaseProgram((long)this.program);
                this.program = 0L;
                Utils.reportError(ret, "clReleaseProgram");
            }
        }
    }
}

