/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.kernel.udp;

import com.jme3.network.kernel.Connector;
import com.jme3.network.kernel.ConnectorException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class UdpConnector
implements Connector {
    private DatagramSocket sock = new DatagramSocket();
    private SocketAddress remoteAddress;
    private byte[] buffer = new byte[65535];
    private AtomicBoolean connected = new AtomicBoolean(false);
    private DatagramPacket pending;

    public UdpConnector(InetAddress remote, int remotePort) throws IOException {
        InetSocketAddress localSocketAddress = new InetSocketAddress(0);
        this.sock = new DatagramSocket(localSocketAddress);
        this.remoteAddress = new InetSocketAddress(remote, remotePort);
        this.sock.connect(this.remoteAddress);
        this.connected.set(true);
    }

    protected void checkClosed() {
        if (this.sock == null) {
            throw new ConnectorException("Connection is closed:" + this.remoteAddress);
        }
    }

    @Override
    public boolean isConnected() {
        if (this.sock == null) {
            return false;
        }
        return this.sock.isConnected();
    }

    @Override
    public void close() {
        this.checkClosed();
        DatagramSocket temp = this.sock;
        this.sock = null;
        this.connected.set(false);
        temp.close();
    }

    @Override
    public boolean available() {
        this.checkClosed();
        return false;
    }

    @Override
    public ByteBuffer read() {
        this.checkClosed();
        try {
            DatagramPacket packet = new DatagramPacket(this.buffer, this.buffer.length);
            this.sock.receive(packet);
            return ByteBuffer.wrap(this.buffer, 0, packet.getLength());
        }
        catch (IOException e) {
            if (!this.connected.get()) {
                return null;
            }
            throw new ConnectorException("Error reading from connection to:" + this.remoteAddress, e);
        }
    }

    @Override
    public void write(ByteBuffer data) {
        this.checkClosed();
        try {
            DatagramPacket p = new DatagramPacket(data.array(), data.position(), data.remaining(), this.remoteAddress);
            this.sock.send(p);
        }
        catch (IOException e) {
            throw new ConnectorException("Error writing to connection:" + this.remoteAddress, e);
        }
    }
}

