/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.kernel.udp;

import com.jme3.network.Filter;
import com.jme3.network.kernel.AbstractKernel;
import com.jme3.network.kernel.Endpoint;
import com.jme3.network.kernel.EndpointEvent;
import com.jme3.network.kernel.Envelope;
import com.jme3.network.kernel.KernelException;
import com.jme3.network.kernel.NamedThreadFactory;
import com.jme3.network.kernel.udp.UdpEndpoint;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UdpKernel
extends AbstractKernel {
    static Logger log = Logger.getLogger(UdpKernel.class.getName());
    private InetSocketAddress address;
    private HostThread thread;
    private ExecutorService writer;
    private Map<SocketAddress, UdpEndpoint> socketEndpoints = new ConcurrentHashMap<SocketAddress, UdpEndpoint>();

    public UdpKernel(InetAddress host, int port) {
        this(new InetSocketAddress(host, port));
    }

    public UdpKernel(int port) throws IOException {
        this(new InetSocketAddress(port));
    }

    public UdpKernel(InetSocketAddress address) {
        this.address = address;
    }

    protected HostThread createHostThread() {
        return new HostThread();
    }

    @Override
    public void initialize() {
        if (this.thread != null) {
            throw new IllegalStateException("Kernel already initialized.");
        }
        this.writer = Executors.newFixedThreadPool(2, new NamedThreadFactory(this.toString() + "-writer"));
        this.thread = this.createHostThread();
        try {
            this.thread.connect();
            this.thread.start();
        }
        catch (IOException e) {
            throw new KernelException("Error hosting:" + this.address, e);
        }
    }

    @Override
    public void terminate() throws InterruptedException {
        if (this.thread == null) {
            throw new IllegalStateException("Kernel not initialized.");
        }
        try {
            this.thread.close();
            this.writer.shutdown();
            this.thread = null;
            this.wakeupReader();
        }
        catch (IOException e) {
            throw new KernelException("Error closing host connection:" + this.address, e);
        }
    }

    @Override
    public void broadcast(Filter<? super Endpoint> filter, ByteBuffer data, boolean reliable, boolean copy) {
        if (reliable) {
            throw new UnsupportedOperationException("Reliable send not supported by this kernel.");
        }
        if (copy) {
            byte[] temp = new byte[data.remaining()];
            System.arraycopy(data.array(), data.position(), temp, 0, data.remaining());
            data = ByteBuffer.wrap(temp);
        }
        for (UdpEndpoint p : this.socketEndpoints.values()) {
            if (filter != null && !filter.apply(p)) continue;
            p.send(data);
        }
    }

    protected Endpoint getEndpoint(SocketAddress address, boolean create) {
        UdpEndpoint p = this.socketEndpoints.get(address);
        if (p == null && create) {
            p = new UdpEndpoint(this, this.nextEndpointId(), address, this.thread.getSocket());
            this.socketEndpoints.put(address, p);
            this.addEvent(EndpointEvent.createAdd(this, p));
        }
        return p;
    }

    protected void closeEndpoint(UdpEndpoint p) throws IOException {
        if (this.socketEndpoints.remove(p.getRemoteAddress()) == null) {
            return;
        }
        log.log(Level.FINE, "Closing endpoint:{0}.", p);
        log.log(Level.FINE, "Socket endpoints size:{0}", this.socketEndpoints.size());
        this.addEvent(EndpointEvent.createRemove(this, p));
        this.wakeupReader();
    }

    protected void newData(DatagramPacket packet) {
        Endpoint p = this.getEndpoint(packet.getSocketAddress(), true);
        byte[] data = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), 0, data, 0, data.length);
        Envelope env = new Envelope(p, data, false);
        this.addEnvelope(env);
    }

    protected void enqueueWrite(Endpoint endpoint, DatagramPacket packet) {
        this.writer.execute(new MessageWriter(endpoint, packet));
    }

    protected class HostThread
    extends Thread {
        private DatagramSocket socket;
        private AtomicBoolean go = new AtomicBoolean(true);
        private byte[] buffer = new byte[65535];

        public HostThread() {
            this.setName("UDP Host@" + UdpKernel.this.address);
            this.setDaemon(true);
        }

        protected DatagramSocket getSocket() {
            return this.socket;
        }

        public void connect() throws IOException {
            this.socket = new DatagramSocket(UdpKernel.this.address);
            log.log(Level.FINE, "Hosting UDP connection:{0}.", UdpKernel.this.address);
        }

        public void close() throws IOException, InterruptedException {
            this.go.set(false);
            this.socket.close();
            this.join();
        }

        @Override
        public void run() {
            log.log(Level.FINE, "Kernel started for connection:{0}.", UdpKernel.this.address);
            while (this.go.get()) {
                try {
                    DatagramPacket packet = new DatagramPacket(this.buffer, this.buffer.length);
                    this.socket.receive(packet);
                    UdpKernel.this.newData(packet);
                }
                catch (IOException e) {
                    if (!this.go.get()) {
                        return;
                    }
                    UdpKernel.this.reportError(e);
                }
            }
        }
    }

    protected class MessageWriter
    implements Runnable {
        private Endpoint endpoint;
        private DatagramPacket packet;

        public MessageWriter(Endpoint endpoint, DatagramPacket packet) {
            this.endpoint = endpoint;
            this.packet = packet;
        }

        @Override
        public void run() {
            if (!this.endpoint.isConnected()) {
                return;
            }
            try {
                UdpKernel.this.thread.getSocket().send(this.packet);
            }
            catch (Exception e) {
                KernelException exc = new KernelException("Error sending datagram to:" + UdpKernel.this.address, e);
                exc.fillInStackTrace();
                UdpKernel.this.reportError(exc);
            }
        }
    }
}

