/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.util;

import com.jme3.network.Message;
import com.jme3.network.MessageConnection;
import com.jme3.network.MessageListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractMessageDelegator<S extends MessageConnection>
implements MessageListener<S> {
    static final Logger log = Logger.getLogger(AbstractMessageDelegator.class.getName());
    private Class delegateType;
    private Map<Class, Method> methods = new HashMap<Class, Method>();
    private Class[] messageTypes;

    protected AbstractMessageDelegator(Class delegateType, boolean automap) {
        this.delegateType = delegateType;
        if (automap) {
            this.automap();
        }
    }

    public Class[] getMessageTypes() {
        if (this.messageTypes == null) {
            this.messageTypes = this.methods.keySet().toArray(new Class[this.methods.size()]);
        }
        return this.messageTypes;
    }

    protected boolean isValidMethod(Method m, Class messageType) {
        Class<?>[] parms;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "isValidMethod({0}, {1})", new Object[]{m, messageType});
        }
        if ((parms = m.getParameterTypes()).length != 2 && parms.length != 1) {
            log.finest("Parameter count is not 1 or 2");
            return false;
        }
        int messageIndex = 0;
        if (parms.length > 1) {
            if (MessageConnection.class.isAssignableFrom(parms[0])) {
                ++messageIndex;
            } else {
                log.finest("First parameter is not a MessageConnection or subclass.");
                return false;
            }
        }
        if (messageType == null && !Message.class.isAssignableFrom(parms[messageIndex])) {
            log.finest("Second parameter is not a Message or subclass.");
            return false;
        }
        if (messageType != null && !parms[messageIndex].isAssignableFrom(messageType)) {
            log.log(Level.FINEST, "Second parameter is not a {0}", messageType);
            return false;
        }
        return true;
    }

    protected Class getMessageType(Method m) {
        Class<?>[] parms = m.getParameterTypes();
        return parms[parms.length - 1];
    }

    protected Method findDelegate(String name, Class messageType) {
        for (Method m : this.delegateType.getDeclaredMethods()) {
            if (!m.getName().equals(name) || !this.isValidMethod(m, messageType)) continue;
            return m;
        }
        return null;
    }

    protected boolean allowName(String name) {
        return true;
    }

    protected final void automap() {
        this.map((Set<String>)null);
        if (this.methods.isEmpty()) {
            throw new RuntimeException("No message handling methods found for class:" + this.delegateType);
        }
    }

    public AbstractMessageDelegator<S> map(String ... methodNames) {
        HashSet<String> names = new HashSet<String>(Arrays.asList(methodNames));
        this.map(names);
        return this;
    }

    protected void map(Set<String> constraints) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "map({0})", constraints);
        }
        for (Method m : this.delegateType.getDeclaredMethods()) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Checking method:{0}", m);
            }
            if (constraints == null && !this.allowName(m.getName())) {
                log.finest("Name is not allowed.");
                continue;
            }
            if (constraints != null && !constraints.contains(m.getName())) {
                log.finest("Name is not in constraints set.");
                continue;
            }
            if (!this.isValidMethod(m, null)) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Adding method mapping:{0} = {1}", new Object[]{this.getMessageType(m), m});
            }
            m.setAccessible(true);
            this.methods.put(this.getMessageType(m), m);
        }
        this.messageTypes = null;
    }

    public AbstractMessageDelegator<S> map(Class messageType, String methodName) {
        Method m = this.findDelegate(methodName, messageType);
        if (m == null) {
            throw new RuntimeException("Method:" + methodName + " not found matching signature (MessageConnection, " + messageType.getName() + ")");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Adding method mapping:{0} = {1}", new Object[]{messageType, m});
        }
        this.methods.put(messageType, m);
        this.messageTypes = null;
        return this;
    }

    protected Method getMethod(Class c) {
        Method m = this.methods.get(c);
        return m;
    }

    protected abstract Object getSourceDelegate(S var1);

    @Override
    public void messageReceived(S source, Message msg) {
        if (msg == null) {
            return;
        }
        Object delegate = this.getSourceDelegate(source);
        if (delegate == null) {
            return;
        }
        Method m = this.getMethod(msg.getClass());
        if (m == null) {
            throw new RuntimeException("Delegate method not found for message class:" + msg.getClass());
        }
        try {
            if (m.getParameterTypes().length > 1) {
                m.invoke(delegate, source, msg);
            } else {
                m.invoke(delegate, msg);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error executing:" + m, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error executing:" + m, e.getCause());
        }
    }
}

