/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service.rpc;

import com.jme3.network.HostedConnection;
import com.jme3.network.Server;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.rpc.RpcConnection;
import com.jme3.network.service.rpc.msg.RpcCallMessage;
import com.jme3.network.service.rpc.msg.RpcResponseMessage;
import com.jme3.network.util.SessionDataDelegator;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcHostedService
extends AbstractHostedConnectionService {
    private static final String ATTRIBUTE_NAME = "rpcSession";
    private static final Logger log = Logger.getLogger(RpcHostedService.class.getName());
    private SessionDataDelegator delegator;

    public RpcHostedService() {
        this(true);
    }

    public RpcHostedService(boolean autoHost) {
        super(autoHost);
        Serializer.registerClasses(RpcCallMessage.class, RpcResponseMessage.class);
    }

    @Override
    protected void onInitialize(HostedServiceManager serviceManager) {
        Server server = serviceManager.getServer();
        this.delegator = new SessionDataDelegator(RpcConnection.class, ATTRIBUTE_NAME, true);
        server.addMessageListener(this.delegator, this.delegator.getMessageTypes());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Registered delegator for message types:{0}", Arrays.asList(this.delegator.getMessageTypes()));
        }
    }

    public RpcConnection getRpcConnection(HostedConnection hc) {
        return (RpcConnection)hc.getAttribute(ATTRIBUTE_NAME);
    }

    @Override
    public void startHostingOnConnection(HostedConnection hc) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "startHostingOnConnection:{0}", hc);
        }
        hc.setAttribute(ATTRIBUTE_NAME, new RpcConnection(hc));
    }

    @Override
    public void stopHostingOnConnection(HostedConnection hc) {
        RpcConnection rpc = (RpcConnection)hc.getAttribute(ATTRIBUTE_NAME);
        if (rpc == null) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "stopHostingOnConnection:{0}", hc);
        }
        hc.setAttribute(ATTRIBUTE_NAME, null);
        rpc.close();
    }

    @Override
    public void terminate(HostedServiceManager serviceManager) {
        Server server = serviceManager.getServer();
        server.removeMessageListener(this.delegator, this.delegator.getMessageTypes());
    }
}

