/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.message;

import com.jme3.network.AbstractMessage;
import com.jme3.network.serializing.Serializable;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.serializing.serializers.StringSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;

@Serializable
public class DisconnectMessage
extends AbstractMessage {
    public static final short SERIALIZER_ID = -42;
    public static final String KICK = "Kick";
    public static final String USER_REQUESTED = "User requested";
    public static final String ERROR = "Error";
    public static final String FILTERED = "Filtered";
    private String reason;
    private String type;

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return this.getClass().getName() + "[reason=" + this.reason + ", type=" + this.type + "]";
    }

    public static class DisconnectSerializer
    extends Serializer {
        public DisconnectMessage readObject(ByteBuffer data, Class c) throws IOException {
            if (data.get() == 0) {
                return null;
            }
            DisconnectMessage msg = new DisconnectMessage();
            msg.reason = StringSerializer.readString(data);
            msg.type = StringSerializer.readString(data);
            return msg;
        }

        @Override
        public void writeObject(ByteBuffer buffer, Object object) throws IOException {
            buffer.put((byte)(object != null ? 1 : 0));
            if (object == null) {
                return;
            }
            DisconnectMessage msg = (DisconnectMessage)object;
            StringSerializer.writeString(msg.reason, buffer);
            StringSerializer.writeString(msg.type, buffer);
        }
    }
}

