/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.serializing.serializers;

import com.jme3.network.serializing.Serializer;
import com.jme3.network.serializing.SerializerException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldSerializer
extends Serializer {
    private static final Logger log = Logger.getLogger(FieldSerializer.class.getName());
    private static Map<Class, SavedField[]> savedFields = new HashMap<Class, SavedField[]>();
    private static Map<Class, Constructor> savedCtors = new HashMap<Class, Constructor>();

    protected void checkClass(Class clazz) {
        try {
            savedCtors.put(clazz, clazz.getConstructor(new Class[0]));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Constructor ctor = clazz.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                savedCtors.put(clazz, ctor);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new RuntimeException("Registration error: no-argument constructor not found on:" + clazz);
            }
        }
    }

    @Override
    public void initialize(Class clazz) {
        this.checkClass(clazz);
        ArrayList fields = new ArrayList();
        for (Class processingClass = clazz; processingClass != Object.class; processingClass = processingClass.getSuperclass()) {
            Collections.addAll(fields, processingClass.getDeclaredFields());
        }
        ArrayList<SavedField> cachedFields = new ArrayList<SavedField>(fields.size());
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || field.isSynthetic()) continue;
            field.setAccessible(true);
            SavedField cachedField = new SavedField();
            cachedField.field = field;
            if (Modifier.isFinal(field.getType().getModifiers())) {
                cachedField.serializer = Serializer.getSerializer(field.getType(), false);
            }
            cachedFields.add(cachedField);
        }
        Collections.sort(cachedFields, new Comparator<SavedField>(){

            @Override
            public int compare(SavedField o1, SavedField o2) {
                return o1.field.getName().compareTo(o2.field.getName());
            }
        });
        savedFields.put(clazz, cachedFields.toArray(new SavedField[cachedFields.size()]));
    }

    @Override
    public <T> T readObject(ByteBuffer data, Class<T> c) throws IOException {
        Object object;
        if (data.get() == 0) {
            return null;
        }
        SavedField[] fields = savedFields.get(c);
        try {
            Constructor ctor = savedCtors.get(c);
            object = ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SerializerException("Error creating object of type:" + c, e);
        }
        for (SavedField savedField : fields) {
            Field field = savedField.field;
            Serializer serializer = savedField.serializer;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Reading field:{0} using serializer:{1}", new Object[]{field, serializer});
            }
            Object value = serializer != null ? serializer.readObject(data, field.getType()) : Serializer.readClassAndObject(data);
            try {
                field.set(object, value);
            }
            catch (IllegalAccessException e) {
                throw new SerializerException("Error reading object", e);
            }
        }
        return object;
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        buffer.put((byte)(object != null ? 1 : 0));
        if (object == null) {
            return;
        }
        SavedField[] fields = savedFields.get(object.getClass());
        if (fields == null) {
            throw new IOException("The " + object.getClass() + " is not registered in the serializer!");
        }
        for (SavedField savedField : fields) {
            Object val = null;
            try {
                val = savedField.field.get(object);
            }
            catch (IllegalAccessException e) {
                throw new SerializerException("Unable to access field:" + savedField.field + " on:" + object, e);
            }
            Serializer serializer = savedField.serializer;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Writing field:{0} using serializer:{1}", new Object[]{savedField.field, serializer});
            }
            try {
                if (serializer != null) {
                    serializer.writeObject(buffer, val);
                    continue;
                }
                Serializer.writeClassAndObject(buffer, val);
            }
            catch (BufferOverflowException boe) {
                throw boe;
            }
            catch (Exception e) {
                throw new SerializerException("Error writing object for field:" + savedField.field, e);
            }
        }
    }

    private final class SavedField {
        public Field field;
        public Serializer serializer;

        private SavedField() {
        }
    }
}

