/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.niftygui;

import com.jme3.input.InputManager;
import com.jme3.input.RawInputListener;
import com.jme3.input.SoftTextDialogInput;
import com.jme3.input.controls.SoftTextDialogInputListener;
import com.jme3.input.event.InputEvent;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.input.event.TouchEvent;
import com.jme3.system.JmeSystem;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyInputConsumer;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import de.lessvoid.nifty.spi.input.InputSystem;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InputSystemJme
implements InputSystem,
RawInputListener {
    private final ArrayList<InputEvent> inputQueue = new ArrayList();
    private InputManager inputManager;
    private boolean[] niftyOwnsDragging = new boolean[3];
    private int inputPointerId = -1;
    private int x;
    private int y;
    private int height;
    private boolean shiftDown = false;
    private boolean ctrlDown = false;
    private Nifty nifty;

    public InputSystemJme(InputManager inputManager) {
        this.inputManager = inputManager;
    }

    public void setResourceLoader(NiftyResourceLoader niftyResourceLoader) {
    }

    public void setNifty(Nifty nifty) {
        this.nifty = nifty;
    }

    public void reset() {
        this.x = 0;
        this.y = 0;
        this.inputPointerId = -1;
        for (int i = 0; i < this.niftyOwnsDragging.length; ++i) {
            this.niftyOwnsDragging[i] = false;
        }
        this.shiftDown = false;
        this.ctrlDown = false;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setMousePosition(int x, int y) {
    }

    public void beginInput() {
    }

    public void endInput() {
        boolean result = this.nifty.update();
    }

    private void handleMouseEvent(int button, boolean value, NiftyInputConsumer nic, InputEvent evt) {
        if (value) {
            boolean consumed;
            this.niftyOwnsDragging[button] = consumed = nic.processMouseEvent(this.x, this.y, 0, button, true) | this.nifty.getCurrentScreen().isMouseOverElement();
            if (consumed) {
                evt.setConsumed();
            }
        } else {
            boolean consumed = nic.processMouseEvent(this.x, this.y, 0, button, false);
            if (this.niftyOwnsDragging[button] && consumed) {
                evt.setConsumed();
                this.processSoftKeyboard();
            }
            this.niftyOwnsDragging[button] = false;
        }
    }

    private void onTouchEventQueued(TouchEvent evt, NiftyInputConsumer nic) {
        if (this.inputManager.isSimulateMouse()) {
            return;
        }
        this.x = (int)evt.getX();
        this.y = (int)((float)this.height - evt.getY());
        switch (evt.getType()) {
            case DOWN: {
                if (this.inputPointerId != -1) break;
                this.inputPointerId = evt.getPointerId();
                this.handleMouseEvent(0, true, nic, (InputEvent)evt);
                break;
            }
            case UP: {
                if (this.inputPointerId != evt.getPointerId()) break;
                this.inputPointerId = -1;
                this.handleMouseEvent(0, false, nic, (InputEvent)evt);
            }
        }
    }

    private void onMouseMotionEventQueued(MouseMotionEvent evt, NiftyInputConsumer nic) {
        int wheel = evt.getDeltaWheel() / 120;
        this.x = evt.getX();
        this.y = this.height - evt.getY();
        nic.processMouseEvent(this.x, this.y, wheel, -1, false);
    }

    private void onMouseButtonEventQueued(MouseButtonEvent evt, NiftyInputConsumer nic) {
        this.x = evt.getX();
        this.y = this.height - evt.getY();
        this.handleMouseEvent(evt.getButtonIndex(), evt.isPressed(), nic, (InputEvent)evt);
    }

    private void onKeyEventQueued(KeyInputEvent evt, NiftyInputConsumer nic) {
        int code = evt.getKeyCode();
        if (code == 42 || code == 54) {
            this.shiftDown = evt.isPressed();
        } else if (code == 29 || code == 157) {
            this.ctrlDown = evt.isPressed();
        }
        KeyboardInputEvent keyEvt = new KeyboardInputEvent(code, evt.getKeyChar(), evt.isPressed(), this.shiftDown, this.ctrlDown);
        if (nic.processKeyboardEvent(keyEvt)) {
            evt.setConsumed();
        }
    }

    public void onMouseMotionEvent(MouseMotionEvent evt) {
        if (this.inputManager.isCursorVisible() && (evt.getDX() != 0 || evt.getDY() != 0 || evt.getDeltaWheel() != 0)) {
            this.inputQueue.add((InputEvent)evt);
        }
    }

    public void onMouseButtonEvent(MouseButtonEvent evt) {
        if (evt.getButtonIndex() >= 0 && evt.getButtonIndex() <= 2 && (evt.isReleased() || this.inputManager.isCursorVisible())) {
            this.inputQueue.add((InputEvent)evt);
        }
    }

    public void onJoyAxisEvent(JoyAxisEvent evt) {
    }

    public void onJoyButtonEvent(JoyButtonEvent evt) {
    }

    public void onKeyEvent(KeyInputEvent evt) {
        this.inputQueue.add((InputEvent)evt);
    }

    public void onTouchEvent(TouchEvent evt) {
        this.inputQueue.add((InputEvent)evt);
    }

    public void forwardEvents(NiftyInputConsumer nic) {
        int queueSize = this.inputQueue.size();
        for (int i = 0; i < queueSize; ++i) {
            InputEvent evt = this.inputQueue.get(i);
            if (evt instanceof MouseMotionEvent) {
                this.onMouseMotionEventQueued((MouseMotionEvent)evt, nic);
                continue;
            }
            if (evt instanceof MouseButtonEvent) {
                this.onMouseButtonEventQueued((MouseButtonEvent)evt, nic);
                continue;
            }
            if (evt instanceof KeyInputEvent) {
                this.onKeyEventQueued((KeyInputEvent)evt, nic);
                continue;
            }
            if (!(evt instanceof TouchEvent)) continue;
            this.onTouchEventQueued((TouchEvent)evt, nic);
        }
        this.inputQueue.clear();
    }

    private void processSoftKeyboard() {
        TextField textField;
        Element element;
        SoftTextDialogInput softTextDialogInput = JmeSystem.getSoftTextDialogInput();
        if (softTextDialogInput != null && (element = this.nifty.getCurrentScreen().getFocusHandler().getKeyboardFocusElement()) != null && (textField = (TextField)element.getNiftyControl(TextField.class)) != null) {
            Logger.getLogger(InputSystemJme.class.getName()).log(Level.FINE, "Current TextField: {0}", textField.getId());
            String initialValue = textField.getRealText();
            if (initialValue == null) {
                initialValue = "";
            }
            softTextDialogInput.requestDialog(0, "Enter Text", initialValue, new SoftTextDialogInputListener(){

                public void onSoftText(int action, String text) {
                    if (action == 0) {
                        textField.setText((CharSequence)text);
                    }
                }
            });
        }
    }
}

