/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.niftygui;

import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioNode;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.AudioSource;
import de.lessvoid.nifty.spi.sound.SoundHandle;

public class SoundHandleJme
implements SoundHandle {
    private AudioNode node;
    private AssetManager am;
    private String fileName;
    private float volume = 1.0f;

    public SoundHandleJme(AudioRenderer ar, AudioNode node) {
        if (ar == null || node == null) {
            throw new NullPointerException();
        }
        this.node = node;
    }

    public SoundHandleJme(AudioRenderer ar, AssetManager am, String fileName) {
        if (ar == null || am == null) {
            throw new NullPointerException();
        }
        this.am = am;
        if (fileName == null) {
            throw new NullPointerException();
        }
        this.fileName = fileName;
    }

    public void play() {
        if (this.fileName != null) {
            if (this.node != null) {
                this.node.stop();
            }
            this.node = new AudioNode(this.am, this.fileName, AudioData.DataType.Stream);
            this.node.setPositional(false);
            this.node.setVolume(this.volume);
            this.node.play();
        } else {
            this.node.playInstance();
        }
    }

    public void stop() {
        if (this.node != null) {
            this.node.stop();
            if (this.fileName != null) {
                this.node = null;
            }
        }
    }

    public void setVolume(float f) {
        if (this.node != null) {
            this.node.setVolume(f);
        }
        this.volume = f;
    }

    public float getVolume() {
        return this.volume;
    }

    public boolean isPlaying() {
        return this.node != null && this.node.getStatus() == AudioSource.Status.Playing;
    }

    public void dispose() {
    }
}

