/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.niftygui;

import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.niftygui.NiftyJmeDisplay;
import com.jme3.niftygui.RenderFontJme;
import com.jme3.niftygui.RenderImageJme;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import de.lessvoid.nifty.render.BlendMode;
import de.lessvoid.nifty.spi.render.MouseCursor;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.spi.render.RenderImage;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;

public class RenderDeviceJme
implements RenderDevice {
    private final NiftyJmeDisplay display;
    private RenderManager rm;
    private Renderer r;
    private Map<CachedTextKey, BitmapText> textCacheLastFrame = new HashMap<CachedTextKey, BitmapText>();
    private Map<CachedTextKey, BitmapText> textCacheCurrentFrame = new HashMap<CachedTextKey, BitmapText>();
    private final Quad quad = new Quad(1.0f, -1.0f, true);
    private final Geometry quadGeom = new Geometry("nifty-quad", (Mesh)this.quad);
    private boolean clipWasSet = false;
    private final VertexBuffer quadDefaultTC = this.quad.getBuffer(VertexBuffer.Type.TexCoord);
    private final VertexBuffer quadModTC = this.quadDefaultTC.clone();
    private final VertexBuffer quadColor;
    private final Matrix4f tempMat = new Matrix4f();
    private final ColorRGBA tempColor = new ColorRGBA();
    private final RenderState renderState = new RenderState();
    private final Material colorMaterial;
    private final Material textureColorMaterial;
    private final Material vertexColorMaterial;

    public RenderDeviceJme(NiftyJmeDisplay display) {
        this.display = display;
        this.quadColor = new VertexBuffer(VertexBuffer.Type.Color);
        this.quadColor.setNormalized(true);
        ByteBuffer bb = BufferUtils.createByteBuffer((int)16);
        this.quadColor.setupData(VertexBuffer.Usage.Stream, 4, VertexBuffer.Format.UnsignedByte, (Buffer)bb);
        this.quad.setBuffer(this.quadColor);
        this.quadModTC.setUsage(VertexBuffer.Usage.Stream);
        this.colorMaterial = new Material(display.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        this.textureColorMaterial = new Material(display.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        this.vertexColorMaterial = new Material(display.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        this.vertexColorMaterial.setBoolean("VertexColor", true);
        this.renderState.setDepthTest(false);
        this.renderState.setDepthWrite(false);
    }

    public void setResourceLoader(NiftyResourceLoader niftyResourceLoader) {
    }

    public void setRenderManager(RenderManager rm) {
        this.rm = rm;
        this.r = rm.getRenderer();
    }

    public MouseCursor createMouseCursor(String str, int x, int y) {
        return new MouseCursor(){

            public void dispose() {
            }

            public void enable() {
            }

            public void disable() {
            }
        };
    }

    public void enableMouseCursor(MouseCursor cursor) {
    }

    public void disableMouseCursor() {
    }

    public RenderImage createImage(String filename, boolean linear) {
        return new RenderImageJme(filename, linear, this.display);
    }

    public RenderFont createFont(String filename) {
        return new RenderFontJme(filename, this.display);
    }

    public void beginFrame() {
    }

    public void endFrame() {
        Map<CachedTextKey, BitmapText> temp = this.textCacheLastFrame;
        this.textCacheLastFrame = this.textCacheCurrentFrame;
        this.textCacheCurrentFrame = temp;
        this.textCacheCurrentFrame.clear();
        this.rm.setForcedRenderState(null);
    }

    public int getWidth() {
        return this.display.getWidth();
    }

    public int getHeight() {
        return this.display.getHeight();
    }

    public void clear() {
    }

    public void setBlendMode(BlendMode blendMode) {
        this.renderState.setBlendMode(this.convertBlend(blendMode));
    }

    private RenderState.BlendMode convertBlend(BlendMode blendMode) {
        if (blendMode == null) {
            return RenderState.BlendMode.Off;
        }
        switch (blendMode) {
            case BLEND: {
                return RenderState.BlendMode.Alpha;
            }
            case MULIPLY: {
                return RenderState.BlendMode.Alpha;
            }
        }
        throw new UnsupportedOperationException();
    }

    private int convertColor(Color color) {
        int color2 = 0;
        color2 |= (int)(255.0 * (double)color.getAlpha()) << 24;
        color2 |= (int)(255.0 * (double)color.getBlue()) << 16;
        color2 |= (int)(255.0 * (double)color.getGreen()) << 8;
        return color2 |= (int)(255.0 * (double)color.getRed());
    }

    private ColorRGBA convertColor(Color inColor, ColorRGBA outColor) {
        return outColor.set(inColor.getRed(), inColor.getGreen(), inColor.getBlue(), inColor.getAlpha());
    }

    public void renderFont(RenderFont font, String str, int x, int y, Color color, float sizeX, float sizeY) {
        if (str.length() == 0) {
            return;
        }
        RenderFontJme jmeFont = (RenderFontJme)font;
        ColorRGBA colorRgba = this.convertColor(color, this.tempColor);
        CachedTextKey key = new CachedTextKey(jmeFont.getFont(), str);
        BitmapText text = this.textCacheLastFrame.get(key);
        if (text == null) {
            text = jmeFont.createText();
            text.setText(str);
            text.updateLogicalState(0.0f);
        }
        this.textCacheCurrentFrame.put(key, text);
        float x0 = x;
        float y0 = y;
        this.tempMat.loadIdentity();
        this.tempMat.setTranslation(x0, (float)this.getHeight() - y0, 0.0f);
        this.tempMat.setScale(sizeX, sizeY, 0.0f);
        this.rm.setWorldMatrix(this.tempMat);
        this.rm.setForcedRenderState(this.renderState);
        text.setColor(colorRgba);
        text.updateLogicalState(0.0f);
        text.render(this.rm, colorRgba);
    }

    public void renderImage(RenderImage image, int x, int y, int w, int h, int srcX, int srcY, int srcW, int srcH, Color color, float scale, int centerX, int centerY) {
        RenderImageJme jmeImage = (RenderImageJme)image;
        Texture2D texture = jmeImage.getTexture();
        this.textureColorMaterial.setColor("Color", this.convertColor(color, this.tempColor));
        this.textureColorMaterial.setTexture("ColorMap", (Texture)texture);
        float imageWidth = jmeImage.getWidth();
        float imageHeight = jmeImage.getHeight();
        FloatBuffer texCoords = (FloatBuffer)this.quadModTC.getData();
        float startX = (float)srcX / imageWidth;
        float startY = (float)srcY / imageHeight;
        float endX = startX + (float)srcW / imageWidth;
        float endY = startY + (float)srcH / imageHeight;
        startY = 1.0f - startY;
        endY = 1.0f - endY;
        texCoords.rewind();
        texCoords.put(startX).put(startY);
        texCoords.put(endX).put(startY);
        texCoords.put(endX).put(endY);
        texCoords.put(startX).put(endY);
        texCoords.flip();
        this.quadModTC.updateData((Buffer)texCoords);
        this.quad.clearBuffer(VertexBuffer.Type.TexCoord);
        this.quad.setBuffer(this.quadModTC);
        float x0 = (float)centerX + (float)(x - centerX) * scale;
        float y0 = (float)centerY + (float)(y - centerY) * scale;
        this.tempMat.loadIdentity();
        this.tempMat.setTranslation(x0, (float)this.getHeight() - y0, 0.0f);
        this.tempMat.setScale((float)w * scale, (float)h * scale, 0.0f);
        this.rm.setWorldMatrix(this.tempMat);
        this.rm.setForcedRenderState(this.renderState);
        this.textureColorMaterial.render(this.quadGeom, this.rm);
    }

    public void renderImage(RenderImage image, int x, int y, int width, int height, Color color, float imageScale) {
        RenderImageJme jmeImage = (RenderImageJme)image;
        this.textureColorMaterial.setColor("Color", this.convertColor(color, this.tempColor));
        this.textureColorMaterial.setTexture("ColorMap", (Texture)jmeImage.getTexture());
        this.quad.clearBuffer(VertexBuffer.Type.TexCoord);
        this.quad.setBuffer(this.quadDefaultTC);
        float x0 = (float)x + 0.5f * (float)width * (1.0f - imageScale);
        float y0 = (float)y + 0.5f * (float)height * (1.0f - imageScale);
        this.tempMat.loadIdentity();
        this.tempMat.setTranslation(x0, (float)this.getHeight() - y0, 0.0f);
        this.tempMat.setScale((float)width * imageScale, (float)height * imageScale, 0.0f);
        this.rm.setWorldMatrix(this.tempMat);
        this.rm.setForcedRenderState(this.renderState);
        this.textureColorMaterial.render(this.quadGeom, this.rm);
    }

    public void renderQuad(int x, int y, int width, int height, Color color) {
        if (color.getAlpha() > 0.0f) {
            this.colorMaterial.setColor("Color", this.convertColor(color, this.tempColor));
            this.tempMat.loadIdentity();
            this.tempMat.setTranslation((float)x, (float)(this.getHeight() - y), 0.0f);
            this.tempMat.setScale((float)width, (float)height, 0.0f);
            this.rm.setWorldMatrix(this.tempMat);
            this.rm.setForcedRenderState(this.renderState);
            this.colorMaterial.render(this.quadGeom, this.rm);
        }
    }

    public void renderQuad(int x, int y, int width, int height, Color topLeft, Color topRight, Color bottomRight, Color bottomLeft) {
        ByteBuffer buf = (ByteBuffer)this.quadColor.getData();
        buf.rewind();
        buf.putInt(this.convertColor(topRight));
        buf.putInt(this.convertColor(topLeft));
        buf.putInt(this.convertColor(bottomLeft));
        buf.putInt(this.convertColor(bottomRight));
        buf.flip();
        this.quadColor.updateData((Buffer)buf);
        this.tempMat.loadIdentity();
        this.tempMat.setTranslation((float)x, (float)(this.getHeight() - y), 0.0f);
        this.tempMat.setScale((float)width, (float)height, 0.0f);
        this.rm.setWorldMatrix(this.tempMat);
        this.rm.setForcedRenderState(this.renderState);
        this.vertexColorMaterial.render(this.quadGeom, this.rm);
    }

    public void enableClip(int x0, int y0, int x1, int y1) {
        this.clipWasSet = true;
        this.r.setClipRect(x0, this.getHeight() - y1, x1 - x0, y1 - y0);
    }

    public void disableClip() {
        if (this.clipWasSet) {
            this.r.clearClipRect();
            this.clipWasSet = false;
        }
    }

    private static class CachedTextKey {
        BitmapFont font;
        String text;

        public CachedTextKey(BitmapFont font, String text) {
            this.font = font;
            this.text = text;
        }

        public boolean equals(Object other) {
            CachedTextKey otherKey = (CachedTextKey)other;
            return this.font.equals(otherKey.font) && this.text.equals(otherKey.text);
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + this.font.hashCode();
            hash = 53 * hash + this.text.hashCode();
            return hash;
        }
    }
}

